/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.level.map.MapData;
import com.github.steveice10.mc.protocol.data.game.level.map.MapIcon;
import com.nukkitx.protocol.bedrock.data.MapDecoration;
import com.nukkitx.protocol.bedrock.data.MapTrackedObject;
import com.nukkitx.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import org.geysermc.geyser.level.BedrockMapIcon;
import org.geysermc.geyser.level.MapColor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;

@Translator(packet=com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundMapItemDataPacket.class)
public class JavaMapItemDataTranslator
extends PacketTranslator<com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundMapItemDataPacket> {
    @Override
    public void translate(GeyserSession session, com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundMapItemDataPacket packet) {
        ClientboundMapItemDataPacket mapItemDataPacket = new ClientboundMapItemDataPacket();
        boolean shouldStore = false;
        mapItemDataPacket.setUniqueMapId(packet.getMapId());
        mapItemDataPacket.setDimensionId(DimensionUtils.javaToBedrock(session.getDimension()));
        mapItemDataPacket.setLocked(packet.isLocked());
        mapItemDataPacket.setScale(packet.getScale());
        MapData data = packet.getData();
        if (data != null) {
            mapItemDataPacket.setXOffset(data.getX());
            mapItemDataPacket.setYOffset(data.getY());
            mapItemDataPacket.setWidth(data.getColumns());
            mapItemDataPacket.setHeight(data.getRows());
            if (mapItemDataPacket.getWidth() == 128 && mapItemDataPacket.getHeight() == 128) {
                shouldStore = true;
            }
            int[] colors = new int[data.getData().length];
            int idx = 0;
            byte[] byArray = data.getData();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte colorId = byArray[i];
                colors[idx++] = MapColor.fromId(colorId & 0xFF).getARGB();
            }
            mapItemDataPacket.setColors(colors);
        }
        int id = 0;
        for (MapIcon icon : packet.getIcons()) {
            BedrockMapIcon bedrockMapIcon = BedrockMapIcon.fromType(icon.getIconType());
            mapItemDataPacket.getTrackedObjects().add(new MapTrackedObject(id));
            mapItemDataPacket.getDecorations().add(new MapDecoration(bedrockMapIcon.getIconID(), icon.getIconRotation(), icon.getCenterX(), icon.getCenterZ(), "", bedrockMapIcon.toARGB()));
            ++id;
        }
        if (shouldStore) {
            session.getStoredMaps().put(mapItemDataPacket.getUniqueMapId(), (Object)mapItemDataPacket);
        }
        session.sendUpstreamPacket(mapItemDataPacket);
    }
}

