/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.level.event.BonemealGrowEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakBlockEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakPotionEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.ComposterEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.DragonFireballEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEvent;
import com.github.steveice10.mc.protocol.data.game.level.event.RecordEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SculkBlockChargeEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SmokeEventData;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundLevelEventPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.packet.LevelEventGenericPacket;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEventPacket;
import com.nukkitx.protocol.bedrock.packet.TextPacket;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.level.event.LevelEventTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundLevelEventPacket.class)
public class JavaLevelEventTranslator
extends PacketTranslator<ClientboundLevelEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLevelEventPacket packet) {
        if (packet.getEvent() == LevelEvent.RECORD) {
            RecordEventData recordEventData = (RecordEventData)packet.getData();
            SoundEvent soundEvent = Registries.RECORDS.getOrDefault(recordEventData.getRecordId(), SoundEvent.STOP_RECORD);
            Vector3i origin = packet.getPosition();
            Vector3f pos = Vector3f.from((float)origin.getX() + 0.5f, (float)origin.getY() + 0.5f, (float)origin.getZ() + 0.5f);
            LevelSoundEventPacket levelSoundEvent = new LevelSoundEventPacket();
            levelSoundEvent.setIdentifier("");
            levelSoundEvent.setSound(soundEvent);
            levelSoundEvent.setPosition(pos);
            levelSoundEvent.setRelativeVolumeDisabled(packet.isBroadcast());
            levelSoundEvent.setExtraData(-1);
            levelSoundEvent.setBabySound(false);
            session.sendUpstreamPacket(levelSoundEvent);
            if (soundEvent != SoundEvent.STOP_RECORD) {
                TextPacket textPacket = new TextPacket();
                textPacket.setType(TextPacket.Type.JUKEBOX_POPUP);
                textPacket.setNeedsTranslation(true);
                textPacket.setXuid("");
                textPacket.setPlatformChatId("");
                textPacket.setSourceName(null);
                textPacket.setMessage("record.nowPlaying");
                String recordString = "%item." + soundEvent.name().toLowerCase(Locale.ROOT) + ".desc";
                textPacket.setParameters(Collections.singletonList(MinecraftLocale.getLocaleString(recordString, session.getLocale())));
                session.sendUpstreamPacket(textPacket);
            }
            return;
        }
        LevelEventTranslator transformer = (LevelEventTranslator)Registries.SOUND_LEVEL_EVENTS.get(packet.getEvent());
        if (transformer != null) {
            transformer.translate(session, packet);
            return;
        }
        Vector3i origin = packet.getPosition();
        Vector3f pos = Vector3f.from((float)origin.getX() + 0.5f, (float)origin.getY() + 0.5f, (float)origin.getZ() + 0.5f);
        LevelEventPacket effectPacket = new LevelEventPacket();
        effectPacket.setPosition(pos);
        effectPacket.setData(0);
        switch (packet.getEvent()) {
            case COMPOSTER: {
                effectPacket.setType(LevelEventType.PARTICLE_CROP_GROWTH);
                ComposterEventData composterEventData = (ComposterEventData)packet.getData();
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                switch (composterEventData) {
                    case FILL: {
                        soundEventPacket.setSound(SoundEvent.COMPOSTER_FILL);
                        break;
                    }
                    case FILL_SUCCESS: {
                        soundEventPacket.setSound(SoundEvent.COMPOSTER_FILL_LAYER);
                    }
                }
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case BLOCK_LAVA_EXTINGUISH: {
                effectPacket.setType(LevelEventType.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.7f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXTINGUISH_FIRE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case BLOCK_REDSTONE_TORCH_BURNOUT: {
                effectPacket.setType(LevelEventType.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.0f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXTINGUISH_FIRE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case BLOCK_END_PORTAL_FRAME_FILL: {
                effectPacket.setType(LevelEventType.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.3125f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.BLOCK_END_PORTAL_FRAME_FILL);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case SMOKE: {
                effectPacket.setType(LevelEventType.PARTICLE_SHOOT);
                SmokeEventData smokeEventData = (SmokeEventData)packet.getData();
                int data = 0;
                switch (smokeEventData) {
                    case DOWN: {
                        data = 4;
                        pos = pos.add(0.0f, -0.9f, 0.0f);
                        break;
                    }
                    case UP: {
                        data = 4;
                        pos = pos.add(0.0f, 0.5f, 0.0f);
                        break;
                    }
                    case NORTH: {
                        data = 1;
                        pos = pos.add(0.0f, -0.2f, -0.7f);
                        break;
                    }
                    case SOUTH: {
                        data = 7;
                        pos = pos.add(0.0f, -0.2f, 0.7f);
                        break;
                    }
                    case WEST: {
                        data = 3;
                        pos = pos.add(-0.7f, -0.2f, 0.0f);
                        break;
                    }
                    case EAST: {
                        data = 5;
                        pos = pos.add(0.7f, -0.2f, 0.0f);
                    }
                }
                effectPacket.setPosition(pos);
                effectPacket.setData(data);
                break;
            }
            case BREAK_BLOCK: {
                effectPacket.setType(LevelEventType.PARTICLE_DESTROY_BLOCK);
                BreakBlockEventData breakBlockEventData = (BreakBlockEventData)packet.getData();
                effectPacket.setData(session.getBlockMappings().getBedrockBlockId(breakBlockEventData.getBlockState()));
                break;
            }
            case BREAK_SPLASH_POTION: 
            case BREAK_SPLASH_POTION2: {
                effectPacket.setType(LevelEventType.PARTICLE_POTION_SPLASH);
                effectPacket.setPosition(pos.add(0.0f, -0.5f, 0.0f));
                BreakPotionEventData splashPotionData = (BreakPotionEventData)packet.getData();
                effectPacket.setData(splashPotionData.getPotionId());
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.GLASS);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case BREAK_EYE_OF_ENDER: {
                effectPacket.setType(LevelEventType.PARTICLE_EYE_OF_ENDER_DEATH);
                break;
            }
            case MOB_SPAWN: {
                effectPacket.setType(LevelEventType.PARTICLE_MOB_BLOCK_SPAWN);
                break;
            }
            case BONEMEAL_GROW_WITH_SOUND: 
            case BONEMEAL_GROW: {
                effectPacket.setType(packet.getEvent() == LevelEvent.BONEMEAL_GROW ? LevelEventType.PARTICLE_TURTLE_EGG : LevelEventType.PARTICLE_CROP_GROWTH);
                BonemealGrowEventData growEventData = (BonemealGrowEventData)packet.getData();
                effectPacket.setData(growEventData.getParticleCount());
                break;
            }
            case ENDERDRAGON_FIREBALL_EXPLODE: {
                effectPacket.setType(LevelEventType.PARTICLE_EYE_OF_ENDER_DEATH);
                DragonFireballEventData fireballEventData = (DragonFireballEventData)packet.getData();
                if (fireballEventData != DragonFireballEventData.HAS_SOUND) break;
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXPLODE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case EXPLOSION: {
                effectPacket.setType(LevelEventType.PARTICLE_GENERIC_SPAWN);
                effectPacket.setData(61);
                break;
            }
            case EVAPORATE: {
                effectPacket.setType(LevelEventType.PARTICLE_EVAPORATE_WATER);
                effectPacket.setPosition(pos.add(-0.5f, 0.5f, -0.5f));
                break;
            }
            case END_GATEWAY_SPAWN: {
                effectPacket.setType(LevelEventType.PARTICLE_EXPLOSION);
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXPLODE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case DRIPSTONE_DRIP: {
                effectPacket.setType(LevelEventType.PARTICLE_DRIPSTONE_DRIP);
                break;
            }
            case ELECTRIC_SPARK: {
                effectPacket.setType(LevelEventType.PARTICLE_ELECTRIC_SPARK);
                break;
            }
            case WAX_ON: {
                effectPacket.setType(LevelEventType.PARTICLE_WAX_ON);
                break;
            }
            case WAX_OFF: {
                effectPacket.setType(LevelEventType.PARTICLE_WAX_OFF);
                break;
            }
            case SCRAPE: {
                effectPacket.setType(LevelEventType.PARTICLE_SCRAPE);
                break;
            }
            case SCULK_BLOCK_CHARGE: {
                SculkBlockChargeEventData eventData = (SculkBlockChargeEventData)packet.getData();
                LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
                if (eventData.getCharge() > 0) {
                    levelEventPacket.setEventId(2037);
                    levelEventPacket.setTag(NbtMap.builder().putInt("x", packet.getPosition().getX()).putInt("y", packet.getPosition().getY()).putInt("z", packet.getPosition().getZ()).putShort("charge", (short)eventData.getCharge()).putShort("facing", this.encodeFacing(eventData.getBlockFaces())).build());
                } else {
                    levelEventPacket.setEventId(2038);
                    levelEventPacket.setTag(NbtMap.builder().putInt("x", packet.getPosition().getX()).putInt("y", packet.getPosition().getY()).putInt("z", packet.getPosition().getZ()).build());
                }
                session.sendUpstreamPacket(levelEventPacket);
                return;
            }
            case SCULK_SHRIEKER_SHRIEK: {
                LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
                levelEventPacket.setEventId(2035);
                levelEventPacket.setTag(NbtMap.builder().putInt("originX", packet.getPosition().getX()).putInt("originY", packet.getPosition().getY()).putInt("originZ", packet.getPosition().getZ()).build());
                session.sendUpstreamPacket(levelEventPacket);
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.SCULK_SHRIEKER_SHRIEK);
                soundEventPacket.setPosition(packet.getPosition().toFloat());
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                return;
            }
            default: {
                GeyserImpl.getInstance().getLogger().debug("Unhandled level event: " + packet.getEvent());
                return;
            }
        }
        session.sendUpstreamPacket(effectPacket);
    }

    private short encodeFacing(Set<Direction> blockFaces) {
        short facing = 0;
        if (blockFaces.contains(Direction.DOWN)) {
            facing = (short)(facing | 1);
        }
        if (blockFaces.contains(Direction.UP)) {
            facing = (short)(facing | 2);
        }
        if (blockFaces.contains(Direction.SOUTH)) {
            facing = (short)(facing | 4);
        }
        if (blockFaces.contains(Direction.WEST)) {
            facing = (short)(facing | 8);
        }
        if (blockFaces.contains(Direction.NORTH)) {
            facing = (short)(facing | 0x10);
        }
        if (blockFaces.contains(Direction.EAST)) {
            facing = (short)(facing | 0x20);
        }
        return facing;
    }
}

