/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.chunk.BitStorage;
import com.github.steveice10.mc.protocol.data.game.chunk.ChunkSection;
import com.github.steveice10.mc.protocol.data.game.chunk.DataPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.GlobalPalette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.mc.protocol.data.game.chunk.palette.SingletonPalette;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityInfo;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundLevelChunkWithLightPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NBTOutputStream;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.packet.LevelChunkPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.GeyserChunkSection;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.SkullBlockEntityTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.ChunkUtils;

@Translator(packet=ClientboundLevelChunkWithLightPacket.class)
public class JavaLevelChunkWithLightTranslator
extends PacketTranslator<ClientboundLevelChunkWithLightPacket> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(GeyserSession session, ClientboundLevelChunkWithLightPacket packet) {
        byte[] payload;
        int sectionCount;
        if (session.isSpawned()) {
            ChunkUtils.updateChunkPosition(session, session.getPlayerEntity().getPosition().toInt());
        }
        int yOffset = session.getChunkCache().getChunkMinY();
        int chunkSize = session.getChunkCache().getChunkHeightY();
        int biomeGlobalPalette = session.getBiomeGlobalPalette();
        DataPalette[] javaChunks = new DataPalette[chunkSize];
        DataPalette[] javaBiomes = new DataPalette[chunkSize];
        BlockEntityInfo[] blockEntities = packet.getBlockEntities();
        ObjectArrayList bedrockBlockEntities = new ObjectArrayList(blockEntities.length);
        BitSet waterloggedPaletteIds = new BitSet();
        BitSet bedrockOnlyBlockEntityIds = new BitSet();
        BedrockDimension bedrockDimension = session.getChunkCache().getBedrockDimension();
        int maxBedrockSectionY = (bedrockDimension.height() >> 4) - 1;
        ReferenceCounted byteBuf = null;
        GeyserChunkSection[] sections = new GeyserChunkSection[javaChunks.length - (yOffset + (bedrockDimension.minY() >> 4))];
        try {
            int i;
            ByteBuf in = Unpooled.wrappedBuffer(packet.getChunkData());
            for (int sectionY = 0; sectionY < chunkSize; ++sectionY) {
                BlockStorage[] layers;
                ChunkSection javaSection = session.getCodecHelper().readChunkSection(in, biomeGlobalPalette);
                javaChunks[sectionY] = javaSection.getChunkData();
                javaBiomes[sectionY] = javaSection.getBiomeData();
                int bedrockSectionY = sectionY + (yOffset - (bedrockDimension.minY() >> 4));
                if (bedrockSectionY < 0 || maxBedrockSectionY < bedrockSectionY || javaSection.isBlockCountEmpty()) continue;
                Palette javaPalette = javaSection.getChunkData().getPalette();
                BitStorage javaData = javaSection.getChunkData().getStorage();
                if (javaPalette instanceof GlobalPalette) {
                    GeyserChunkSection section = new GeyserChunkSection(session.getBlockMappings().getBedrockAirId());
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int javaId = javaData.get(yzx);
                        int bedrockId = session.getBlockMappings().getBedrockBlockId(javaId);
                        int xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        section.getBlockStorageArray()[0].setFullBlock(xzy, bedrockId);
                        if (((IntSet)BlockRegistries.WATERLOGGED.get()).contains(javaId)) {
                            section.getBlockStorageArray()[1].setFullBlock(xzy, session.getBlockMappings().getBedrockWaterId());
                        }
                        if (!BlockStateValues.getFlowerPotValues().containsKey(javaId) && !BlockStateValues.getPistonValues().containsKey(javaId) && !BlockStateValues.isNonWaterCauldron(javaId)) continue;
                        bedrockBlockEntities.add(BedrockOnlyBlockEntity.getTag(session, Vector3i.from((packet.getX() << 4) + (yzx & 0xF), (sectionY + yOffset << 4) + (yzx >> 8 & 0xF), (packet.getZ() << 4) + (yzx >> 4 & 0xF)), javaId));
                    }
                    sections[bedrockSectionY] = section;
                    continue;
                }
                if (javaPalette instanceof SingletonPalette) {
                    int javaId = javaPalette.idToState(0);
                    int bedrockId = session.getBlockMappings().getBedrockBlockId(javaId);
                    BlockStorage blockStorage = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton((int)bedrockId));
                    if (((IntSet)BlockRegistries.WATERLOGGED.get()).contains(javaId)) {
                        BlockStorage waterlogged = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton((int)session.getBlockMappings().getBedrockWaterId()));
                        sections[bedrockSectionY] = new GeyserChunkSection(new BlockStorage[]{blockStorage, waterlogged});
                        continue;
                    }
                    sections[bedrockSectionY] = new GeyserChunkSection(new BlockStorage[]{blockStorage});
                    continue;
                }
                IntArrayList bedrockPalette = new IntArrayList(javaPalette.size());
                waterloggedPaletteIds.clear();
                bedrockOnlyBlockEntityIds.clear();
                for (int i2 = 0; i2 < javaPalette.size(); ++i2) {
                    int javaId = javaPalette.idToState(i2);
                    bedrockPalette.add(session.getBlockMappings().getBedrockBlockId(javaId));
                    if (((IntSet)BlockRegistries.WATERLOGGED.get()).contains(javaId)) {
                        waterloggedPaletteIds.set(i2);
                    }
                    if (!BlockStateValues.getFlowerPotValues().containsKey(javaId) && !BlockStateValues.getPistonValues().containsKey(javaId) && !BlockStateValues.isNonWaterCauldron(javaId)) continue;
                    bedrockOnlyBlockEntityIds.set(i2);
                }
                if (!bedrockOnlyBlockEntityIds.isEmpty()) {
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int paletteId = javaData.get(yzx);
                        if (!bedrockOnlyBlockEntityIds.get(paletteId)) continue;
                        bedrockBlockEntities.add(BedrockOnlyBlockEntity.getTag(session, Vector3i.from((packet.getX() << 4) + (yzx & 0xF), (sectionY + yOffset << 4) + (yzx >> 8 & 0xF), (packet.getZ() << 4) + (yzx >> 4 & 0xF)), javaPalette.idToState(paletteId)));
                    }
                }
                BitArray bedrockData = BitArrayVersion.forBitsCeil(javaData.getBitsPerEntry()).createArray(4096);
                BlockStorage layer0 = new BlockStorage(bedrockData, (IntList)bedrockPalette);
                if (waterloggedPaletteIds.isEmpty()) {
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        bedrockData.set(ChunkUtils.indexYZXtoXZY(yzx), javaData.get(yzx));
                    }
                    layers = new BlockStorage[]{layer0};
                } else {
                    int[] layer1Data = new int[128];
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int paletteId = javaData.get(yzx);
                        int xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        bedrockData.set(xzy, paletteId);
                        if (!waterloggedPaletteIds.get(paletteId)) continue;
                        int n = xzy >> 5;
                        layer1Data[n] = layer1Data[n] | 1 << (xzy & 0x1F);
                    }
                    IntList layer1Palette = IntList.of((int)session.getBlockMappings().getBedrockAirId(), (int)session.getBlockMappings().getBedrockWaterId());
                    layers = new BlockStorage[]{layer0, new BlockStorage(BitArrayVersion.V1.createArray(4096, layer1Data), layer1Palette)};
                }
                sections[bedrockSectionY] = new GeyserChunkSection(layers);
            }
            session.getChunkCache().addToCache(packet.getX(), packet.getZ(), javaChunks);
            int chunkBlockX = packet.getX() << 4;
            int chunkBlockZ = packet.getZ() << 4;
            for (BlockEntityInfo blockEntity : blockEntities) {
                BlockEntityType type = blockEntity.getType();
                if (type == null) continue;
                CompoundTag tag = blockEntity.getNbt();
                int x = blockEntity.getX();
                int y = blockEntity.getY();
                int z = blockEntity.getZ();
                DataPalette section = javaChunks[(y >> 4) - yOffset];
                int blockState = section.get(x, y & 0xF, z);
                if (type == BlockEntityType.LECTERN && BlockStateValues.getLecternBookStates().get(blockState)) {
                    bedrockBlockEntities.add(session.getGeyser().getWorldManager().getLecternDataAt(session, x + chunkBlockX, y, z + chunkBlockZ, true));
                    continue;
                }
                BlockEntityTranslator blockEntityTranslator = BlockEntityUtils.getBlockEntityTranslator(type);
                bedrockBlockEntities.add(blockEntityTranslator.getBlockEntityTag(type, x + chunkBlockX, y, z + chunkBlockZ, tag, blockState));
                if (!session.getPreferencesCache().showCustomSkulls() || type != BlockEntityType.SKULL || tag == null || !tag.contains("SkullOwner")) continue;
                SkullBlockEntityTranslator.translateSkull(session, tag, x + chunkBlockX, y, z + chunkBlockZ, blockState);
            }
            for (sectionCount = sections.length - 1; sectionCount >= 0 && sections[sectionCount] == null; --sectionCount) {
            }
            ++sectionCount;
            int size = 0;
            for (i = 0; i < sectionCount; ++i) {
                GeyserChunkSection section = sections[i];
                if (section != null) {
                    size += section.estimateNetworkSize();
                    continue;
                }
                size += ChunkUtils.SERIALIZED_CHUNK_DATA.length;
            }
            size += ChunkUtils.EMPTY_CHUNK_DATA.length;
            ++size;
            ++size;
            byteBuf = ByteBufAllocator.DEFAULT.buffer(size += bedrockBlockEntities.size() * 64);
            for (i = 0; i < sectionCount; ++i) {
                GeyserChunkSection section = sections[i];
                if (section != null) {
                    section.writeToNetwork((ByteBuf)byteBuf);
                    continue;
                }
                ((ByteBuf)byteBuf).writeBytes(ChunkUtils.SERIALIZED_CHUNK_DATA);
            }
            int biomeCount = bedrockDimension.height() >> 4;
            int dimensionOffset = bedrockDimension.minY() >> 4;
            for (int i3 = 0; i3 < biomeCount; ++i3) {
                int biomeYOffset = dimensionOffset + i3;
                if (biomeYOffset < yOffset) {
                    ((ByteBuf)byteBuf).writeBytes(ChunkUtils.EMPTY_BIOME_DATA);
                    continue;
                }
                if (biomeYOffset >= chunkSize + yOffset) {
                    ((ByteBuf)byteBuf).writeByte(255);
                    continue;
                }
                BiomeTranslator.toNewBedrockBiome(session, javaBiomes[i3 + (dimensionOffset - yOffset)]).writeToNetwork((ByteBuf)byteBuf);
            }
            ((ByteBuf)byteBuf).writeByte(0);
            VarInts.writeUnsignedInt((ByteBuf)byteBuf, 0);
            NBTOutputStream nbtStream = NbtUtils.createNetworkWriter(new ByteBufOutputStream((ByteBuf)byteBuf));
            for (NbtMap blockEntity : bedrockBlockEntities) {
                nbtStream.writeTag(blockEntity);
            }
            payload = new byte[((ByteBuf)byteBuf).readableBytes()];
            ((ByteBuf)byteBuf).readBytes(payload);
        }
        catch (IOException e) {
            session.getGeyser().getLogger().error("IO error while encoding chunk", e);
            return;
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        LevelChunkPacket levelChunkPacket = new LevelChunkPacket();
        levelChunkPacket.setSubChunksLength(sectionCount);
        levelChunkPacket.setCachingEnabled(false);
        levelChunkPacket.setChunkX(packet.getX());
        levelChunkPacket.setChunkZ(packet.getZ());
        levelChunkPacket.setData(payload);
        session.sendUpstreamPacket(levelChunkPacket);
        for (Map.Entry<Vector3i, ItemFrameEntity> entry : session.getItemFrameCache().entrySet()) {
            Vector3i position = entry.getKey();
            if (position.getX() >> 4 != packet.getX() || position.getZ() >> 4 != packet.getZ()) continue;
            entry.getValue().updateBlock(true);
        }
    }
}

