/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetContentPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundContainerSetContentPacket.class)
public class JavaContainerSetContentTranslator
extends PacketTranslator<ClientboundContainerSetContentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetContentPacket packet) {
        int stateId;
        Inventory inventory = InventoryUtils.getInventory(session, packet.getContainerId());
        if (inventory == null) {
            return;
        }
        int inventorySize = inventory.getSize();
        for (int i = 0; i < packet.getItems().length; ++i) {
            if (i > inventorySize) {
                InventoryTranslator translator;
                GeyserImpl geyser = session.getGeyser();
                geyser.getLogger().warning("ClientboundContainerSetContentPacket sent to " + session.name() + " that exceeds inventory size!");
                if (geyser.getConfig().isDebugMode()) {
                    geyser.getLogger().debug(packet);
                    geyser.getLogger().debug(inventory);
                }
                if ((translator = session.getInventoryTranslator()) != null) {
                    translator.updateInventory(session, inventory);
                }
                return;
            }
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItems()[i]);
            inventory.setItem(i, newItem, session);
        }
        InventoryTranslator translator = session.getInventoryTranslator();
        if (translator != null) {
            translator.updateInventory(session, inventory);
        }
        session.setEmulatePost1_16Logic((stateId = packet.getStateId()) > 0 || stateId != inventory.getStateId());
        inventory.setStateId(stateId);
        session.getPlayerInventory().setCursor(GeyserItemStack.from(packet.getCarriedItem()), session);
        InventoryUtils.updateCursor(session);
    }
}

