/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.spawn;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.spawn.ClientboundAddPlayerPacket;
import com.nukkitx.math.vector.Vector3f;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundAddPlayerPacket.class)
public class JavaAddPlayerTranslator
extends PacketTranslator<ClientboundAddPlayerPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundAddPlayerPacket packet) {
        PlayerEntity entity;
        Vector3f position = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
        float yaw = packet.getYaw();
        float pitch = packet.getPitch();
        float headYaw = packet.getYaw();
        if (packet.getUuid().equals(session.getPlayerEntity().getUuid())) {
            entity = new PlayerEntity(session, packet.getEntityId(), session.getEntityCache().getNextEntityId().incrementAndGet(), session.getPlayerEntity().getUuid(), position, Vector3f.ZERO, yaw, pitch, headYaw, session.getPlayerEntity().getUsername(), session.getPlayerEntity().getTexturesProperty());
        } else {
            entity = session.getEntityCache().getPlayerEntity(packet.getUuid());
            if (entity == null) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.entity.player.failed_list", packet.getUuid()));
                return;
            }
            entity.setEntityId(packet.getEntityId());
            entity.setPosition(position);
            entity.setYaw(yaw);
            entity.setPitch(pitch);
            entity.setHeadYaw(headYaw);
        }
        session.getEntityCache().cacheEntity(entity);
        entity.sendPlayer();
        SkinManager.requestAndHandleSkinAndCape(entity, session, null);
    }
}

