/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.ClientboundSetEntityLinkPacket;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundSetEntityLinkPacket.class)
public class JavaSetEntityLinkTranslator
extends PacketTranslator<ClientboundSetEntityLinkPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEntityLinkPacket packet) {
        Entity holderId = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        Entity entity = holderId;
        if (!(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        Entity attachedToId = session.getEntityCache().getEntityByJavaId(packet.getAttachedToId());
        if (attachedToId == null || packet.getAttachedToId() == 0) {
            mobEntity.setFlag(EntityFlag.LEASHED, false);
            mobEntity.setLeashHolderBedrockId(-1L);
            mobEntity.updateBedrockMetadata();
            EntityEventPacket eventPacket = new EntityEventPacket();
            eventPacket.setRuntimeEntityId(holderId.getGeyserId());
            eventPacket.setType(EntityEventType.REMOVE_LEASH);
            eventPacket.setData(0);
            session.sendUpstreamPacket(eventPacket);
            return;
        }
        mobEntity.setFlag(EntityFlag.LEASHED, true);
        mobEntity.setLeashHolderBedrockId(attachedToId.getGeyserId());
        holderId.updateBedrockMetadata();
    }
}

