/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.Recipe;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapedRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.ShapelessRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.SmithingRecipeData;
import com.github.steveice10.mc.protocol.data.game.recipe.data.StoneCuttingRecipeData;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundUpdateRecipesPacket;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundUpdateRecipesPacket.class)
public class JavaUpdateRecipesTranslator
extends PacketTranslator<ClientboundUpdateRecipesPacket> {
    private static final List<CraftingData> CARTOGRAPHY_RECIPES = Arrays.asList(CraftingData.fromMulti(UUID.fromString("8b36268c-1829-483c-a0f1-993b7156a8f2"), ++InventoryUtils.LAST_RECIPE_NET_ID), CraftingData.fromMulti(UUID.fromString("442d85ed-8272-4543-a6f1-418f90ded05d"), ++InventoryUtils.LAST_RECIPE_NET_ID), CraftingData.fromMulti(UUID.fromString("98c84b38-1085-46bd-b1ce-dd38c159e6cc"), ++InventoryUtils.LAST_RECIPE_NET_ID), CraftingData.fromMulti(UUID.fromString("602234e4-cac1-4353-8bb7-b1ebff70024b"), ++InventoryUtils.LAST_RECIPE_NET_ID));

    @Override
    public void translate(GeyserSession session, ClientboundUpdateRecipesPacket packet) {
        Map<RecipeType, List<CraftingData>> recipeTypes = Registries.CRAFTING_DATA.forVersion(session.getUpstream().getProtocolVersion());
        int netId = InventoryUtils.LAST_RECIPE_NET_ID + 1;
        Int2ObjectOpenHashMap recipeMap = new Int2ObjectOpenHashMap(Registries.RECIPES.forVersion(session.getUpstream().getProtocolVersion()));
        Int2ObjectOpenHashMap unsortedStonecutterData = new Int2ObjectOpenHashMap();
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        craftingDataPacket.setCleanRecipes(true);
        block6: for (Recipe recipe : packet.getRecipes()) {
            switch (recipe.getType()) {
                case CRAFTING_SHAPELESS: {
                    UUID uuid;
                    ItemData[] inputs;
                    int n;
                    ItemData[][] inputCombinations;
                    ShapelessRecipeData shapelessRecipeData = (ShapelessRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, shapelessRecipeData.getResult());
                    if (output.equals(ItemData.AIR)) continue block6;
                    output = output.toBuilder().tag(null).build();
                    ItemData[][] itemDataArray = inputCombinations = this.combinations(session, shapelessRecipeData.getIngredients());
                    int n2 = itemDataArray.length;
                    for (n = 0; n < n2; ++n) {
                        inputs = itemDataArray[n];
                        uuid = UUID.randomUUID();
                        craftingDataPacket.getCraftingData().add(CraftingData.fromShapeless(uuid.toString(), Arrays.asList(inputs), Collections.singletonList(output), uuid, "crafting_table", 0, netId));
                        recipeMap.put(netId++, (Object)new GeyserShapelessRecipe(shapelessRecipeData));
                    }
                    continue block6;
                }
                case CRAFTING_SHAPED: {
                    UUID uuid;
                    ItemData[] inputs;
                    int n;
                    ItemData[][] inputCombinations;
                    ShapedRecipeData shapedRecipeData = (ShapedRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, shapedRecipeData.getResult());
                    if (output.equals(ItemData.AIR)) continue block6;
                    output = output.toBuilder().tag(null).build();
                    ItemData[][] itemDataArray = inputCombinations = this.combinations(session, shapedRecipeData.getIngredients());
                    int n2 = itemDataArray.length;
                    for (n = 0; n < n2; ++n) {
                        inputs = itemDataArray[n];
                        uuid = UUID.randomUUID();
                        craftingDataPacket.getCraftingData().add(CraftingData.fromShaped(uuid.toString(), shapedRecipeData.getWidth(), shapedRecipeData.getHeight(), Arrays.asList(inputs), Collections.singletonList(output), uuid, "crafting_table", 0, netId));
                        recipeMap.put(netId++, (Object)new GeyserShapedRecipe(shapedRecipeData));
                    }
                    continue block6;
                }
                case STONECUTTING: {
                    StoneCuttingRecipeData stoneCuttingData = (StoneCuttingRecipeData)recipe.getData();
                    ItemStack ingredient = stoneCuttingData.getIngredient().getOptions()[0];
                    Object data = (List)unsortedStonecutterData.get(ingredient.getId());
                    if (data == null) {
                        data = new ArrayList();
                        unsortedStonecutterData.put(ingredient.getId(), data);
                    }
                    data.add(stoneCuttingData);
                    continue block6;
                }
                case SMITHING: {
                    SmithingRecipeData recipeData = (SmithingRecipeData)recipe.getData();
                    ItemData output = ItemTranslator.translateToBedrock(session, recipeData.getResult());
                    for (ItemStack base : recipeData.getBase().getOptions()) {
                        ItemData bedrockBase = ItemTranslator.translateToBedrock(session, base);
                        for (ItemStack addition : recipeData.getAddition().getOptions()) {
                            ItemData bedrockAddition = ItemTranslator.translateToBedrock(session, addition);
                            UUID uuid = UUID.randomUUID();
                            craftingDataPacket.getCraftingData().add(CraftingData.fromShapeless(uuid.toString(), Arrays.asList(bedrockBase, bedrockAddition), Collections.singletonList(output), uuid, "smithing_table", 2, netId++));
                        }
                    }
                    continue block6;
                }
                default: {
                    List<CraftingData> craftingData = recipeTypes.get((Object)recipe.getType());
                    if (craftingData == null) continue block6;
                    craftingDataPacket.getCraftingData().addAll(craftingData);
                }
            }
        }
        craftingDataPacket.getCraftingData().addAll(CARTOGRAPHY_RECIPES);
        craftingDataPacket.getPotionMixData().addAll((Collection)Registries.POTION_MIXES.get());
        Int2ObjectOpenHashMap stonecutterRecipeMap = new Int2ObjectOpenHashMap();
        for (Int2ObjectMap.Entry data : unsortedStonecutterData.int2ObjectEntrySet()) {
            ((List)data.getValue()).sort(Comparator.comparing(stoneCuttingRecipeData -> session.getItemMappings().getMapping(stoneCuttingRecipeData.getResult()).getJavaIdentifier()));
            int buttonId = 0;
            for (StoneCuttingRecipeData stoneCuttingData : (List)data.getValue()) {
                ItemStack ingredient = stoneCuttingData.getIngredient().getOptions()[0];
                ItemData input = ItemTranslator.translateToBedrock(session, ingredient);
                ItemStack javaOutput = stoneCuttingData.getResult();
                ItemData output = ItemTranslator.translateToBedrock(session, javaOutput);
                if (input.equals(ItemData.AIR) || output.equals(ItemData.AIR)) continue;
                UUID uuid = UUID.randomUUID();
                craftingDataPacket.getCraftingData().add(CraftingData.fromShapeless(uuid.toString(), Collections.singletonList(input), Collections.singletonList(output), uuid, "stonecutter", 0, netId));
                stonecutterRecipeMap.put(netId++, (Object)new GeyserStonecutterData(buttonId++, javaOutput));
            }
        }
        session.sendUpstreamPacket(craftingDataPacket);
        session.setCraftingRecipes((Int2ObjectMap<GeyserRecipe>)recipeMap);
        session.setStonecutterRecipes((Int2ObjectMap<GeyserStonecutterData>)stonecutterRecipeMap);
        session.getLastRecipeNetId().set(netId);
    }

    private ItemData[][] combinations(GeyserSession session, Ingredient[] ingredients) {
        HashMap<Set, IntSet> squashedOptions = new HashMap<Set, IntSet>();
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i].getOptions().length == 0) {
                squashedOptions.computeIfAbsent(Collections.singleton(ItemData.AIR), k -> new IntOpenHashSet()).add(i);
                continue;
            }
            Ingredient ingredient = ingredients[i];
            Map<GroupedItem, List<ItemData>> groupedByIds = Arrays.stream(ingredient.getOptions()).map(item -> ItemTranslator.translateToBedrock(session, item)).collect(Collectors.groupingBy(item -> new GroupedItem(item.getId(), item.getCount(), item.getTag())));
            HashSet<ItemData> optionSet = new HashSet<ItemData>(groupedByIds.size());
            for (Map.Entry<GroupedItem, List<ItemData>> entry : groupedByIds.entrySet()) {
                if (entry.getValue().size() > 1) {
                    GroupedItem groupedItem = entry.getKey();
                    int idCount = 0;
                    for (ItemMapping mapping : session.getItemMappings().getItems()) {
                        if (mapping.getBedrockId() != groupedItem.id) continue;
                        ++idCount;
                    }
                    if (entry.getValue().size() < idCount) {
                        optionSet.addAll((Collection)entry.getValue());
                        continue;
                    }
                    optionSet.add(ItemData.builder().id(groupedItem.id).damage(Short.MAX_VALUE).count(groupedItem.count).tag(groupedItem.tag).build());
                    continue;
                }
                ItemData item2 = entry.getValue().get(0);
                optionSet.add(item2);
            }
            squashedOptions.computeIfAbsent(optionSet, k -> new IntOpenHashSet()).add(i);
        }
        int totalCombinations = 1;
        for (Set optionSet : squashedOptions.keySet()) {
            totalCombinations *= optionSet.size();
        }
        if (totalCombinations > 500) {
            ItemData[] translatedItems = new ItemData[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                translatedItems[i] = ingredients[i].getOptions().length > 0 ? ItemTranslator.translateToBedrock(session, ingredients[i].getOptions()[0]) : ItemData.AIR;
            }
            return new ItemData[][]{translatedItems};
        }
        ArrayList sortedSets = new ArrayList(squashedOptions.keySet());
        sortedSets.sort(Comparator.comparing(Set::size, Comparator.reverseOrder()));
        ItemData[][] combinations = new ItemData[totalCombinations][ingredients.length];
        int x = 1;
        for (Set set : sortedSets) {
            IntSet slotSet = (IntSet)squashedOptions.get(set);
            int i = 0;
            for (ItemData item3 : set) {
                for (int j = 0; j < totalCombinations / set.size(); ++j) {
                    int comboIndex = i * x + j % x + j / x * set.size() * x;
                    IntIterator intIterator = slotSet.iterator();
                    while (intIterator.hasNext()) {
                        int slot = (Integer)intIterator.next();
                        combinations[comboIndex][slot] = item3;
                    }
                }
                ++i;
            }
            x *= set.size();
        }
        return combinations;
    }

    private static class GroupedItem {
        int id;
        int count;
        NbtMap tag;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupedItem)) {
                return false;
            }
            GroupedItem other = (GroupedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            NbtMap this$tag = this.tag;
            NbtMap other$tag = other.tag;
            return !(this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupedItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.id;
            result = result * 59 + this.count;
            NbtMap $tag = this.tag;
            result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
            return result;
        }

        public GroupedItem(int id, int count, NbtMap tag) {
            this.id = id;
            this.count = count;
            this.tag = tag;
        }
    }
}

