/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundPlayerChatPacket;
import com.nukkitx.protocol.bedrock.packet.TextPacket;
import java.util.ArrayList;
import java.util.Set;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TranslatableComponent;

@Translator(packet=ClientboundPlayerChatPacket.class)
public class JavaPlayerChatTranslator
extends PacketTranslator<ClientboundPlayerChatPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerChatPacket packet) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid(session.getAuthData().xuid());
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        Component message = packet.getUnsignedContent() == null ? packet.getMessageDecorated() : packet.getUnsignedContent();
        TextDecoration decoration = (TextDecoration)session.getChatTypes().get(packet.getChatType());
        if (decoration != null) {
            TranslatableComponent.Builder withDecoration = (TranslatableComponent.Builder)Component.translatable().key(decoration.translationKey()).style(decoration.style());
            Set<TextDecoration.Parameter> parameters = decoration.parameters();
            ArrayList<Component> args = new ArrayList<Component>(3);
            if (parameters.contains((Object)TextDecoration.Parameter.TARGET)) {
                args.add(packet.getTargetName());
            }
            if (parameters.contains((Object)TextDecoration.Parameter.SENDER)) {
                args.add(packet.getName());
            }
            if (parameters.contains((Object)TextDecoration.Parameter.CONTENT)) {
                args.add(message);
            }
            withDecoration.args(args);
            textPacket.setMessage(MessageTranslator.convertMessage((Component)withDecoration.build(), session.getLocale()));
        } else {
            textPacket.setMessage(MessageTranslator.convertMessage(message, session.getLocale()));
        }
        session.sendUpstreamPacket(textPacket);
    }
}

