/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.data.game.command.CommandNode;
import com.github.steveice10.mc.protocol.data.game.command.CommandParser;
import com.github.steveice10.mc.protocol.data.game.command.properties.ResourceProperties;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.AttributeType;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundCommandsPacket;
import com.nukkitx.protocol.bedrock.data.command.CommandData;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.command.CommandParamData;
import com.nukkitx.protocol.bedrock.packet.AvailableCommandsPacket;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.CommandManager;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.relocate.kyori.adventure.text.format.NamedTextColor;

@Translator(packet=ClientboundCommandsPacket.class)
public class JavaCommandsTranslator
extends PacketTranslator<ClientboundCommandsPacket> {
    private static final String[] ALL_EFFECT_IDENTIFIERS = EntityUtils.getAllEffectIdentifiers();
    private static final String[] ATTRIBUTES = AttributeType.Builtin.BUILTIN.keySet().toArray(new String[0]);
    private static final String[] ENUM_BOOLEAN = new String[]{"true", "false"};
    private static final String[] VALID_COLORS;
    private static final String[] VALID_SCOREBOARD_SLOTS;
    private static final Hash.Strategy<BedrockCommandInfo> PARAM_STRATEGY;

    @Override
    public void translate(GeyserSession session, ClientboundCommandsPacket packet) {
        if (!session.getGeyser().getConfig().isCommandSuggestions()) {
            session.getGeyser().getLogger().debug("Not sending translated command suggestions as they are disabled.");
            AvailableCommandsPacket emptyPacket = new AvailableCommandsPacket();
            session.sendUpstreamPacket(emptyPacket);
            return;
        }
        CommandManager manager = session.getGeyser().getCommandManager();
        CommandNode[] nodes = packet.getNodes();
        ArrayList<CommandData> commandData = new ArrayList<CommandData>();
        IntOpenHashSet commandNodes = new IntOpenHashSet();
        HashSet<String> knownAliases = new HashSet<String>();
        Object2ObjectOpenCustomHashMap commands = new Object2ObjectOpenCustomHashMap(PARAM_STRATEGY);
        Int2ObjectOpenHashMap commandArgs = new Int2ObjectOpenHashMap();
        CommandNode rootNode = nodes[packet.getFirstNodeIndex()];
        for (int nodeIndex : rootNode.getChildIndices()) {
            CommandNode node = nodes[nodeIndex];
            if (!commandNodes.add(nodeIndex) || !knownAliases.add(node.getName().toLowerCase(Locale.ROOT))) continue;
            if (node.getChildIndices().length >= 1) {
                for (int childIndex : node.getChildIndices()) {
                    ((List)commandArgs.computeIfAbsent(nodeIndex, ArrayList::new)).add(nodes[childIndex]);
                }
            }
            CommandParamData[][] params = JavaCommandsTranslator.getParams(session, nodes[nodeIndex], nodes);
            commands.computeIfAbsent(new BedrockCommandInfo(manager.getDescription(node.getName().toLowerCase(Locale.ROOT)), params), index -> new HashSet()).add(node.getName().toLowerCase());
        }
        List<CommandData.Flag> flags = Collections.emptyList();
        for (Map.Entry entry : commands.entrySet()) {
            String commandName = (String)((Set)entry.getValue()).iterator().next();
            CommandEnumData aliases = new CommandEnumData(commandName + "Aliases", ((Set)entry.getValue()).toArray(new String[0]), false);
            CommandData data = new CommandData(commandName, ((BedrockCommandInfo)entry.getKey()).description(), flags, 0, aliases, ((BedrockCommandInfo)entry.getKey()).paramData());
            commandData.add(data);
        }
        AvailableCommandsPacket availableCommandsPacket = new AvailableCommandsPacket();
        availableCommandsPacket.getCommands().addAll(commandData);
        session.getGeyser().getLogger().debug("Sending command packet of " + commandData.size() + " commands");
        session.sendUpstreamPacket(availableCommandsPacket);
    }

    private static CommandParamData[][] getParams(GeyserSession session, CommandNode commandNode, CommandNode[] allNodes) {
        if (commandNode.getRedirectIndex() != -1) {
            GeyserImpl.getInstance().getLogger().debug("Redirecting command " + commandNode.getName() + " to " + allNodes[commandNode.getRedirectIndex()].getName());
            commandNode = allNodes[commandNode.getRedirectIndex()];
        }
        if (commandNode.getChildIndices().length >= 1) {
            ParamInfo rootParam = new ParamInfo(commandNode, null);
            rootParam.buildChildren(session, allNodes);
            List<CommandParamData[]> treeData = rootParam.getTree();
            return (CommandParamData[][])treeData.toArray((T[])new CommandParamData[0][]);
        }
        return new CommandParamData[0][0];
    }

    private static Object mapCommandType(GeyserSession session, CommandNode node) {
        CommandParser parser = node.getParser();
        if (parser == null) {
            return CommandParam.STRING;
        }
        return switch (parser) {
            case CommandParser.FLOAT, CommandParser.ROTATION, CommandParser.DOUBLE -> CommandParam.FLOAT;
            case CommandParser.INTEGER, CommandParser.LONG -> CommandParam.INT;
            case CommandParser.ENTITY, CommandParser.GAME_PROFILE -> CommandParam.TARGET;
            case CommandParser.BLOCK_POS -> CommandParam.BLOCK_POSITION;
            case CommandParser.COLUMN_POS, CommandParser.VEC3 -> CommandParam.POSITION;
            case CommandParser.MESSAGE -> CommandParam.MESSAGE;
            case CommandParser.NBT_COMPOUND_TAG, CommandParser.NBT_TAG, CommandParser.NBT_PATH -> CommandParam.JSON;
            case CommandParser.RESOURCE_LOCATION, CommandParser.FUNCTION -> CommandParam.FILE_PATH;
            case CommandParser.BOOL -> ENUM_BOOLEAN;
            case CommandParser.OPERATION -> CommandParam.OPERATOR;
            case CommandParser.BLOCK_STATE -> ((Map)BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.get()).keySet().toArray(new String[0]);
            case CommandParser.ITEM_STACK -> session.getItemMappings().getItemNames();
            case CommandParser.ITEM_ENCHANTMENT -> Enchantment.JavaEnchantment.ALL_JAVA_IDENTIFIERS;
            case CommandParser.ENTITY_SUMMON -> ((Map)Registries.JAVA_ENTITY_IDENTIFIERS.get()).keySet().toArray(new String[0]);
            case CommandParser.COLOR -> VALID_COLORS;
            case CommandParser.SCOREBOARD_SLOT -> VALID_SCOREBOARD_SLOTS;
            case CommandParser.MOB_EFFECT -> ALL_EFFECT_IDENTIFIERS;
            case CommandParser.RESOURCE, CommandParser.RESOURCE_OR_TAG -> {
                String resource = ((ResourceProperties)node.getProperties()).getRegistryKey();
                if (resource.equals("minecraft:attribute")) {
                    yield ATTRIBUTES;
                }
                yield CommandParam.STRING;
            }
            default -> CommandParam.STRING;
        };
    }

    static {
        PARAM_STRATEGY = new Hash.Strategy<BedrockCommandInfo>(){

            public int hashCode(BedrockCommandInfo o) {
                int paramHash = Arrays.deepHashCode((Object[])o.paramData());
                return 31 * paramHash + o.description().hashCode();
            }

            public boolean equals(BedrockCommandInfo a, BedrockCommandInfo b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                if (!a.description().equals(b.description())) {
                    return false;
                }
                if (a.paramData().length != b.paramData().length) {
                    return false;
                }
                for (int i = 0; i < a.paramData().length; ++i) {
                    CommandParamData[] b1;
                    CommandParamData[] a1 = a.paramData()[i];
                    if (a1.length != (b1 = b.paramData()[i]).length) {
                        return false;
                    }
                    for (int j = 0; j < a1.length; ++j) {
                        if (a1[j].equals(b1[j])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        ArrayList<String> validColors = new ArrayList<String>(NamedTextColor.NAMES.keys());
        validColors.add("reset");
        VALID_COLORS = validColors.toArray(new String[0]);
        ArrayList<String> teamOptions = new ArrayList<String>(Arrays.asList("list", "sidebar", "belowName"));
        for (String color : NamedTextColor.NAMES.keys()) {
            teamOptions.add("sidebar.team." + color);
        }
        VALID_SCOREBOARD_SLOTS = teamOptions.toArray(new String[0]);
    }

    private record BedrockCommandInfo(String description, CommandParamData[][] paramData) {
    }

    private static class ParamInfo {
        private final CommandNode paramNode;
        private final CommandParamData paramData;
        private final List<ParamInfo> children;

        public ParamInfo(CommandNode paramNode, CommandParamData paramData) {
            this.paramNode = paramNode;
            this.paramData = paramData;
            this.children = new ArrayList<ParamInfo>();
        }

        public void buildChildren(GeyserSession session, CommandNode[] allNodes) {
            for (int paramID : this.paramNode.getChildIndices()) {
                CommandNode paramNode = allNodes[paramID];
                if (paramNode == this.paramNode) continue;
                if (paramNode.getParser() == null) {
                    boolean foundCompatible = false;
                    for (int i = 0; i < this.children.size(); ++i) {
                        ParamInfo enumParamInfo = this.children.get(i);
                        if (!this.isCompatible(allNodes, enumParamInfo.getParamNode(), paramNode)) continue;
                        foundCompatible = true;
                        String[] enumOptions = Arrays.copyOf(enumParamInfo.getParamData().getEnumData().getValues(), enumParamInfo.getParamData().getEnumData().getValues().length + 1);
                        enumOptions[enumOptions.length - 1] = paramNode.getName();
                        CommandEnumData enumData = new CommandEnumData(enumParamInfo.getParamData().getEnumData().getName(), enumOptions, false);
                        this.children.set(i, new ParamInfo(enumParamInfo.getParamNode(), new CommandParamData(enumParamInfo.getParamData().getName(), this.paramNode.isExecutable(), enumData, null, null, Collections.emptyList())));
                        break;
                    }
                    if (foundCompatible) continue;
                    CommandEnumData enumData = new CommandEnumData(paramNode.getName(), new String[]{paramNode.getName()}, false);
                    this.children.add(new ParamInfo(paramNode, new CommandParamData(paramNode.getName(), this.paramNode.isExecutable(), enumData, null, null, Collections.emptyList())));
                    continue;
                }
                Object mappedType = JavaCommandsTranslator.mapCommandType(session, paramNode);
                CommandEnumData enumData = null;
                CommandParam type = null;
                boolean optional = this.paramNode.isExecutable();
                if (mappedType instanceof String[]) {
                    enumData = new CommandEnumData(paramNode.getParser().name().toLowerCase(Locale.ROOT), (String[])mappedType, false);
                } else {
                    type = (CommandParam)mappedType;
                    if (optional && type == CommandParam.MESSAGE && (this.paramData.getType() == CommandParam.STRING || this.paramData.getType() == CommandParam.TARGET)) {
                        optional = false;
                    }
                }
                this.children.add(new ParamInfo(paramNode, new CommandParamData(paramNode.getName(), optional, enumData, type, null, Collections.emptyList())));
            }
            Object object = this.children.iterator();
            while (object.hasNext()) {
                ParamInfo child = (ParamInfo)object.next();
                child.buildChildren(session, allNodes);
            }
        }

        private boolean isCompatible(CommandNode[] allNodes, CommandNode a, CommandNode b) {
            if (a == b) {
                return true;
            }
            if (a.getParser() != b.getParser()) {
                return false;
            }
            if (a.getChildIndices().length != b.getChildIndices().length) {
                return false;
            }
            for (int i = 0; i < a.getChildIndices().length; ++i) {
                boolean hasSimilarity = false;
                CommandNode a1 = allNodes[a.getChildIndices()[i]];
                for (int j = 0; j < b.getChildIndices().length; ++j) {
                    if (!this.isCompatible(allNodes, a1, allNodes[b.getChildIndices()[j]])) continue;
                    hasSimilarity = true;
                    break;
                }
                if (hasSimilarity) continue;
                return false;
            }
            return true;
        }

        public List<CommandParamData[]> getTree() {
            ArrayList<CommandParamData[]> treeParamData = new ArrayList<CommandParamData[]>();
            for (ParamInfo child : this.children) {
                List<CommandParamData[]> childTree = child.getTree();
                for (CommandParamData[] subChild : childTree) {
                    CommandParamData[] tmpTree = new CommandParamData[subChild.length + 1];
                    tmpTree[0] = child.getParamData();
                    System.arraycopy(subChild, 0, tmpTree, 1, subChild.length);
                    treeParamData.add(tmpTree);
                }
                if (childTree.size() != 0) continue;
                treeParamData.add(new CommandParamData[]{child.getParamData()});
            }
            return treeParamData;
        }

        public CommandNode getParamNode() {
            return this.paramNode;
        }

        public CommandParamData getParamData() {
            return this.paramData;
        }

        public List<ParamInfo> getChildren() {
            return this.children;
        }

        public String toString() {
            return "JavaCommandsTranslator.ParamInfo(paramNode=" + this.getParamNode() + ", paramData=" + this.getParamData() + ", children=" + this.getChildren() + ")";
        }
    }
}

