/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.InteractAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerState;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.packet.ContainerOpenPacket;
import com.nukkitx.protocol.bedrock.packet.InteractPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=InteractPacket.class)
public class BedrockInteractTranslator
extends PacketTranslator<InteractPacket> {
    @Override
    public void translate(GeyserSession session, InteractPacket packet) {
        Entity entity = packet.getRuntimeEntityId() == session.getPlayerEntity().getGeyserId() ? session.getPlayerEntity() : session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
        if (entity == null) {
            return;
        }
        switch (packet.getAction()) {
            case INTERACT: {
                if (session.getPlayerInventory().getItemInHand().getJavaId() == session.getItemMappings().getStoredItems().shield().getJavaId()) break;
                ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamPacket(interactPacket);
                break;
            }
            case DAMAGE: {
                ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(entity.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamPacket(attackPacket);
                break;
            }
            case LEAVE_VEHICLE: {
                ServerboundPlayerCommandPacket sneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SNEAKING);
                session.sendDownstreamPacket(sneakPacket);
                break;
            }
            case MOUSEOVER: {
                if (packet.getRuntimeEntityId() != 0L) {
                    Entity interactEntity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
                    session.setMouseoverEntity(interactEntity);
                    if (interactEntity == null) {
                        return;
                    }
                    interactEntity.updateInteractiveTag();
                    break;
                }
                if (session.getMouseoverEntity() == null) break;
                session.setMouseoverEntity(null);
                session.getPlayerEntity().getDirtyMetadata().put(EntityData.INTERACTIVE_TAG, "");
                session.getPlayerEntity().updateBedrockMetadata();
                break;
            }
            case OPEN_INVENTORY: {
                if (session.getOpenInventory() != null) break;
                Entity ridingEntity = session.getPlayerEntity().getVehicle();
                if (ridingEntity instanceof AbstractHorseEntity || ridingEntity != null && ridingEntity.getDefinition().entityType() == EntityType.CHEST_BOAT) {
                    ServerboundPlayerCommandPacket openVehicleWindowPacket = new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.OPEN_VEHICLE_INVENTORY);
                    session.sendDownstreamPacket(openVehicleWindowPacket);
                    break;
                }
                session.setOpenInventory(session.getPlayerInventory());
                ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
                containerOpenPacket.setId((byte)0);
                containerOpenPacket.setType(ContainerType.INVENTORY);
                containerOpenPacket.setUniqueEntityId(-1L);
                containerOpenPacket.setBlockPosition(entity.getPosition().toInt());
                session.sendUpstreamPacket(containerOpenPacket);
            }
        }
    }
}

