/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundSelectTradePacket;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=EntityEventPacket.class)
public class BedrockEntityEventTranslator
extends PacketTranslator<EntityEventPacket> {
    @Override
    public void translate(GeyserSession session, EntityEventPacket packet) {
        switch (packet.getType()) {
            case EATING_ITEM: {
                session.sendUpstreamPacket(packet);
                return;
            }
            case COMPLETE_TRADE: {
                ServerboundSelectTradePacket selectTradePacket = new ServerboundSelectTradePacket(packet.getData());
                session.sendDownstreamPacket(selectTradePacket);
                session.scheduleInEventLoop(() -> {
                    Inventory openInventory = session.getOpenInventory();
                    Inventory merchantInventory$temp = openInventory;
                    if (merchantInventory$temp instanceof MerchantContainer) {
                        MerchantContainer merchantInventory = (MerchantContainer)merchantInventory$temp;
                        merchantInventory.onTradeSelected(session, packet.getData());
                    }
                }, 100L, TimeUnit.MILLISECONDS);
                return;
            }
        }
        session.getGeyser().getLogger().debug("Did not translate incoming EntityEventPacket: " + packet.toString());
    }
}

