/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundEditBookPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.protocol.bedrock.packet.BookEditPacket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=BookEditPacket.class)
public class BedrockBookEditTranslator
extends PacketTranslator<BookEditPacket> {
    private static final int MAXIMUM_PAGE_LENGTH = 32768;
    private static final int MAXIMUM_TITLE_LENGTH = 512;

    @Override
    public void translate(GeyserSession session, BookEditPacket packet) {
        if (packet.getText() != null && !packet.getText().isEmpty() && packet.getText().getBytes(StandardCharsets.UTF_8).length > 32768) {
            session.getGeyser().getLogger().warning("Page length greater than server allowed!");
            return;
        }
        GeyserItemStack itemStack = session.getPlayerInventory().getItemInHand();
        if (itemStack != null) {
            String title;
            StringTag currentPage;
            CompoundTag tag = itemStack.getNbt() != null ? itemStack.getNbt() : new CompoundTag("");
            ItemStack bookItem = new ItemStack(itemStack.getJavaId(), itemStack.getAmount(), tag);
            LinkedList<Tag> pages = tag.contains("pages") ? new LinkedList<Tag>((Collection<Tag>)((ListTag)tag.get("pages")).getValue()) : new LinkedList();
            int page = packet.getPageNumber();
            switch (packet.getAction()) {
                case ADD_PAGE: {
                    for (int i = pages.size(); i < page; ++i) {
                        pages.add(i, new StringTag("", ""));
                    }
                    pages.add(page, new StringTag("", packet.getText()));
                    break;
                }
                case REPLACE_PAGE: {
                    if (page < pages.size()) {
                        pages.set(page, new StringTag("", packet.getText()));
                        break;
                    }
                    for (int i = pages.size(); i < page; ++i) {
                        pages.add(i, new StringTag("", ""));
                    }
                    pages.add(page, new StringTag("", packet.getText()));
                    break;
                }
                case DELETE_PAGE: {
                    if (page >= pages.size()) break;
                    pages.remove(page);
                    break;
                }
                case SWAP_PAGES: {
                    int page2 = packet.getSecondaryPageNumber();
                    if (page >= pages.size() || page2 >= pages.size()) break;
                    Collections.swap(pages, page, page2);
                    break;
                }
                case SIGN_BOOK: {
                    tag.put(new StringTag("author", packet.getAuthor()));
                    tag.put(new StringTag("title", packet.getTitle()));
                    break;
                }
                default: {
                    return;
                }
            }
            while (pages.size() > 0 && ((currentPage = (StringTag)pages.get(pages.size() - 1)).getValue() == null || currentPage.getValue().isEmpty())) {
                pages.remove(pages.size() - 1);
            }
            tag.put(new ListTag("pages", pages));
            session.getPlayerInventory().setItem(36 + session.getPlayerInventory().getHeldItemSlot(), GeyserItemStack.from(bookItem), session);
            session.getInventoryTranslator().updateInventory(session, session.getPlayerInventory());
            ArrayList<String> networkPages = new ArrayList<String>();
            for (Tag pageTag : pages) {
                networkPages.add(((StringTag)pageTag).getValue());
            }
            if (packet.getAction() == BookEditPacket.Action.SIGN_BOOK) {
                if (packet.getTitle().getBytes(StandardCharsets.UTF_8).length > 512) {
                    session.getGeyser().getLogger().warning("Book title larger than server allows!");
                    return;
                }
                title = packet.getTitle();
            } else {
                title = null;
            }
            session.getBookEditCache().setPacket(new ServerboundEditBookPacket(session.getPlayerInventory().getHeldItemSlot(), networkPages, title));
            if (packet.getAction() == BookEditPacket.Action.SIGN_BOOK) {
                session.getBookEditCache().checkForSend();
            }
        }
    }
}

