/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundSetJigsawBlockPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundSignUpdatePacket;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.SignUtils;

@Translator(packet=BlockEntityDataPacket.class)
public class BedrockBlockEntityDataTranslator
extends PacketTranslator<BlockEntityDataPacket> {
    @Override
    public void translate(GeyserSession session, BlockEntityDataPacket packet) {
        NbtMap tag = packet.getData();
        String id = tag.getString("id");
        if (id.equals("Sign")) {
            String text = tag.getString("Text");
            StringBuilder newMessage = new StringBuilder();
            String[] lines = new String[]{"", "", "", ""};
            int iterator = 0;
            int widthCount = 0;
            for (char character : text.toCharArray()) {
                if (character == '\n' || (widthCount += SignUtils.getCharacterWidth(character)) > 90) {
                    int index;
                    boolean wentOverMax = widthCount > 90 && character != '\n';
                    widthCount = 0;
                    String word = null;
                    if (wentOverMax && iterator < lines.length - 1 && (index = newMessage.lastIndexOf(" ")) != -1) {
                        word = newMessage.substring(index + 1);
                        newMessage.delete(index, newMessage.length());
                    }
                    lines[iterator] = newMessage.toString();
                    if (++iterator > lines.length - 1) break;
                    newMessage = new StringBuilder();
                    if (!wentOverMax) continue;
                    if (word != null) {
                        newMessage.append(word);
                        for (char wordCharacter : word.toCharArray()) {
                            widthCount += SignUtils.getCharacterWidth(wordCharacter);
                        }
                    }
                    newMessage.append(character);
                    widthCount += SignUtils.getCharacterWidth(character);
                    continue;
                }
                newMessage.append(character);
            }
            if (iterator < lines.length) {
                lines[iterator] = newMessage.toString();
            }
            Vector3i pos = Vector3i.from(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            ServerboundSignUpdatePacket signUpdatePacket = new ServerboundSignUpdatePacket(pos, lines);
            session.sendDownstreamPacket(signUpdatePacket);
        } else if (id.equals("JigsawBlock")) {
            Vector3i pos = Vector3i.from(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            String name = tag.getString("name");
            String target = tag.getString("target");
            String pool = tag.getString("target_pool");
            String finalState = tag.getString("final_state");
            String joint = tag.getString("joint");
            ServerboundSetJigsawBlockPacket jigsawPacket = new ServerboundSetJigsawBlockPacket(pos, name, target, pool, finalState, joint);
            session.sendDownstreamPacket(jigsawPacket);
        }
    }
}

