/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundPaddleBoatPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;
import com.nukkitx.protocol.bedrock.packet.AnimatePacket;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=AnimatePacket.class)
public class BedrockAnimateTranslator
extends PacketTranslator<AnimatePacket> {
    @Override
    public void translate(GeyserSession session, AnimatePacket packet) {
        if (!session.isSpawned()) {
            return;
        }
        switch (packet.getAction()) {
            case SWING_ARM: {
                session.scheduleInEventLoop(() -> {
                    session.sendDownstreamPacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                    session.activateArmAnimationTicking();
                }, 25L, TimeUnit.MILLISECONDS);
                break;
            }
            case ROW_LEFT: {
                session.setSteeringLeft((double)packet.getRowingTime() > 0.0);
                ServerboundPaddleBoatPacket steerLeftPacket = new ServerboundPaddleBoatPacket(session.isSteeringLeft(), session.isSteeringRight());
                session.sendDownstreamPacket(steerLeftPacket);
                break;
            }
            case ROW_RIGHT: {
                session.setSteeringRight((double)packet.getRowingTime() > 0.0);
                ServerboundPaddleBoatPacket steerRightPacket = new ServerboundPaddleBoatPacket(session.isSteeringLeft(), session.isSteeringRight());
                session.sendDownstreamPacket(steerRightPacket);
            }
        }
    }
}

