/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import com.nukkitx.protocol.bedrock.data.AdventureSetting;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.AdventureSettingsPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=AdventureSettingsPacket.class)
public class BedrockAdventureSettingsTranslator
extends PacketTranslator<AdventureSettingsPacket> {
    @Override
    public void translate(GeyserSession session, AdventureSettingsPacket packet) {
        boolean isFlying = packet.getSettings().contains((Object)AdventureSetting.FLYING);
        if (!isFlying && session.getGameMode() == GameMode.SPECTATOR) {
            session.sendAdventureSettings();
            return;
        }
        if (isFlying && session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
            session.sendAdventureSettings();
            return;
        }
        session.setFlying(isFlying);
        ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(isFlying);
        session.sendDownstreamPacket(abilitiesPacket);
    }
}

