/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.nbt.NbtMapBuilder;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;

@BlockEntity(type={BlockEntityType.MOB_SPAWNER})
public class SpawnerBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        CompoundTag spawnData;
        Object current = tag.get("MaxNearbyEntities");
        if (current != null) {
            builder.put("MaxNearbyEntities", ((Tag)current).getValue());
        }
        if ((current = tag.get("RequiredPlayerRange")) != null) {
            builder.put("RequiredPlayerRange", ((Tag)current).getValue());
        }
        if ((current = tag.get("SpawnCount")) != null) {
            builder.put("SpawnCount", ((Tag)current).getValue());
        }
        if ((current = tag.get("MaxSpawnDelay")) != null) {
            builder.put("MaxSpawnDelay", ((Tag)current).getValue());
        }
        if ((current = tag.get("Delay")) != null) {
            builder.put("Delay", ((Tag)current).getValue());
        }
        if ((current = tag.get("SpawnRange")) != null) {
            builder.put("SpawnRange", ((Tag)current).getValue());
        }
        if ((current = tag.get("MinSpawnDelay")) != null) {
            builder.put("MinSpawnDelay", ((Tag)current).getValue());
        }
        if ((spawnData = (CompoundTag)tag.get("SpawnData")) != null) {
            String entityID = (String)((Tag)((CompoundTag)spawnData.get("entity")).get("id")).getValue();
            builder.put("EntityIdentifier", (Object)entityID);
            EntityDefinition definition = (EntityDefinition)Registries.JAVA_ENTITY_IDENTIFIERS.get(entityID);
            if (definition != null) {
                builder.put("DisplayEntityWidth", (Object)Float.valueOf(definition.width()));
                builder.put("DisplayEntityHeight", (Object)Float.valueOf(definition.height()));
                builder.put("DisplayEntityScale", (Object)Float.valueOf(1.0f));
            }
        }
        builder.put("id", (Object)"MobSpawner");
        builder.put("isMovable", (Object)1);
    }
}

