/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMapBuilder;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;

@BlockEntity(type={BlockEntityType.SKULL})
public class SkullBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        byte skullVariant = BlockStateValues.getSkullVariant(blockState);
        float rotation = (float)BlockStateValues.getSkullRotation(blockState) * 22.5f;
        if (skullVariant == -1) {
            skullVariant = 0;
        }
        builder.put("Rotation", (Object)Float.valueOf(rotation));
        builder.put("SkullType", (Object)skullVariant);
    }

    private static CompletableFuture<String> getTextures(CompoundTag tag) {
        CompoundTag owner = (CompoundTag)tag.get("SkullOwner");
        if (owner != null) {
            CompoundTag properties = (CompoundTag)owner.get("Properties");
            if (properties == null) {
                return SkinProvider.requestTexturesFromUsername(owner);
            }
            ListTag textures = (ListTag)properties.get("textures");
            LinkedHashMap tag1 = (LinkedHashMap)((Tag)textures.get(0)).getValue();
            StringTag texture = (StringTag)tag1.get("Value");
            return CompletableFuture.completedFuture(texture.getValue());
        }
        return CompletableFuture.completedFuture(null);
    }

    public static void translateSkull(GeyserSession session, CompoundTag tag, int posX, int posY, int posZ, int blockState) {
        Vector3i blockPosition = Vector3i.from(posX, posY, posZ);
        SkullBlockEntityTranslator.getTextures(tag).whenComplete((texturesProperty, throwable) -> {
            if (texturesProperty == null) {
                session.getGeyser().getLogger().debug("Custom skull with invalid SkullOwner tag: " + blockPosition + " " + tag);
                return;
            }
            if (session.getEventLoop().inEventLoop()) {
                session.getSkullCache().putSkull(blockPosition, (String)texturesProperty, blockState);
            } else {
                session.executeInEventLoop(() -> session.getSkullCache().putSkull(blockPosition, (String)texturesProperty, blockState));
            }
        });
    }
}

