/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.nbt.NbtMapBuilder;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.SignUtils;

@BlockEntity(type={BlockEntityType.SIGN})
public class SignBlockEntityTranslator
extends BlockEntityTranslator {
    private int getBedrockSignColor(String javaColor) {
        int dyeColor = switch (javaColor) {
            case "white" -> 0xF9FFFE;
            case "orange" -> 16351261;
            case "magenta" -> 13061821;
            case "light_blue" -> 3847130;
            case "yellow" -> 16701501;
            case "lime" -> 8439583;
            case "pink" -> 15961002;
            case "gray" -> 4673362;
            case "light_gray" -> 0x9D9D97;
            case "cyan" -> 1481884;
            case "purple" -> 8991416;
            case "blue" -> 3949738;
            case "brown" -> 8606770;
            case "green" -> 6192150;
            case "red" -> 11546150;
            default -> 0;
        };
        return dyeColor | 0xFF000000;
    }

    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        StringBuilder signText = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int currentLine = i + 1;
            String signLine = this.getOrDefault((Tag)tag.getValue().get("Text" + currentLine), "");
            signLine = MessageTranslator.convertMessageLenient(signLine);
            int signWidth = 0;
            StringBuilder finalSignLine = new StringBuilder();
            boolean previousCharacterWasFormatting = false;
            for (char c : signLine.toCharArray()) {
                if (c == '\u00a7') {
                    previousCharacterWasFormatting = true;
                } else if (previousCharacterWasFormatting) {
                    previousCharacterWasFormatting = false;
                } else {
                    signWidth += SignUtils.getCharacterWidth(c);
                }
                if (signWidth > 88) break;
                finalSignLine.append(c);
            }
            signText.append((CharSequence)finalSignLine);
            signText.append("\n");
        }
        builder.putString("Text", signText.toString());
        Object color = tag.get("Color");
        if (color != null) {
            builder.putInt("SignTextColor", this.getBedrockSignColor(((Tag)color).getValue().toString()));
        }
        boolean isGlowing = this.getOrDefault((Tag)tag.getValue().get("GlowingText"), (byte)0) != 0;
        builder.putBoolean("IgnoreLighting", isGlowing);
        builder.putBoolean("TextIgnoreLegacyBugResolved", isGlowing);
    }
}

