/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.util.MathUtils;

@ItemRemapper
public class ShulkerBoxItemTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        if (!itemTag.contains("BlockEntityTag")) {
            return;
        }
        CompoundTag blockEntityTag = (CompoundTag)itemTag.get("BlockEntityTag");
        if (blockEntityTag.get("Items") == null) {
            return;
        }
        ListTag itemsList = new ListTag("Items");
        for (Tag item : (ListTag)blockEntityTag.get("Items")) {
            CompoundTag itemData = (CompoundTag)item;
            CompoundTag boxItemTag = new CompoundTag("");
            boxItemTag.put(new ByteTag("Slot", (byte)(MathUtils.getNbtByte(((Tag)itemData.get("Slot")).getValue()) & 0xFF)));
            boxItemTag.put(new ByteTag("WasPickedUp", 0));
            ItemMapping boxMapping = session.getItemMappings().getMapping(Identifier.formalize(((StringTag)itemData.get("id")).getValue()));
            boxItemTag.put(new StringTag("Name", boxMapping.getBedrockIdentifier()));
            boxItemTag.put(new ShortTag("Damage", (short)boxMapping.getBedrockData()));
            boxItemTag.put(new ByteTag("Count", MathUtils.getNbtByte(((Tag)itemData.get("Count")).getValue())));
            CompoundTag displayTag = (CompoundTag)itemData.get("tag");
            if (displayTag == null && boxMapping.hasTranslation()) {
                displayTag = new CompoundTag("tag");
            }
            if (displayTag != null) {
                boxItemTag.put(ItemTranslator.translateDisplayProperties(session, displayTag, boxMapping, '7'));
            }
            itemsList.add(boxItemTag);
        }
        itemTag.put(itemsList);
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        if (itemTag.contains("Items")) {
            itemTag.remove("Items");
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return mapping.getJavaIdentifier().contains("shulker_box");
    }
}

