/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class MapItemTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        Object mapId = itemTag.get("map");
        if (mapId == null) {
            return;
        }
        int mapValue = ((Tag)mapId).getValue() instanceof Short ? ((Short)((Tag)mapId).getValue()).shortValue() : ((Integer)((Tag)mapId).getValue()).intValue();
        itemTag.put(new LongTag("map_uuid", mapValue));
        itemTag.put(new IntTag("map_name_index", mapValue));
        itemTag.put(new ByteTag("map_display_players", 1));
        itemTag.remove("map");
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        IntTag tag = (IntTag)itemTag.get("map_name_index");
        if (tag != null) {
            itemTag.put(new IntTag("map", tag.getValue()));
            itemTag.remove("map_name_index");
            itemTag.remove("map_uuid");
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return mapping.getJavaIdentifier().equals("minecraft:filled_map");
    }
}

