/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import java.util.Arrays;
import java.util.List;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class LeatherArmorTranslator
extends NbtItemStackTranslator {
    private static final List<String> ITEMS = Arrays.asList("minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots", "minecraft:leather_horse_armor");

    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        CompoundTag displayTag = (CompoundTag)itemTag.get("display");
        if (displayTag == null) {
            return;
        }
        IntTag color = (IntTag)displayTag.get("color");
        if (color != null) {
            itemTag.put(new IntTag("customColor", color.getValue()));
            displayTag.remove("color");
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        IntTag color = (IntTag)itemTag.get("customColor");
        if (color == null) {
            return;
        }
        CompoundTag displayTag = (CompoundTag)itemTag.get("display");
        if (displayTag == null) {
            displayTag = new CompoundTag("display");
        }
        displayTag.put(color);
        itemTag.remove("customColor");
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return ITEMS.contains(mapping.getJavaIdentifier());
    }
}

