/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.nbt.FireworkBaseTranslator;

@ItemRemapper
public class FireworkStarTranslator
extends FireworkBaseTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        Object explosion = itemTag.get("Explosion");
        if (explosion instanceof CompoundTag) {
            CompoundTag newExplosion = this.translateExplosionToBedrock((CompoundTag)explosion, "FireworksItem");
            itemTag.remove("Explosion");
            itemTag.put(newExplosion);
            Object color = ((CompoundTag)explosion).get("Colors");
            if (color instanceof IntArrayTag) {
                int finalColor;
                int[] colors = ((IntArrayTag)color).getValue();
                if (colors.length == 0) {
                    return;
                }
                if (colors.length == 1) {
                    finalColor = colors[0];
                } else {
                    int r = 0;
                    int g2 = 0;
                    int b = 0;
                    for (int fireworkColor : colors) {
                        r += (fireworkColor & 0xFF0000) >> 16;
                        g2 += (fireworkColor & 0xFF00) >> 8;
                        b += fireworkColor & 0xFF;
                    }
                    finalColor = (r /= colors.length) << 16 | (g2 /= colors.length) << 8 | (b /= colors.length);
                }
                itemTag.put(new IntTag("customColor", finalColor));
            }
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        Object explosion = itemTag.get("FireworksItem");
        if (explosion instanceof CompoundTag) {
            CompoundTag newExplosion = this.translateExplosionToJava((CompoundTag)explosion, "Explosion");
            itemTag.remove("FireworksItem");
            itemTag.put(newExplosion);
        }
        itemTag.remove("customColor");
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return "minecraft:firework_star".equals(mapping.getJavaIdentifier());
    }
}

