/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.geysermc.geyser.level.FireworkColor;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.util.MathUtils;

public abstract class FireworkBaseTranslator
extends NbtItemStackTranslator {
    protected CompoundTag translateExplosionToBedrock(CompoundTag explosion, String newName) {
        int i;
        byte[] colors;
        int[] oldColors;
        CompoundTag newExplosionData = new CompoundTag(newName);
        if (explosion.get("Type") != null) {
            newExplosionData.put(new ByteTag("FireworkType", MathUtils.getNbtByte(((Tag)explosion.get("Type")).getValue())));
        }
        if (explosion.get("Colors") != null) {
            oldColors = (int[])((Tag)explosion.get("Colors")).getValue();
            colors = new byte[oldColors.length];
            i = 0;
            for (int color : oldColors) {
                colors[i++] = FireworkColor.fromJavaRGB(color);
            }
            newExplosionData.put(new ByteArrayTag("FireworkColor", colors));
        }
        if (explosion.get("FadeColors") != null) {
            oldColors = (int[])((Tag)explosion.get("FadeColors")).getValue();
            colors = new byte[oldColors.length];
            i = 0;
            for (int color : oldColors) {
                colors[i++] = FireworkColor.fromJavaRGB(color);
            }
            newExplosionData.put(new ByteArrayTag("FireworkFade", colors));
        }
        if (explosion.get("Trail") != null) {
            newExplosionData.put(new ByteTag("FireworkTrail", MathUtils.getNbtByte(((Tag)explosion.get("Trail")).getValue())));
        }
        if (explosion.get("Flicker") != null) {
            newExplosionData.put(new ByteTag("FireworkFlicker", MathUtils.getNbtByte(((Tag)explosion.get("Flicker")).getValue())));
        }
        return newExplosionData;
    }

    protected CompoundTag translateExplosionToJava(CompoundTag explosion, String newName) {
        int i;
        int[] colors;
        byte[] oldColors;
        CompoundTag newExplosionData = new CompoundTag(newName);
        if (explosion.get("FireworkType") != null) {
            newExplosionData.put(new ByteTag("Type", MathUtils.getNbtByte(((Tag)explosion.get("FireworkType")).getValue())));
        }
        if (explosion.get("FireworkColor") != null) {
            oldColors = (byte[])((Tag)explosion.get("FireworkColor")).getValue();
            colors = new int[oldColors.length];
            i = 0;
            for (byte color : oldColors) {
                colors[i++] = FireworkColor.fromBedrockId(color);
            }
            newExplosionData.put(new IntArrayTag("Colors", colors));
        }
        if (explosion.get("FireworkFade") != null) {
            oldColors = (byte[])((Tag)explosion.get("FireworkFade")).getValue();
            colors = new int[oldColors.length];
            i = 0;
            for (byte color : oldColors) {
                colors[i++] = FireworkColor.fromBedrockId(color);
            }
            newExplosionData.put(new IntArrayTag("FadeColors", colors));
        }
        if (explosion.get("FireworkTrail") != null) {
            newExplosionData.put(new ByteTag("Trail", MathUtils.getNbtByte(((Tag)explosion.get("FireworkTrail")).getValue())));
        }
        if (explosion.get("FireworkFlicker") != null) {
            newExplosionData.put(new ByteTag("Flicker", MathUtils.getNbtByte(((Tag)explosion.get("FireworkFlicker")).getValue())));
        }
        return newExplosionData;
    }
}

