/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class CrossbowTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        ListTag chargedProjectiles;
        if (itemTag.get("ChargedProjectiles") != null && !(chargedProjectiles = (ListTag)itemTag.get("ChargedProjectiles")).getValue().isEmpty()) {
            CompoundTag projectile = (CompoundTag)chargedProjectiles.getValue().get(0);
            ItemMapping projectileMapping = session.getItemMappings().getMapping((String)((Tag)projectile.get("id")).getValue());
            if (projectileMapping == null) {
                return;
            }
            CompoundTag tag = (CompoundTag)projectile.get("tag");
            ItemStack itemStack = new ItemStack(mapping.getJavaId(), ((Byte)((Tag)projectile.get("Count")).getValue()).byteValue(), tag);
            ItemData itemData = ItemTranslator.translateToBedrock(session, itemStack);
            CompoundTag newProjectile = new CompoundTag("chargedItem");
            newProjectile.put(new ByteTag("Count", (byte)itemData.getCount()));
            newProjectile.put(new StringTag("Name", projectileMapping.getBedrockIdentifier()));
            newProjectile.put(new ShortTag("Damage", (short)itemData.getDamage()));
            itemTag.put(newProjectile);
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        if (itemTag.get("chargedItem") != null) {
            CompoundTag chargedItem = (CompoundTag)itemTag.get("chargedItem");
            CompoundTag newProjectile = new CompoundTag("");
            newProjectile.put(new ByteTag("Count", (Byte)((Tag)chargedItem.get("Count")).getValue()));
            newProjectile.put(new StringTag("id", (String)((Tag)chargedItem.get("Name")).getValue()));
            ListTag chargedProjectiles = new ListTag("ChargedProjectiles");
            chargedProjectiles.add(newProjectile);
            itemTag.put(chargedProjectiles);
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return "minecraft:crossbow".equals(mapping.getJavaIdentifier());
    }
}

