/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ItemUtils;

@ItemRemapper(priority=-1)
public class BasicItemTranslator
extends NbtItemStackTranslator {
    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        Object durability2;
        Object damage = itemTag.get("Damage");
        if (damage instanceof IntTag) {
            int originalDurability = ((IntTag)damage).getValue();
            int durability2 = ItemUtils.getCorrectBedrockDurability(session, mapping.getJavaId(), originalDurability);
            if (durability2 != originalDurability) {
                itemTag.put(new IntTag("Damage", durability2));
            }
        }
        if (!((durability2 = itemTag.get("display")) instanceof CompoundTag)) {
            return;
        }
        CompoundTag displayTag = (CompoundTag)durability2;
        Object t2 = displayTag.get("Lore");
        if (t2 instanceof ListTag) {
            ListTag listTag = (ListTag)t2;
            ArrayList<Tag> lore = new ArrayList<Tag>();
            Iterator iterator = listTag.getValue().iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof StringTag)) continue;
                lore.add(new StringTag("", MessageTranslator.convertMessageLenient(((StringTag)tag).getValue(), session.getLocale())));
            }
            displayTag.put(new ListTag("Lore", lore));
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        CompoundTag displayTag = (CompoundTag)itemTag.get("display");
        if (displayTag == null) {
            return;
        }
        if (displayTag.contains("Name")) {
            StringTag nameTag = (StringTag)displayTag.get("Name");
            displayTag.put(new StringTag("Name", MessageTranslator.convertToJavaMessage(nameTag.getValue())));
        }
        if (displayTag.contains("Lore")) {
            ListTag loreTag = (ListTag)displayTag.get("Lore");
            ArrayList<Tag> lore = new ArrayList<Tag>();
            Iterator iterator = loreTag.getValue().iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof StringTag)) continue;
                lore.add(new StringTag("", MessageTranslator.convertToJavaMessage(((StringTag)tag).getValue())));
            }
            displayTag.put(new ListTag("Lore", lore));
        }
    }
}

