/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;

@ItemRemapper
public class BannerTranslator
extends NbtItemStackTranslator {
    public static final ListTag OMINOUS_BANNER_PATTERN = new ListTag("Patterns");
    private final List<ItemMapping> appliedItems = Arrays.stream(Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getItems()).filter(entry -> entry.getJavaIdentifier().endsWith("banner")).collect(Collectors.toList());

    private static CompoundTag getPatternTag(String pattern, int color) {
        StringTag patternType = new StringTag("Pattern", pattern);
        IntTag colorTag = new IntTag("Color", color);
        CompoundTag tag = new CompoundTag("");
        tag.put(patternType);
        tag.put(colorTag);
        return tag;
    }

    public static NbtList<NbtMap> convertBannerPattern(ListTag patterns) {
        ArrayList<NbtMap> tagsList = new ArrayList<NbtMap>();
        Iterator iterator = patterns.getValue().iterator();
        while (iterator.hasNext()) {
            Tag patternTag = (Tag)iterator.next();
            tagsList.add(BannerTranslator.getBedrockBannerPattern((CompoundTag)patternTag));
        }
        return new NbtList<NbtMap>(NbtType.COMPOUND, (Collection<NbtMap>)tagsList);
    }

    @Nonnull
    private static NbtMap getBedrockBannerPattern(CompoundTag pattern) {
        return NbtMap.builder().putInt("Color", 15 - (Integer)((Tag)pattern.get("Color")).getValue()).putString("Pattern", (String)((Tag)pattern.get("Pattern")).getValue()).build();
    }

    public static CompoundTag getJavaBannerPattern(NbtMap pattern) {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        tags.put("Color", new IntTag("Color", 15 - pattern.getInt("Color")));
        tags.put("Pattern", new StringTag("Pattern", pattern.getString("Pattern")));
        return new CompoundTag("", tags);
    }

    private void invertBannerColors(ListTag patterns) {
        Iterator iterator = patterns.getValue().iterator();
        while (iterator.hasNext()) {
            Tag patternTag = (Tag)iterator.next();
            IntTag color = (IntTag)((CompoundTag)patternTag).get("Color");
            color.setValue(15 - color.getValue());
        }
    }

    @Override
    public void translateToBedrock(GeyserSession session, CompoundTag itemTag, ItemMapping mapping) {
        Object t2;
        CompoundTag blockEntityTag = (CompoundTag)itemTag.get("BlockEntityTag");
        if (blockEntityTag != null && (t2 = blockEntityTag.get("Patterns")) instanceof ListTag) {
            ListTag patterns = (ListTag)t2;
            if (patterns.equals(OMINOUS_BANNER_PATTERN)) {
                itemTag.put(new IntTag("Type", 1));
            } else {
                this.invertBannerColors(patterns);
                itemTag.put(patterns);
            }
            itemTag.remove("BlockEntityTag");
        }
    }

    @Override
    public void translateToJava(CompoundTag itemTag, ItemMapping mapping) {
        IntTag type;
        Object t2 = itemTag.get("Type");
        if (t2 instanceof IntTag && (type = (IntTag)t2).getValue() == 1) {
            itemTag.remove("Type");
            blockEntityTag = new CompoundTag("BlockEntityTag");
            ((CompoundTag)blockEntityTag).put((ListTag)OMINOUS_BANNER_PATTERN);
            itemTag.put(blockEntityTag);
        } else {
            blockEntityTag = itemTag.get("Patterns");
            if (blockEntityTag instanceof ListTag) {
                ListTag patterns = (ListTag)blockEntityTag;
                blockEntityTag = new CompoundTag("BlockEntityTag");
                this.invertBannerColors(patterns);
                ((CompoundTag)blockEntityTag).put(patterns);
                itemTag.put(blockEntityTag);
                itemTag.remove("Patterns");
            }
        }
    }

    @Override
    public boolean acceptItem(ItemMapping mapping) {
        return this.appliedItems.contains(mapping);
    }

    static {
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("mr", 9));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("bs", 8));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("cs", 7));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("bo", 8));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("ms", 15));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("hh", 8));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("mc", 8));
        OMINOUS_BANNER_PATTERN.add(BannerTranslator.getPatternTag("bo", 15));
    }
}

