/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongArrayTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.NbtItemStackTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TextComponent;
import org.geysermc.relocate.kyori.adventure.text.format.NamedTextColor;

public abstract class ItemTranslator {
    private static final Int2ObjectMap<ItemTranslator> ITEM_STACK_TRANSLATORS = new Int2ObjectOpenHashMap();
    private static final List<NbtItemStackTranslator> NBT_TRANSLATORS;
    private static final ItemTranslator DEFAULT_TRANSLATOR;

    protected ItemTranslator() {
    }

    public static void init() {
    }

    public static ItemStack translateToJava(ItemData data, ItemMappings mappings) {
        if (data == null) {
            return new ItemStack(0);
        }
        ItemMapping javaItem = mappings.getMapping(data);
        ItemTranslator itemStackTranslator = (ItemTranslator)ITEM_STACK_TRANSLATORS.get(javaItem.getJavaId());
        ItemStack itemStack = itemStackTranslator != null ? itemStackTranslator.translateToJava(data, javaItem, mappings) : DEFAULT_TRANSLATOR.translateToJava(data, javaItem, mappings);
        if (itemStack != null && itemStack.getNbt() != null) {
            for (NbtItemStackTranslator translator : NBT_TRANSLATORS) {
                if (!translator.acceptItem(javaItem)) continue;
                translator.translateToJava(itemStack.getNbt(), javaItem);
            }
            if (itemStack.getNbt().isEmpty()) {
                itemStack = new ItemStack(itemStack.getId(), itemStack.getAmount(), null);
            }
        }
        return itemStack;
    }

    @Nonnull
    public static ItemData translateToBedrock(GeyserSession session, ItemStack stack) {
        CompoundTag nbt;
        if (stack == null) {
            return ItemData.AIR;
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(stack);
        if (bedrockItem == null) {
            session.getGeyser().getLogger().debug("No matching ItemMapping for " + stack);
            return ItemData.AIR;
        }
        CompoundTag compoundTag = nbt = stack.getNbt() != null ? stack.getNbt().clone() : null;
        if (nbt == null && bedrockItem.getJavaIdentifier().equals("minecraft:filled_map")) {
            nbt = new CompoundTag("");
            nbt.put(new IntTag("map", 0));
        }
        if (nbt != null) {
            for (NbtItemStackTranslator translator : NBT_TRANSLATORS) {
                if (!translator.acceptItem(bedrockItem)) continue;
                translator.translateToBedrock(session, nbt, bedrockItem);
            }
        }
        nbt = ItemTranslator.translateDisplayProperties(session, nbt, bedrockItem);
        if (session.isAdvancedTooltips()) {
            nbt = ItemTranslator.addAdvancedTooltips(nbt, bedrockItem, session.getLocale());
        }
        ItemStack itemStack = new ItemStack(stack.getId(), stack.getAmount(), nbt);
        ItemTranslator itemStackTranslator = (ItemTranslator)ITEM_STACK_TRANSLATORS.getOrDefault(bedrockItem.getJavaId(), (Object)DEFAULT_TRANSLATOR);
        ItemData.Builder builder = itemStackTranslator.translateToBedrock(itemStack, bedrockItem, session.getItemMappings());
        if (bedrockItem.isBlock()) {
            builder.blockRuntimeId(bedrockItem.getBedrockBlockId());
        }
        if (nbt != null) {
            ListTag canDestroy = (ListTag)nbt.get("CanDestroy");
            String[] canBreak = new String[]{};
            ListTag canPlaceOn = (ListTag)nbt.get("CanPlaceOn");
            String[] canPlace = new String[]{};
            canBreak = ItemTranslator.getCanModify(canDestroy, canBreak);
            canPlace = ItemTranslator.getCanModify(canPlaceOn, canPlace);
            builder.canBreak(canBreak);
            builder.canPlace(canPlace);
        }
        return builder.build();
    }

    private static CompoundTag addAdvancedTooltips(CompoundTag nbt, ItemMapping mapping, String language) {
        int durability;
        Object durabilityTag;
        int maxDurability;
        ListTag listTag;
        CompoundTag compoundTag;
        CompoundTag newNbt = nbt;
        if (newNbt == null) {
            newNbt = new CompoundTag("nbt");
            CompoundTag display = new CompoundTag("display");
            display.put(new ListTag("Lore"));
            newNbt.put(display);
        }
        if ((compoundTag = (CompoundTag)newNbt.get("display")) == null) {
            compoundTag = new CompoundTag("display");
        }
        if ((listTag = (ListTag)compoundTag.get("Lore")) == null) {
            listTag = new ListTag("Lore");
        }
        if ((maxDurability = mapping.getMaxDamage()) != 0 && (durabilityTag = newNbt.get("Damage")) instanceof IntTag && (durability = maxDurability - ((IntTag)durabilityTag).getValue()) != maxDurability) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.WHITE)).append((Component)Component.translatable("item.durability", Component.text(durability), Component.text(maxDurability)))).build();
            listTag.add(new StringTag("", MessageTranslator.convertMessage((Component)component, language)));
        }
        listTag.add(new StringTag("", "\u00a7r\u00a78" + mapping.getJavaIdentifier()));
        if (nbt != null) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.DARK_GRAY)).append((Component)Component.translatable("item.nbt_tags", Component.text(nbt.size())))).build();
            listTag.add(new StringTag("", MessageTranslator.convertMessage((Component)component, language)));
        }
        compoundTag.put(listTag);
        newNbt.put(compoundTag);
        return newNbt;
    }

    private static String[] getCanModify(ListTag canModifyJava, String[] canModifyBedrock) {
        if (canModifyJava != null && canModifyJava.size() > 0) {
            canModifyBedrock = new String[canModifyJava.size()];
            for (int i = 0; i < canModifyBedrock.length; ++i) {
                Object block = ((StringTag)canModifyJava.get(i)).getValue();
                if (!((String)block).startsWith("minecraft:")) {
                    block = "minecraft:" + (String)block;
                }
                canModifyBedrock[i] = ((String)BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.getOrDefault((String)block, (String)block)).replace("minecraft:", "");
            }
        }
        return canModifyBedrock;
    }

    @Nonnull
    public static ItemMapping getBedrockItemMapping(GeyserSession session, @Nonnull GeyserItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return ItemMapping.AIR;
        }
        int javaId = itemStack.getJavaId();
        return ((ItemTranslator)ITEM_STACK_TRANSLATORS.getOrDefault(javaId, (Object)DEFAULT_TRANSLATOR)).getItemMapping(javaId, itemStack.getNbt(), session.getItemMappings());
    }

    protected ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (itemStack == null) {
            return ItemData.builder();
        }
        ItemData.Builder builder = ItemData.builder().id(mapping.getBedrockId()).damage(mapping.getBedrockData()).count(itemStack.getAmount());
        if (itemStack.getNbt() != null) {
            builder.tag(this.translateNbtToBedrock(itemStack.getNbt()));
        }
        return builder;
    }

    public ItemStack translateToJava(ItemData itemData, ItemMapping mapping, ItemMappings mappings) {
        if (itemData == null) {
            return null;
        }
        if (itemData.getTag() == null) {
            return new ItemStack(mapping.getJavaId(), itemData.getCount(), new CompoundTag(""));
        }
        return new ItemStack(mapping.getJavaId(), itemData.getCount(), this.translateToJavaNBT("", itemData.getTag()));
    }

    public abstract List<ItemMapping> getAppliedItems();

    protected ItemMapping getItemMapping(int javaId, CompoundTag nbt, ItemMappings mappings) {
        return mappings.getMapping(javaId);
    }

    protected NbtMap translateNbtToBedrock(CompoundTag tag) {
        NbtMapBuilder builder = NbtMap.builder();
        if (tag.getValue() != null && !tag.getValue().isEmpty()) {
            for (String str : tag.getValue().keySet()) {
                Object javaTag = tag.get(str);
                Object translatedTag = this.translateToBedrockNBT((Tag)javaTag);
                if (translatedTag == null) continue;
                builder.put(((Tag)javaTag).getName(), translatedTag);
            }
        }
        return builder.build();
    }

    private Object translateToBedrockNBT(Tag tag) {
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).getValue();
        }
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).getValue();
        }
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).getValue();
        }
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).getValue();
        }
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).getValue();
        }
        if (tag instanceof IntTag) {
            return ((IntTag)tag).getValue();
        }
        if (tag instanceof LongArrayTag) {
            return null;
        }
        if (tag instanceof LongTag) {
            return ((LongTag)tag).getValue();
        }
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).getValue();
        }
        if (tag instanceof StringTag) {
            return ((StringTag)tag).getValue();
        }
        Tag tag2 = tag;
        if (tag2 instanceof ListTag) {
            ListTag listTag = (ListTag)tag2;
            ArrayList<Object> tagList = new ArrayList<Object>();
            for (Tag value : listTag) {
                tagList.add(this.translateToBedrockNBT(value));
            }
            NbtType<NbtMap> type = NbtType.COMPOUND;
            if (!tagList.isEmpty()) {
                type = NbtType.byClass(tagList.get(0).getClass());
            }
            return new NbtList<NbtMap>(type, (Collection<NbtMap>)tagList);
        }
        tag2 = tag;
        if (tag2 instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag2;
            return this.translateNbtToBedrock(compoundTag);
        }
        return null;
    }

    private CompoundTag translateToJavaNBT(String name, NbtMap tag) {
        CompoundTag javaTag = new CompoundTag(name);
        Object javaValue = javaTag.getValue();
        if (tag != null && !tag.isEmpty()) {
            for (Map.Entry<String, Object> entry : tag.entrySet()) {
                Tag translatedTag = this.translateToJavaNBT(entry.getKey(), entry.getValue());
                if (translatedTag == null) continue;
                javaValue.put(translatedTag.getName(), translatedTag);
            }
        }
        javaTag.setValue((Map<String, Tag>)javaValue);
        return javaTag;
    }

    private Tag translateToJavaNBT(String name, Object object) {
        if (object instanceof int[]) {
            return new IntArrayTag(name, (int[])object);
        }
        if (object instanceof byte[]) {
            return new ByteArrayTag(name, (byte[])object);
        }
        if (object instanceof Byte) {
            return new ByteTag(name, (Byte)object);
        }
        if (object instanceof Float) {
            return new FloatTag(name, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new DoubleTag(name, (Double)object);
        }
        if (object instanceof Integer) {
            return new IntTag(name, (Integer)object);
        }
        if (object instanceof long[]) {
            return new LongArrayTag(name, (long[])object);
        }
        if (object instanceof Long) {
            return new LongTag(name, (Long)object);
        }
        if (object instanceof Short) {
            return new ShortTag(name, (Short)object);
        }
        if (object instanceof String) {
            return new StringTag(name, (String)object);
        }
        if (object instanceof List) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Object value : (List)object) {
                Tag javaTag = this.translateToJavaNBT("", value);
                if (javaTag == null) continue;
                tags.add(javaTag);
            }
            return new ListTag(name, tags);
        }
        Object object2 = object;
        if (object2 instanceof NbtMap) {
            NbtMap map = (NbtMap)object2;
            return this.translateToJavaNBT(name, map);
        }
        return null;
    }

    public static CompoundTag translateDisplayProperties(GeyserSession session, CompoundTag tag, ItemMapping mapping) {
        return ItemTranslator.translateDisplayProperties(session, tag, mapping, 'f');
    }

    public static CompoundTag translateDisplayProperties(GeyserSession session, CompoundTag tag, ItemMapping mapping, char translationColor) {
        CompoundTag display;
        Object t2;
        boolean hasCustomName = false;
        if (tag != null && (t2 = tag.get("display")) instanceof CompoundTag && (t2 = (display = (CompoundTag)t2).get("Name")) instanceof StringTag) {
            StringTag tagName = (StringTag)t2;
            String name = tagName.getValue();
            name = MessageTranslator.convertMessageLenient(name, session.getLocale());
            display.put(new StringTag("Name", name));
            hasCustomName = true;
            tag.put(display);
        }
        if (!hasCustomName && mapping.hasTranslation()) {
            if (tag == null) {
                tag = new CompoundTag("");
            }
            if ((t2 = tag.get("display")) instanceof CompoundTag) {
                CompoundTag oldDisplay;
                display = oldDisplay = (CompoundTag)t2;
            } else {
                display = new CompoundTag("display");
                tag.put(display);
            }
            String translationKey = mapping.getTranslationString();
            display.put(new StringTag("Name", "\u00a7r\u00a7" + translationColor + MinecraftLocale.getLocaleString(translationKey, session.getLocale())));
        }
        return tag;
    }

    public boolean equals(ItemStack itemStack, ItemStack equalsItemStack, boolean checkAmount, boolean trueIfAmountIsGreater, boolean checkNbt) {
        if (itemStack.getId() != equalsItemStack.getId()) {
            return false;
        }
        if (checkAmount && (trueIfAmountIsGreater ? itemStack.getAmount() < equalsItemStack.getAmount() : itemStack.getAmount() != equalsItemStack.getAmount())) {
            return false;
        }
        if (!checkNbt) {
            return true;
        }
        if ((itemStack.getNbt() == null || itemStack.getNbt().isEmpty()) && equalsItemStack.getNbt() != null && !equalsItemStack.getNbt().isEmpty()) {
            return false;
        }
        if (!(itemStack.getNbt() == null || itemStack.getNbt().isEmpty() || equalsItemStack.getNbt() != null && equalsItemStack.getNbt().isEmpty())) {
            return false;
        }
        if (itemStack.getNbt() != null && equalsItemStack.getNbt() != null) {
            return itemStack.getNbt().equals(equalsItemStack.getNbt());
        }
        return true;
    }

    static {
        HashMap<NbtItemStackTranslator, Integer> loadedNbtItemTranslators = new HashMap<NbtItemStackTranslator, Integer>();
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(ItemRemapper.class)) {
            int priority = clazz.getAnnotation(ItemRemapper.class).priority();
            GeyserImpl.getInstance().getLogger().debug("Found annotated item translator: " + clazz.getCanonicalName());
            try {
                if (NbtItemStackTranslator.class.isAssignableFrom(clazz)) {
                    NbtItemStackTranslator nbtItemTranslator = (NbtItemStackTranslator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    loadedNbtItemTranslators.put(nbtItemTranslator, priority);
                    continue;
                }
                ItemTranslator itemStackTranslator = (ItemTranslator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List<ItemMapping> appliedItems = itemStackTranslator.getAppliedItems();
                for (ItemMapping item : appliedItems) {
                    ItemTranslator registered = (ItemTranslator)ITEM_STACK_TRANSLATORS.get(item.getJavaId());
                    if (registered != null) {
                        GeyserImpl.getInstance().getLogger().error("Could not instantiate annotated item translator " + clazz.getCanonicalName() + ". Item translator " + registered.getClass().getCanonicalName() + " is already registered for the item " + item.getJavaIdentifier());
                        continue;
                    }
                    ITEM_STACK_TRANSLATORS.put(item.getJavaId(), (Object)itemStackTranslator);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                GeyserImpl.getInstance().getLogger().error("Could not instantiate annotated item translator " + clazz.getCanonicalName());
            }
        }
        NBT_TRANSLATORS = loadedNbtItemTranslators.keySet().stream().sorted(Comparator.comparingInt(loadedNbtItemTranslators::get)).collect(Collectors.toList());
        DEFAULT_TRANSLATOR = new ItemTranslator(){

            @Override
            public List<ItemMapping> getAppliedItems() {
                return null;
            }
        };
    }
}

