/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.translator.inventory.item.ItemRemapper;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;

@ItemRemapper
public class CompassTranslator
extends ItemTranslator {
    @Override
    protected ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (this.isLodestoneCompass(itemStack.getNbt())) {
            return super.translateToBedrock(itemStack, mappings.getLodestoneCompass(), mappings);
        }
        return super.translateToBedrock(itemStack, mapping, mappings);
    }

    @Override
    protected ItemMapping getItemMapping(int javaId, CompoundTag nbt, ItemMappings mappings) {
        if (this.isLodestoneCompass(nbt)) {
            return mappings.getLodestoneCompass();
        }
        return super.getItemMapping(javaId, nbt, mappings);
    }

    private boolean isLodestoneCompass(CompoundTag nbt) {
        if (nbt != null) {
            Object lodestoneTag = nbt.get("LodestoneTracked");
            return lodestoneTag instanceof ByteTag;
        }
        return false;
    }

    @Override
    public ItemStack translateToJava(ItemData itemData, ItemMapping mapping, ItemMappings mappings) {
        if (mapping.getBedrockIdentifier().equals("minecraft:lodestone_compass")) {
            mapping = mappings.getStoredItems().compass();
        }
        return super.translateToJava(itemData, mapping, mappings);
    }

    @Override
    public List<ItemMapping> getAppliedItems() {
        return Arrays.stream(Registries.ITEMS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getItems()).filter(entry -> entry.getJavaIdentifier().endsWith("compass")).collect(Collectors.toList());
    }
}

