/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;

public class SingleChestInventoryTranslator
extends ChestInventoryTranslator {
    private final InventoryHolder holder = new BlockInventoryHolder("minecraft:chest[facing=north,type=single,waterlogged=false]", ContainerType.CONTAINER, new String[]{"minecraft:ender_chest", "minecraft:trapped_chest"}){

        @Override
        protected boolean isValidBlock(String[] javaBlockString) {
            if (javaBlockString[0].equals("minecraft:ender_chest")) {
                return true;
            }
            return super.isValidBlock(javaBlockString) && javaBlockString.length > 1 && javaBlockString[1].contains("type=single");
        }
    };

    public SingleChestInventoryTranslator(int size) {
        super(size, 27);
    }

    @Override
    public void prepareInventory(GeyserSession session, Inventory inventory) {
        this.holder.prepareInventory(this, session, inventory);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        this.holder.openInventory(this, session, inventory);
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        this.holder.closeInventory(this, session, inventory);
    }
}

