/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerSlotType;
import com.nukkitx.protocol.bedrock.data.inventory.EnchantOptionData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemStackRequest;
import com.nukkitx.protocol.bedrock.data.inventory.StackRequestSlotInfoData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.CraftRecipeStackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionType;
import com.nukkitx.protocol.bedrock.packet.ItemStackResponsePacket;
import com.nukkitx.protocol.bedrock.packet.PlayerEnchantOptionsPacket;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Arrays;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.EnchantingContainer;
import org.geysermc.geyser.inventory.GeyserEnchantOption;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class EnchantingInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public EnchantingInventoryTranslator() {
        super(2, "minecraft:enchanting_table", com.nukkitx.protocol.bedrock.data.inventory.ContainerType.ENCHANTMENT, UIInventoryUpdater.INSTANCE, new String[0]);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        int slotToUpdate;
        EnchantingContainer enchantingInventory = (EnchantingContainer)inventory;
        boolean shouldUpdate = false;
        switch (key) {
            case 0: 
            case 1: 
            case 2: {
                slotToUpdate = key;
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setXpCost(value);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                slotToUpdate = key - 4;
                int bedrockIndex = value;
                if (bedrockIndex != -1) {
                    Enchantment enchantment = Enchantment.getByJavaIdentifier("minecraft:" + Enchantment.JavaEnchantment.of(bedrockIndex).name().toLowerCase());
                    bedrockIndex = enchantment != null ? enchantment.ordinal() : -1;
                }
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setEnchantIndex(value, bedrockIndex);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                slotToUpdate = key - 7;
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setEnchantLevel(value);
                shouldUpdate = true;
                break;
            }
            default: {
                return;
            }
        }
        GeyserEnchantOption enchantOption = enchantingInventory.getGeyserEnchantOptions()[slotToUpdate];
        if (shouldUpdate && enchantOption.hasChanged()) {
            enchantingInventory.getEnchantOptions()[slotToUpdate] = enchantOption.build(session);
            PlayerEnchantOptionsPacket packet = new PlayerEnchantOptionsPacket();
            packet.getOptions().addAll(Arrays.asList(enchantingInventory.getEnchantOptions()));
            session.sendUpstreamPacket(packet);
        }
    }

    @Override
    protected boolean shouldHandleRequestFirst(StackRequestActionData action, Inventory inventory) {
        return action.getType() == StackRequestActionType.CRAFT_RECIPE;
    }

    @Override
    public ItemStackResponsePacket.Response translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        CraftRecipeStackRequestActionData craftRecipeData = (CraftRecipeStackRequestActionData)request.getActions()[0];
        EnchantingContainer enchantingInventory = (EnchantingContainer)inventory;
        int javaSlot = -1;
        for (int i = 0; i < enchantingInventory.getEnchantOptions().length; ++i) {
            EnchantOptionData enchantData = enchantingInventory.getEnchantOptions()[i];
            if (enchantData == null || craftRecipeData.getRecipeNetworkId() != enchantData.getEnchantNetId()) continue;
            javaSlot = enchantingInventory.getGeyserEnchantOptions()[i].getJavaIndex();
            break;
        }
        if (javaSlot == -1) {
            return EnchantingInventoryTranslator.rejectRequest(request);
        }
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getId(), javaSlot);
        session.sendDownstreamPacket(packet);
        return EnchantingInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, IntSets.emptySet()));
    }

    @Override
    public int bedrockSlotToJava(StackRequestSlotInfoData slotInfoData) {
        if (slotInfoData.getContainer() == ContainerSlotType.ENCHANTING_INPUT) {
            return 0;
        }
        if (slotInfoData.getContainer() == ContainerSlotType.ENCHANTING_LAPIS) {
            return 1;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.ENCHANTING_INPUT, 14);
        }
        if (slot == 1) {
            return new BedrockContainerSlot(ContainerSlotType.ENCHANTING_LAPIS, 15);
        }
        return super.javaSlotToBedrockContainer(slot);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0) {
            return 14;
        }
        if (slot == 1) {
            return 15;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new EnchantingContainer(name, windowId, this.size, containerType, playerInventory);
    }
}

