/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.relocate.kyori.adventure.text.renderer.TranslatableComponentRenderer;

public class MinecraftTranslationRegistry
extends TranslatableComponentRenderer<String> {
    private final Pattern stringReplacement = Pattern.compile("%s");
    private final Pattern positionalStringReplacement = Pattern.compile("%([0-9]+)\\$s");

    @Override
    @Nullable
    public MessageFormat translate(@Nonnull String key, @Nonnull String locale) {
        String localeString = MinecraftLocale.getLocaleString(key, locale);
        Pattern p = this.stringReplacement;
        Matcher m4 = p.matcher(localeString);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (m4.find()) {
            m4.appendReplacement(sb, "{" + i++ + "}");
        }
        m4.appendTail(sb);
        p = this.positionalStringReplacement;
        m4 = p.matcher(sb.toString());
        sb = new StringBuffer();
        while (m4.find()) {
            i = Integer.parseInt(m4.group(1)) - 1;
            m4.appendReplacement(sb, "{" + i + "}");
        }
        m4.appendTail(sb);
        return new MessageFormat(sb.toString().replace("'", "''"), Locale.ROOT);
    }
}

