/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipFile;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;
import org.geysermc.relocate.jackson.annotation.JsonIgnoreProperties;
import org.geysermc.relocate.jackson.annotation.JsonProperty;
import org.geysermc.relocate.jackson.core.TreeNode;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class MinecraftLocale {
    public static final Map<String, Map<String, String>> LOCALE_MAPPINGS = new HashMap<String, Map<String, String>>();
    private static final Map<String, Asset> ASSET_MAP = new HashMap<String, Asset>();
    private static VersionDownload clientJarInfo;

    private static CompletableFuture<Void> generateAssetCache() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                VersionManifest versionManifest = GeyserImpl.JSON_MAPPER.readValue(WebUtils.getBody("https://launchermeta.mojang.com/mc/game/version_manifest.json"), VersionManifest.class);
                String latestInfoURL = "";
                for (Version version : versionManifest.getVersions()) {
                    if (!version.getId().equals(MinecraftProtocol.getJavaCodec().getMinecraftVersion())) continue;
                    latestInfoURL = version.getUrl();
                    break;
                }
                if (latestInfoURL.isEmpty()) {
                    throw new Exception(GeyserLocale.getLocaleStringLog("geyser.locale.fail.latest_version", new Object[0]));
                }
                VersionInfo versionInfo = GeyserImpl.JSON_MAPPER.readValue(WebUtils.getBody(latestInfoURL), VersionInfo.class);
                GeyserImpl.getInstance().getLogger().debug(GeyserImpl.JSON_MAPPER.writeValueAsString(versionInfo.getDownloads()));
                clientJarInfo = versionInfo.getDownloads().get("client");
                GeyserImpl.getInstance().getLogger().debug(GeyserImpl.JSON_MAPPER.writeValueAsString(clientJarInfo));
                JsonNode assets = GeyserImpl.JSON_MAPPER.readTree(WebUtils.getBody(versionInfo.getAssetIndex().getUrl())).get("objects");
                Iterator<Map.Entry<String, JsonNode>> assetIterator = assets.fields();
                while (assetIterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = assetIterator.next();
                    if (!entry.getKey().startsWith("minecraft/lang/")) continue;
                    Asset asset = GeyserImpl.JSON_MAPPER.treeToValue((TreeNode)entry.getValue(), Asset.class);
                    ASSET_MAP.put(entry.getKey(), asset);
                }
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.asset_cache", new Object[]{!e.getMessage().isEmpty() ? e.getMessage() : e.getStackTrace()}));
            }
            return null;
        });
    }

    public static void downloadAndLoadLocale(String locale) {
        if ((locale = locale.toLowerCase(Locale.ROOT)).equals("nb_no")) {
            locale = "no_no";
        }
        if (!ASSET_MAP.containsKey("minecraft/lang/" + locale + ".json") && !locale.equals("en_us")) {
            if (MinecraftLocale.loadLocale(locale)) {
                GeyserImpl.getInstance().getLogger().debug("Loaded locale locally while not being in asset map: " + locale);
            } else {
                GeyserImpl.getInstance().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.locale.fail.invalid", locale));
            }
            return;
        }
        GeyserImpl.getInstance().getLogger().debug("Downloading and loading locale: " + locale);
        MinecraftLocale.downloadLocale(locale);
        if (!MinecraftLocale.loadLocale(locale)) {
            GeyserImpl.getInstance().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.locale.fail.missing", locale));
        }
    }

    private static void downloadLocale(String locale) {
        File localeFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales/" + locale + ".json").toFile();
        if (localeFile.exists()) {
            String targetHash;
            String curHash = "";
            if (locale.equals("en_us")) {
                block16: {
                    try {
                        File hashFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales/en_us.hash").toFile();
                        if (!hashFile.exists()) break block16;
                        try (BufferedReader br = new BufferedReader(new FileReader(hashFile));){
                            curHash = br.readLine().trim();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (clientJarInfo == null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping en_US hash check as client jar is null.");
                    return;
                }
                targetHash = clientJarInfo.getSha1();
            } else {
                curHash = MinecraftLocale.byteArrayToHexString(FileUtils.calculateSHA1(localeFile));
                targetHash = ASSET_MAP.get("minecraft/lang/" + locale + ".json").getHash();
            }
            if (!curHash.equals(targetHash)) {
                GeyserImpl.getInstance().getLogger().debug("Locale out of date; re-downloading: " + locale);
            } else {
                GeyserImpl.getInstance().getLogger().debug("Locale already downloaded and up-to date: " + locale);
                return;
            }
        }
        if (locale.equals("en_us")) {
            MinecraftLocale.downloadEN_US(localeFile);
            return;
        }
        try {
            String hash = ASSET_MAP.get("minecraft/lang/" + locale + ".json").getHash();
            WebUtils.downloadFile("https://resources.download.minecraft.net/" + hash.substring(0, 2) + "/" + hash, localeFile.toString());
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Unable to download locale file hash", e);
        }
    }

    private static boolean loadLocale(String locale) {
        File localeFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales/" + locale + ".json").toFile();
        if (localeFile.exists()) {
            JsonNode localeObj;
            FileInputStream localeStream;
            try {
                localeStream = new FileInputStream(localeFile);
            }
            catch (FileNotFoundException e) {
                throw new AssertionError((Object)GeyserLocale.getLocaleStringLog("geyser.locale.fail.file", locale, e.getMessage()));
            }
            try {
                localeObj = GeyserImpl.JSON_MAPPER.readTree(localeStream);
            }
            catch (Exception e) {
                throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.locale.fail.json", locale), e);
            }
            Iterator<Map.Entry<String, JsonNode>> localeIterator = localeObj.fields();
            HashMap<String, String> langMap = new HashMap<String, String>();
            while (localeIterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = localeIterator.next();
                langMap.put(entry.getKey(), entry.getValue().asText());
            }
            String bedrockLocale = locale.toLowerCase(Locale.ROOT);
            if (bedrockLocale.equals("no_no")) {
                bedrockLocale = "nb_no";
            }
            LOCALE_MAPPINGS.put(bedrockLocale, langMap);
            try {
                ((InputStream)localeStream).close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)GeyserLocale.getLocaleStringLog("geyser.locale.fail.file", locale, e.getMessage()));
            }
            return true;
        }
        return false;
    }

    private static void downloadEN_US(File localeFile) {
        try {
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us", new Object[0]));
            GeyserImpl.getInstance().getLogger().debug("Download URL: " + clientJarInfo.getUrl());
            Path tmpFilePath = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("tmp_locale.jar");
            WebUtils.downloadFile(clientJarInfo.getUrl(), tmpFilePath.toString());
            try (ZipFile localeJar = new ZipFile(tmpFilePath.toString());
                 InputStream fileStream = localeJar.getInputStream(localeJar.getEntry("assets/minecraft/lang/en_us.json"));
                 FileOutputStream outStream = new FileOutputStream(localeFile);){
                int length;
                byte[] buf = new byte[fileStream.available()];
                while ((length = fileStream.read(buf)) != -1) {
                    outStream.write(buf, 0, length);
                }
                outStream.flush();
            }
            FileUtils.writeFile(GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales/en_us.hash").toString(), clientJarInfo.getSha1().toCharArray());
            Files.delete(tmpFilePath);
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us.done", new Object[0]));
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.en_us", new Object[0]), e);
        }
    }

    public static String getLocaleString(String messageText, String locale) {
        Map<String, String> localeStrings = LOCALE_MAPPINGS.get(locale.toLowerCase(Locale.ROOT));
        if (localeStrings == null && (localeStrings = LOCALE_MAPPINGS.get(GeyserLocale.getDefaultLocale())) == null) {
            GeyserImpl.getInstance().getLogger().debug("MISSING DEFAULT LOCALE: " + GeyserLocale.getDefaultLocale());
            return messageText;
        }
        return localeStrings.getOrDefault(messageText, messageText);
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static void init() {
    }

    static {
        File localesFolder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("locales").toFile();
        localesFolder.mkdir();
        MinecraftLocale.generateAssetCache().whenComplete((aVoid, ex) -> MinecraftLocale.downloadAndLoadLocale(GeyserLocale.getDefaultLocale()));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionDownload {
        @JsonProperty(value="sha1")
        private String sha1;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="url")
        private String url;

        VersionDownload() {
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Asset {
        @JsonProperty(value="hash")
        private String hash;
        @JsonProperty(value="size")
        private int size;

        Asset() {
        }

        public String getHash() {
            return this.hash;
        }

        public int getSize() {
            return this.size;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionManifest {
        @JsonProperty(value="latest")
        private LatestVersion latestVersion;
        @JsonProperty(value="versions")
        private List<Version> versions;

        VersionManifest() {
        }

        public LatestVersion getLatestVersion() {
            return this.latestVersion;
        }

        public List<Version> getVersions() {
            return this.versions;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Version {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="time")
        private String time;
        @JsonProperty(value="releaseTime")
        private String releaseTime;

        Version() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionInfo {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="time")
        private String time;
        @JsonProperty(value="releaseTime")
        private String releaseTime;
        @JsonProperty(value="assetIndex")
        private AssetIndex assetIndex;
        @JsonProperty(value="downloads")
        private Map<String, VersionDownload> downloads;

        VersionInfo() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public AssetIndex getAssetIndex() {
            return this.assetIndex;
        }

        public Map<String, VersionDownload> getDownloads() {
            return this.downloads;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class AssetIndex {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="sha1")
        private String sha1;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="totalSize")
        private int totalSize;
        @JsonProperty(value="url")
        private String url;

        AssetIndex() {
        }

        public String getId() {
            return this.id;
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public String getUrl() {
            return this.url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class LatestVersion {
        @JsonProperty(value="release")
        private String release;
        @JsonProperty(value="snapshot")
        private String snapshot;

        LatestVersion() {
        }

        public String getRelease() {
            return this.release;
        }

        public String getSnapshot() {
            return this.snapshot;
        }
    }
}

