/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import org.geysermc.relocate.jackson.annotation.JacksonAnnotationsInside;
import org.geysermc.relocate.jackson.core.JsonGenerator;
import org.geysermc.relocate.jackson.databind.BeanProperty;
import org.geysermc.relocate.jackson.databind.JsonSerializer;
import org.geysermc.relocate.jackson.databind.SerializerProvider;
import org.geysermc.relocate.jackson.databind.annotation.JsonSerialize;
import org.geysermc.relocate.jackson.databind.ser.ContextualSerializer;
import org.geysermc.relocate.jackson.databind.ser.std.StdSerializer;

public class AsteriskSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    public static boolean showSensitive = false;
    String asterisk;
    boolean isIp;

    public AsteriskSerializer() {
        super(Object.class);
    }

    public AsteriskSerializer(String asterisk, boolean isIp) {
        super(Object.class);
        this.asterisk = asterisk;
        this.isIp = isIp;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty property) {
        Optional<Asterisk> anno = Optional.ofNullable(property).map(prop -> prop.getAnnotation(Asterisk.class));
        return new AsteriskSerializer(anno.map(Asterisk::value).orElse(null), (boolean)anno.map(Asterisk::isIp).orElse(null));
    }

    @Override
    public void serialize(Object obj, JsonGenerator gen, SerializerProvider prov) throws IOException {
        if (this.isIp && (showSensitive || !this.isSensitiveIp((String)obj))) {
            gen.writeObject(obj);
            return;
        }
        gen.writeString(this.asterisk);
    }

    private boolean isSensitiveIp(String ip) {
        if (ip.equalsIgnoreCase("localhost") || ip.equalsIgnoreCase("auto")) {
            return false;
        }
        return !ip.isEmpty() && !ip.equals("0.0.0.0") && !ip.equals("127.0.0.1");
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @JacksonAnnotationsInside
    @JsonSerialize(using=AsteriskSerializer.class)
    public static @interface Asterisk {
        public String value() default "***";

        public boolean isIp() default false;
    }
}

