/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.packet.PlayerSkinPacket;
import java.util.Collections;
import java.util.function.Consumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;

public class SkullSkinManager
extends SkinManager {
    public static SerializedSkin buildSkullEntryManually(String skinId, byte[] skinData) {
        skinId = (String)skinId + "_skull";
        return SerializedSkin.of((String)skinId, "", SkinProvider.SKULL_GEOMETRY.getGeometryName(), ImageData.of(skinData), Collections.emptyList(), ImageData.of(SkinProvider.EMPTY_CAPE.getCapeData()), SkinProvider.SKULL_GEOMETRY.getGeometryData(), "", true, false, false, SkinProvider.EMPTY_CAPE.getCapeId(), (String)skinId);
    }

    public static void requestAndHandleSkin(PlayerEntity entity, GeyserSession session, Consumer<SkinProvider.Skin> skinConsumer) {
        SkinManager.GameProfileData data = SkinManager.GameProfileData.from(entity);
        SkinProvider.requestSkin(entity.getUuid(), data.skinUrl(), true).whenCompleteAsync((skin, throwable) -> {
            try {
                PlayerSkinPacket packet = new PlayerSkinPacket();
                packet.setUuid(entity.getUuid());
                packet.setOldSkinName("");
                packet.setNewSkinName(skin.getTextureUrl());
                packet.setSkin(SkullSkinManager.buildSkullEntryManually(skin.getTextureUrl(), skin.getSkinData()));
                packet.setTrustedSkin(true);
                session.sendUpstreamPacket(packet);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), e);
            }
            if (skinConsumer != null) {
                skinConsumer.accept((SkinProvider.Skin)skin);
            }
        });
    }
}

