/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.packet.SetTitlePacket;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.ChunkUtils;

public final class WorldCache {
    private final GeyserSession session;
    private final ScoreboardUpdater.ScoreboardSession scoreboardSession;
    private Scoreboard scoreboard;
    private Difficulty difficulty = Difficulty.EASY;
    private boolean titleTimesNeedReset = false;
    private int trueTitleFadeInTime;
    private int trueTitleStayTime;
    private int trueTitleFadeOutTime;
    private int currentSequence;
    private final Map<Vector3i, ServerVerifiedState> unverifiedPredictions = new Object2ObjectOpenHashMap(1);

    public WorldCache(GeyserSession session) {
        this.session = session;
        this.scoreboard = new Scoreboard(session);
        this.scoreboardSession = new ScoreboardUpdater.ScoreboardSession(session);
        this.resetTitleTimes(false);
    }

    public void removeScoreboard() {
        if (this.scoreboard != null) {
            this.scoreboard.removeScoreboard();
            this.scoreboard = new Scoreboard(this.session);
        }
    }

    public int increaseAndGetScoreboardPacketsPerSecond() {
        int pendingPps = this.scoreboardSession.getPendingPacketsPerSecond().incrementAndGet();
        int pps = this.scoreboardSession.getPacketsPerSecond();
        return Math.max(pps, pendingPps);
    }

    public void markTitleTimesAsIncorrect() {
        this.titleTimesNeedReset = true;
    }

    public void setTitleTimes(int fadeInTime, int stayTime, int fadeOutTime) {
        this.trueTitleFadeInTime = fadeInTime;
        this.trueTitleStayTime = stayTime;
        this.trueTitleFadeOutTime = fadeOutTime;
        this.titleTimesNeedReset = false;
    }

    public void synchronizeCorrectTitleTimes() {
        if (this.titleTimesNeedReset) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    private void forceSyncCorrectTitleTimes() {
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TIMES);
        titlePacket.setText("");
        titlePacket.setFadeInTime(this.trueTitleFadeInTime);
        titlePacket.setStayTime(this.trueTitleStayTime);
        titlePacket.setFadeOutTime(this.trueTitleFadeOutTime);
        titlePacket.setPlatformOnlineId("");
        titlePacket.setXuid("");
        this.session.sendUpstreamPacket(titlePacket);
        this.titleTimesNeedReset = false;
    }

    public void resetTitleTimes(boolean clientSync) {
        this.trueTitleFadeInTime = 10;
        this.trueTitleStayTime = 70;
        this.trueTitleFadeOutTime = 20;
        if (clientSync) {
            this.forceSyncCorrectTitleTimes();
        }
    }

    public int nextPredictionSequence() {
        return ++this.currentSequence;
    }

    public void addServerCorrectBlockState(Vector3i position, int blockState) {
        if (this.session.isEmulatePost1_18Logic()) {
            this.unverifiedPredictions.compute(position, ($, serverVerifiedState) -> serverVerifiedState == null ? new ServerVerifiedState(this.currentSequence, blockState) : serverVerifiedState.setData(this.currentSequence, blockState));
        }
    }

    public void updateServerCorrectBlockState(Vector3i position) {
        if (this.unverifiedPredictions.isEmpty()) {
            return;
        }
        this.unverifiedPredictions.remove(position);
    }

    public void endPredictionsUpTo(int sequence) {
        if (this.unverifiedPredictions.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Vector3i, ServerVerifiedState>> it = this.unverifiedPredictions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Vector3i, ServerVerifiedState> entry = it.next();
            ServerVerifiedState serverVerifiedState = entry.getValue();
            if (serverVerifiedState.sequence > sequence) continue;
            ChunkUtils.updateBlockClientSide(this.session, serverVerifiedState.blockState, entry.getKey());
            it.remove();
        }
    }

    public ScoreboardUpdater.ScoreboardSession getScoreboardSession() {
        return this.scoreboardSession;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    private static class ServerVerifiedState {
        private int sequence;
        private int blockState;

        ServerVerifiedState(int sequence, int blockState) {
            this.sequence = sequence;
            this.blockState = blockState;
        }

        ServerVerifiedState setData(int sequence, int blockState) {
            this.sequence = sequence;
            this.blockState = blockState;
            return this;
        }

        public String toString() {
            return "ServerVerifiedState{sequence=" + this.sequence + ", blockState=" + this.blockState + "}";
        }
    }
}

