/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.auth;

import java.io.IOException;
import org.geysermc.relocate.jackson.core.JsonParser;
import org.geysermc.relocate.jackson.databind.DeserializationContext;
import org.geysermc.relocate.jackson.databind.JsonDeserializer;

public enum AuthType {
    OFFLINE,
    ONLINE,
    FLOODGATE;

    public static final AuthType[] VALUES;

    public static AuthType getById(int id) {
        return id < VALUES.length ? VALUES[id] : OFFLINE;
    }

    public static AuthType getByName(String name) {
        String upperCase = name.toUpperCase();
        for (AuthType type : VALUES) {
            if (!type.name().equals(upperCase)) continue;
            return type;
        }
        return ONLINE;
    }

    static {
        VALUES = AuthType.values();
    }

    public static class Deserializer
    extends JsonDeserializer<AuthType> {
        @Override
        public AuthType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return AuthType.getByName(p.getValueAsString());
        }
    }
}

