/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public final class SessionManager {
    private final Set<GeyserSession> pendingSessions = ConcurrentHashMap.newKeySet();
    private final Map<UUID, GeyserSession> sessions = new ConcurrentHashMap<UUID, GeyserSession>();

    public void addPendingSession(GeyserSession session) {
        this.pendingSessions.add(session);
    }

    public void addSession(UUID uuid, GeyserSession session) {
        this.pendingSessions.remove(session);
        this.sessions.put(uuid, session);
    }

    public void removeSession(GeyserSession session) {
        if (this.sessions.remove(session.getPlayerEntity().getUuid()) == null) {
            this.pendingSessions.remove(session);
        }
    }

    public List<GeyserSession> getAllSessions() {
        return ImmutableList.builder().addAll(this.pendingSessions).addAll(this.sessions.values()).build();
    }

    public void disconnectAll(String message) {
        List<GeyserSession> sessions = this.getAllSessions();
        for (GeyserSession session : sessions) {
            session.disconnect(GeyserLocale.getPlayerLocaleString(message, session.getLocale(), new Object[0]));
        }
    }

    public int size() {
        return this.pendingSessions.size() + this.sessions.size();
    }

    Set<GeyserSession> getPendingSessions() {
        return this.pendingSessions;
    }

    public Map<UUID, GeyserSession> getSessions() {
        return this.sessions;
    }
}

