/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.InvalidCredentialsException;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.AuthenticationService;
import com.github.steveice10.mc.auth.service.MojangAuthenticationService;
import com.github.steveice10.mc.auth.service.MsaAuthenticationService;
import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.data.ProtocolState;
import com.github.steveice10.mc.protocol.data.UnexpectedEncryptionException;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Pose;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.HandPreference;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.mc.protocol.data.game.setting.ChatVisibility;
import com.github.steveice10.mc.protocol.data.game.setting.SkinPart;
import com.github.steveice10.mc.protocol.data.game.statistic.CustomStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.Statistic;
import com.github.steveice10.mc.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundChatCommandPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundChatPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundClientInformationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundUseItemPacket;
import com.github.steveice10.mc.protocol.packet.login.serverbound.ServerboundCustomQueryPacket;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.event.session.ConnectedEvent;
import com.github.steveice10.packetlib.event.session.DisconnectedEvent;
import com.github.steveice10.packetlib.event.session.PacketErrorEvent;
import com.github.steveice10.packetlib.event.session.PacketSendingEvent;
import com.github.steveice10.packetlib.event.session.SessionAdapter;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.tcp.TcpClientSession;
import com.github.steveice10.packetlib.tcp.TcpSession;
import com.nukkitx.math.GenericMath;
import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector2i;
import com.nukkitx.math.vector.Vector3d;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockServerSession;
import com.nukkitx.protocol.bedrock.data.Ability;
import com.nukkitx.protocol.bedrock.data.AbilityLayer;
import com.nukkitx.protocol.bedrock.data.AdventureSetting;
import com.nukkitx.protocol.bedrock.data.AttributeData;
import com.nukkitx.protocol.bedrock.data.AuthoritativeMovementMode;
import com.nukkitx.protocol.bedrock.data.ChatRestrictionLevel;
import com.nukkitx.protocol.bedrock.data.GamePublishSetting;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.SyncedPlayerMovementSettings;
import com.nukkitx.protocol.bedrock.data.command.CommandPermission;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.AdventureSettingsPacket;
import com.nukkitx.protocol.bedrock.packet.AvailableEntityIdentifiersPacket;
import com.nukkitx.protocol.bedrock.packet.BiomeDefinitionListPacket;
import com.nukkitx.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import com.nukkitx.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import com.nukkitx.protocol.bedrock.packet.CreativeContentPacket;
import com.nukkitx.protocol.bedrock.packet.EmoteListPacket;
import com.nukkitx.protocol.bedrock.packet.GameRulesChangedPacket;
import com.nukkitx.protocol.bedrock.packet.ItemComponentPacket;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEvent2Packet;
import com.nukkitx.protocol.bedrock.packet.PlayStatusPacket;
import com.nukkitx.protocol.bedrock.packet.PlayerFogPacket;
import com.nukkitx.protocol.bedrock.packet.SetTimePacket;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.packet.TextPacket;
import com.nukkitx.protocol.bedrock.packet.TransferPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAbilitiesPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAdventureSettingsPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.common.value.qual.IntRange;
import org.geysermc.common.PlatformType;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.command.CommandSender;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.physics.CollisionManager;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.UpstreamSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.session.cache.AdvancementsCache;
import org.geysermc.geyser.session.cache.BookEditCache;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.session.cache.EntityCache;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.session.cache.FormCache;
import org.geysermc.geyser.session.cache.LodestoneCache;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.session.cache.PreferencesCache;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.session.cache.WorldBorder;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class GeyserSession
implements GeyserConnection,
CommandSender {
    @Nonnull
    private final GeyserImpl geyser;
    @Nonnull
    private final UpstreamSession upstream;
    @Nonnull
    private final EventLoop eventLoop;
    private TcpSession downstream;
    private AuthData authData;
    private BedrockClientData clientData;
    private JsonNode certChainData;
    private String remoteAddress;
    private int remotePort;
    private AuthType remoteAuthType;
    @Deprecated
    private boolean microsoftAccount;
    private final SessionPlayerEntity playerEntity;
    private final AdvancementsCache advancementsCache;
    private final BookEditCache bookEditCache;
    private final ChunkCache chunkCache;
    private final EntityCache entityCache;
    private final EntityEffectCache effectCache;
    private final FormCache formCache;
    private final LodestoneCache lodestoneCache;
    private final PistonCache pistonCache;
    private final PreferencesCache preferencesCache;
    private final SkullCache skullCache;
    private final TagCache tagCache;
    private final WorldCache worldCache;
    private TeleportCache unconfirmedTeleport;
    private final WorldBorder worldBorder;
    private boolean isInWorldBorderWarningArea = false;
    private final PlayerInventory playerInventory;
    private Inventory openInventory;
    private boolean closingInventory;
    private InventoryTranslator inventoryTranslator = InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR;
    private final AtomicInteger itemNetId = new AtomicInteger(2);
    private ScheduledFuture<?> craftingGridFuture;
    private final CollisionManager collisionManager;
    private BlockMappings blockMappings;
    private ItemMappings itemMappings;
    private final Long2ObjectMap<ClientboundMapItemDataPacket> storedMaps = new Long2ObjectOpenHashMap();
    private int biomeGlobalPalette;
    private final Int2IntMap biomeTranslations = new Int2IntOpenHashMap();
    private final Map<Vector3i, ItemFrameEntity> itemFrameCache = new Object2ObjectOpenHashMap();
    private final Set<Vector3i> lecternCache;
    private final Set<UUID> playerWithCustomHeads = new ObjectOpenHashSet();
    private boolean droppingLecternBook;
    private Vector2i lastChunkPosition = null;
    private int clientRenderDistance = -1;
    private int serverRenderDistance;
    protected boolean sentSpawnPacket;
    private boolean loggedIn;
    private boolean loggingIn;
    private boolean spawned;
    private volatile boolean closed;
    private GameMode gameMode = GameMode.SURVIVAL;
    private String worldName = null;
    private boolean sneaking;
    private Pose pose = Pose.STANDING;
    private boolean sprinting;
    private boolean swimmingInWater;
    private float originalSpeedAttribute;
    private String dimension = "minecraft:overworld";
    private @MonotonicNonNull JavaDimension dimensionType = null;
    private final Map<String, JavaDimension> dimensions = new Object2ObjectOpenHashMap(3);
    private final Int2ObjectMap<TextDecoration> chatTypes = new Int2ObjectOpenHashMap(7);
    private int breakingBlock;
    private Vector3i lastBlockPlacePosition;
    private String lastBlockPlacedId;
    private boolean interacting;
    private Vector3i lastInteractionBlockPosition = Vector3i.ZERO;
    private Vector3f lastInteractionPlayerPosition = Vector3f.ZERO;
    private Entity mouseoverEntity;
    private Int2ObjectMap<GeyserRecipe> craftingRecipes;
    private final AtomicInteger lastRecipeNetId;
    private Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes;
    private boolean emulatePost1_13Logic = true;
    private boolean emulatePost1_16Logic = true;
    private boolean emulatePost1_18Logic = true;
    private double attackSpeed = 4.0;
    private long lastHitTime;
    private boolean steeringLeft;
    private boolean steeringRight;
    private long lastInteractionTime;
    private boolean placedBucket;
    private long lastMovementTimestamp = System.currentTimeMillis();
    private long lastVehicleMoveTimestamp = System.currentTimeMillis();
    private int armAnimationTicks = -1;
    private boolean daylightCycle = true;
    private boolean reducedDebugInfo = false;
    private int opPermissionLevel = 0;
    private boolean canFly = false;
    private boolean flying = false;
    private boolean instabuild = false;
    private float flySpeed;
    private float walkSpeed;
    private boolean raining = false;
    private boolean thunder = false;
    private final Object2IntMap<Statistic> statistics = new Object2IntOpenHashMap(0);
    private boolean waitingForStatistics = false;
    private final Set<String> fogNameSpaces = new HashSet<String>();
    private final Set<UUID> emotes;
    private boolean advancedTooltips = false;
    private ScheduledFuture<?> tickThread = null;
    private ScheduledFuture<?> lookBackScheduledFuture = null;
    private com.github.steveice10.mc.protocol.MinecraftProtocol protocol;
    private static final Ability[] USED_ABILITIES = Ability.values();
    private static final List<SkinPart> SKIN_PARTS = Arrays.asList(SkinPart.values());

    public GeyserSession(GeyserImpl geyser, BedrockServerSession bedrockServerSession, EventLoop eventLoop) {
        this.geyser = geyser;
        this.upstream = new UpstreamSession(bedrockServerSession);
        this.eventLoop = eventLoop;
        this.advancementsCache = new AdvancementsCache(this);
        this.bookEditCache = new BookEditCache(this);
        this.chunkCache = new ChunkCache(this);
        this.entityCache = new EntityCache(this);
        this.effectCache = new EntityEffectCache();
        this.formCache = new FormCache(this);
        this.lodestoneCache = new LodestoneCache();
        this.pistonCache = new PistonCache(this);
        this.preferencesCache = new PreferencesCache(this);
        this.skullCache = new SkullCache(this);
        this.tagCache = new TagCache();
        this.worldCache = new WorldCache(this);
        this.worldBorder = new WorldBorder(this);
        this.collisionManager = new CollisionManager(this);
        this.playerEntity = new SessionPlayerEntity(this);
        this.collisionManager.updatePlayerBoundingBox(this.playerEntity.getPosition());
        this.playerInventory = new PlayerInventory();
        this.openInventory = null;
        this.craftingRecipes = new Int2ObjectOpenHashMap();
        this.lastRecipeNetId = new AtomicInteger(1);
        this.spawned = false;
        this.loggedIn = false;
        this.lecternCache = geyser.getWorldManager().shouldExpectLecternHandled() ? null : new ObjectOpenHashSet();
        if (geyser.getConfig().getEmoteOffhandWorkaround() != EmoteOffhandWorkaroundOption.NO_EMOTES) {
            this.emotes = new HashSet<UUID>();
            geyser.getSessionManager().getSessions().values().forEach(player -> this.emotes.addAll(player.getEmotes()));
        } else {
            this.emotes = null;
        }
        bedrockServerSession.addDisconnectHandler(disconnectReason -> {
            String message = switch (disconnectReason) {
                case DisconnectReason.CLOSED_BY_REMOTE_PEER -> GeyserLocale.getLocaleStringLog("geyser.network.disconnect.closed_by_remote_peer", new Object[0]);
                case DisconnectReason.TIMED_OUT -> GeyserLocale.getLocaleStringLog("geyser.network.disconnect.timed_out", new Object[0]);
                default -> disconnectReason.name();
            };
            this.disconnect(message);
        });
        this.remoteAddress = geyser.getConfig().getRemote().getAddress();
        this.remotePort = geyser.getConfig().getRemote().getPort();
        this.remoteAuthType = geyser.getConfig().getRemote().getAuthType();
    }

    public void connect() {
        this.startGame();
        this.sentSpawnPacket = true;
        this.upstream.getSession().getHardcodedBlockingId().set(this.itemMappings.getStoredItems().shield().getBedrockId());
        if (this.itemMappings.getFurnaceMinecartData() != null) {
            ItemComponentPacket componentPacket = new ItemComponentPacket();
            componentPacket.getItems().add(this.itemMappings.getFurnaceMinecartData());
            this.upstream.sendPacket(componentPacket);
        }
        ChunkUtils.sendEmptyChunks(this, this.playerEntity.getPosition().toInt(), 0, false);
        BiomeDefinitionListPacket biomeDefinitionListPacket = new BiomeDefinitionListPacket();
        biomeDefinitionListPacket.setDefinitions((NbtMap)Registries.BIOMES_NBT.get());
        this.upstream.sendPacket(biomeDefinitionListPacket);
        AvailableEntityIdentifiersPacket entityPacket = new AvailableEntityIdentifiersPacket();
        entityPacket.setIdentifiers((NbtMap)Registries.BEDROCK_ENTITY_IDENTIFIERS.get());
        this.upstream.sendPacket(entityPacket);
        CreativeContentPacket creativePacket = new CreativeContentPacket();
        creativePacket.setContents(this.itemMappings.getCreativeItems());
        this.upstream.sendPacket(creativePacket);
        PlayStatusPacket playStatusPacket = new PlayStatusPacket();
        playStatusPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
        this.upstream.sendPacket(playStatusPacket);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.getPlayerEntity().getGeyserId());
        attributesPacket.setAttributes(Collections.singletonList(new AttributeData("minecraft:movement", 0.0f, 1024.0f, 0.1f, 0.1f)));
        this.upstream.sendPacket(attributesPacket);
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("naturalregeneration", false));
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("keepinventory", true));
        gamerulePacket.getGameRules().add(new GameRuleData<Integer>("spawnradius", 0));
        this.upstream.sendPacket(gamerulePacket);
    }

    public void authenticate(String username) {
        this.authenticate(username, "");
    }

    public void authenticate(String username, String password) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", username));
            return;
        }
        this.loggingIn = true;
        CompletableFuture.supplyAsync(() -> {
            try {
                if (password != null && !password.isEmpty()) {
                    AuthenticationService authenticationService = this.microsoftAccount ? new MsaAuthenticationService("204cefd1-4818-4de1-b98d-513fae875d88") : new MojangAuthenticationService();
                    authenticationService.setUsername(username);
                    authenticationService.setPassword(password);
                    authenticationService.login();
                    GameProfile profile = authenticationService.getSelectedProfile();
                    if (profile == null) {
                        this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.network.remote.invalid_account", this.clientData.getLanguageCode(), new Object[0]));
                        return null;
                    }
                    this.protocol = new com.github.steveice10.mc.protocol.MinecraftProtocol(profile, authenticationService.getAccessToken());
                } else {
                    String validUsername = username;
                    if (this.remoteAuthType == AuthType.FLOODGATE) {
                        validUsername = username.replace(' ', '_');
                    }
                    this.protocol = new com.github.steveice10.mc.protocol.MinecraftProtocol(validUsername);
                }
            }
            catch (InvalidCredentialsException | IllegalArgumentException e) {
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.auth.login.invalid", username));
                this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.login.invalid.kick", this.getClientData().getLanguageCode(), new Object[0]));
            }
            catch (RequestException ex) {
                this.disconnect(ex.getMessage());
            }
            return null;
        }).whenComplete((aVoid, ex) -> {
            if (ex != null) {
                this.disconnect(ex.toString());
            }
            if (this.closed) {
                if (ex != null) {
                    this.geyser.getLogger().error("", (Throwable)ex);
                }
                return;
            }
            this.connectDownstream();
        });
    }

    public void authenticateWithRefreshToken(String refreshToken) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        CompletableFuture.supplyAsync(() -> {
            MsaAuthenticationService service = new MsaAuthenticationService("204cefd1-4818-4de1-b98d-513fae875d88");
            service.setRefreshToken(refreshToken);
            try {
                service.login();
            }
            catch (RequestException e) {
                this.geyser.getLogger().error("Error while attempting to use refresh token for " + this.name() + "!", e);
                return Boolean.FALSE;
            }
            GameProfile profile = service.getSelectedProfile();
            if (profile == null) {
                this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.network.remote.invalid_account", this.clientData.getLanguageCode(), new Object[0]));
                return null;
            }
            this.protocol = new com.github.steveice10.mc.protocol.MinecraftProtocol(profile, service.getAccessToken());
            this.geyser.saveRefreshToken(this.name(), service.getRefreshToken());
            return Boolean.TRUE;
        }).whenComplete((successful, ex) -> {
            if (this.closed) {
                return;
            }
            if (successful == Boolean.FALSE) {
                this.connect();
                LoginEncryptionUtils.buildAndShowTokenExpiredWindow(this);
                return;
            }
            this.connectDownstream();
        });
    }

    public void authenticateWithMicrosoftCode() {
        this.authenticateWithMicrosoftCode(false);
    }

    public void authenticateWithMicrosoftCode(boolean offlineAccess) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        SetTimePacket packet = new SetTimePacket();
        packet.setTime(16000);
        this.sendUpstreamPacket(packet);
        PendingMicrosoftAuthentication.AuthenticationTask task = this.geyser.getPendingMicrosoftAuthentication().getOrCreateTask(this.getAuthData().xuid());
        task.setOnline(true);
        task.resetTimer();
        if (task.getAuthentication().isDone()) {
            this.onMicrosoftLoginComplete(task);
        } else {
            task.getCode(offlineAccess).whenComplete((response, ex) -> {
                boolean connected;
                boolean bl = connected = !this.closed;
                if (ex != null) {
                    if (connected) {
                        this.geyser.getLogger().error("Failed to get Microsoft auth code", (Throwable)ex);
                        this.disconnect(ex.toString());
                    }
                    task.cleanup();
                } else if (connected) {
                    LoginEncryptionUtils.buildAndShowMicrosoftCodeWindow(this, response);
                    task.getAuthentication().whenComplete((r, $) -> this.onMicrosoftLoginComplete(task));
                }
            });
        }
    }

    public boolean onMicrosoftLoginComplete(PendingMicrosoftAuthentication.AuthenticationTask task) {
        if (this.closed) {
            return false;
        }
        task.cleanup();
        Throwable ex = task.getLoginException();
        if (ex != null) {
            this.geyser.getLogger().error("Failed to log in with Microsoft code!", ex);
            this.disconnect(ex.toString());
        } else {
            MsaAuthenticationService service = task.getMsaAuthenticationService();
            GameProfile selectedProfile = service.getSelectedProfile();
            if (selectedProfile == null) {
                this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.network.remote.invalid_account", this.clientData.getLanguageCode(), new Object[0]));
            } else {
                this.protocol = new com.github.steveice10.mc.protocol.MinecraftProtocol(selectedProfile, service.getAccessToken());
                this.connectDownstream();
                this.geyser.saveRefreshToken(this.name(), service.getRefreshToken());
                return true;
            }
        }
        return false;
    }

    private void connectDownstream() {
        final boolean floodgate = this.remoteAuthType == AuthType.FLOODGATE;
        this.tickThread = this.eventLoop.scheduleAtFixedRate(this::tick, 50L, 50L, TimeUnit.MILLISECONDS);
        if (this.geyser.getBootstrap().getSocketAddress() != null) {
            this.downstream = new LocalSession(this.remoteAddress, this.remotePort, this.geyser.getBootstrap().getSocketAddress(), this.upstream.getAddress().getAddress().getHostAddress(), this.protocol, this.protocol.createHelper());
        } else {
            this.downstream = new TcpClientSession(this.remoteAddress, this.remotePort, this.protocol);
            this.disableSrvResolving();
        }
        if (this.geyser.getConfig().getRemote().isUseProxyProtocol()) {
            this.downstream.setFlag("enable-client-proxy-protocol", true);
            this.downstream.setFlag("client-proxied-address", this.upstream.getAddress());
        }
        if (this.geyser.getConfig().isForwardPlayerPing()) {
            this.downstream.setFlag("manage-keep-alive", false);
        }
        this.downstream.addListener(new SessionAdapter(){

            @Override
            public void packetSending(PacketSendingEvent event) {
                if (event.getPacket() instanceof ClientIntentionPacket) {
                    Object addressSuffix;
                    if (floodgate) {
                        byte[] encryptedData;
                        try {
                            FloodgateSkinUploader skinUploader = GeyserSession.this.geyser.getSkinUploader();
                            FloodgateCipher cipher = GeyserSession.this.geyser.getCipher();
                            String bedrockAddress = GeyserSession.this.upstream.getAddress().getAddress().getHostAddress();
                            int ipv6ScopeIndex = bedrockAddress.indexOf(37);
                            if (ipv6ScopeIndex != -1) {
                                bedrockAddress = bedrockAddress.substring(0, ipv6ScopeIndex);
                            }
                            encryptedData = cipher.encryptFromString(BedrockData.of(GeyserSession.this.clientData.getGameVersion(), GeyserSession.this.authData.name(), GeyserSession.this.authData.xuid(), GeyserSession.this.clientData.getDeviceOs().ordinal(), GeyserSession.this.clientData.getLanguageCode(), GeyserSession.this.clientData.getUiProfile().ordinal(), GeyserSession.this.clientData.getCurrentInputMode().ordinal(), bedrockAddress, skinUploader.getId(), skinUploader.getVerifyCode()).toString());
                        }
                        catch (Exception e) {
                            GeyserSession.this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.encrypt_fail", new Object[0]), e);
                            GeyserSession.this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.floodgate.encryption_fail", GeyserSession.this.getClientData().getLanguageCode(), new Object[0]));
                            return;
                        }
                        addressSuffix = "\u0000" + new String(encryptedData, StandardCharsets.UTF_8);
                    } else {
                        addressSuffix = "";
                    }
                    ClientIntentionPacket intentionPacket = (ClientIntentionPacket)event.getPacket();
                    String address = GeyserSession.this.geyser.getConfig().getRemote().isForwardHost() ? GeyserSession.this.clientData.getServerAddress().split(":")[0] : intentionPacket.getHostname();
                    event.setPacket(intentionPacket.withHostname(address + (String)addressSuffix));
                }
            }

            @Override
            public void connected(ConnectedEvent event) {
                GeyserSession.this.loggingIn = false;
                GeyserSession.this.loggedIn = true;
                if (GeyserSession.this.downstream instanceof LocalSession) {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect_internal", GeyserSession.this.authData.name(), GeyserSession.this.protocol.getProfile().getName()));
                } else {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect", GeyserSession.this.authData.name(), GeyserSession.this.protocol.getProfile().getName(), GeyserSession.this.remoteAddress));
                }
                UUID uuid = GeyserSession.this.protocol.getProfile().getId();
                if (uuid == null) {
                    uuid = GeyserSession.this.remoteAuthType == AuthType.FLOODGATE ? new UUID(0L, Long.parseLong(GeyserSession.this.authData.xuid())) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + GeyserSession.this.protocol.getProfile().getName()).getBytes(StandardCharsets.UTF_8));
                }
                GeyserSession.this.playerEntity.setUuid(uuid);
                GeyserSession.this.playerEntity.setUsername(GeyserSession.this.protocol.getProfile().getName());
                String locale = GeyserSession.this.clientData.getLanguageCode();
                if (locale.equalsIgnoreCase("en_us") && !MinecraftLocale.LOCALE_MAPPINGS.containsKey("en_us")) {
                    GeyserSession.this.sendMessage("Loading your locale (en_us); if this isn't already downloaded, this may take some time");
                }
                MinecraftLocale.downloadAndLoadLocale(locale);
            }

            @Override
            public void disconnected(DisconnectedEvent event) {
                String disconnectMessage;
                GeyserSession.this.loggingIn = false;
                GeyserSession.this.loggedIn = false;
                Throwable cause = event.getCause();
                if (cause instanceof UnexpectedEncryptionException) {
                    if (GeyserSession.this.remoteAuthType != AuthType.FLOODGATE) {
                        disconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.authentication_type_mismatch", GeyserSession.this.getLocale(), new Object[0]);
                        GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog(GeyserSession.this.geyser.getPlatformType() == PlatformType.STANDALONE ? "geyser.network.remote.floodgate_explanation_standalone" : "geyser.network.remote.floodgate_explanation_plugin", "https://ci.opencollab.dev/job/GeyserMC/job/Floodgate/job/master/"));
                    } else {
                        disconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.floodgate_login_error", GeyserSession.this.getLocale(), new Object[0]);
                        if (GeyserSession.this.geyser.getPlatformType() == PlatformType.STANDALONE) {
                            GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.remote.floodgate_login_error_standalone", new Object[0]));
                        }
                    }
                } else {
                    disconnectMessage = cause instanceof ConnectException ? GeyserLocale.getPlayerLocaleString("geyser.network.remote.server_offline", GeyserSession.this.getLocale(), new Object[0]) : MessageTranslator.convertMessageLenient(event.getReason());
                }
                if (GeyserSession.this.downstream instanceof LocalSession) {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect_internal", GeyserSession.this.authData.name(), disconnectMessage));
                } else {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect", GeyserSession.this.authData.name(), GeyserSession.this.remoteAddress, disconnectMessage));
                }
                if (cause != null) {
                    cause.printStackTrace();
                }
                GeyserSession.this.upstream.disconnect(disconnectMessage);
            }

            @Override
            public void packetReceived(Session session, Packet packet) {
                Registries.JAVA_PACKET_TRANSLATORS.translate(packet.getClass(), packet, GeyserSession.this);
            }

            @Override
            public void packetError(PacketErrorEvent event) {
                GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.downstream_error", event.getCause().getMessage()));
                if (GeyserSession.this.geyser.getConfig().isDebugMode()) {
                    event.getCause().printStackTrace();
                }
                event.setSuppress(true);
            }
        });
        if (!this.daylightCycle) {
            this.setDaylightCycle(true);
        }
        this.downstream.connect(false);
    }

    public void disconnect(String reason) {
        if (!this.closed) {
            PendingMicrosoftAuthentication.AuthenticationTask task;
            this.loggedIn = false;
            if (this.downstream != null) {
                this.downstream.disconnect(reason);
            } else {
                InetAddress address = this.upstream.getAddress().getAddress();
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.disconnect", address, reason));
            }
            if (!this.upstream.isClosed()) {
                this.upstream.disconnect(reason);
            }
            this.geyser.getSessionManager().removeSession(this);
            if (this.authData != null && (task = this.geyser.getPendingMicrosoftAuthentication().getTask(this.authData.xuid())) != null) {
                task.setOnline(false);
            }
        }
        if (this.tickThread != null) {
            this.tickThread.cancel(false);
        }
        this.closed = true;
    }

    public void executeInEventLoop(Runnable runnable) {
        this.eventLoop.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.geyser.getLogger().error("Error thrown in " + this.name() + "'s event loop!", e);
            }
        });
    }

    public ScheduledFuture<?> scheduleInEventLoop(Runnable runnable, long duration, TimeUnit timeUnit) {
        return this.eventLoop.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.geyser.getLogger().error("Error thrown in " + this.name() + "'s event loop!", e);
            }
        }, duration, timeUnit);
    }

    protected void tick() {
        try {
            int miningFatigueLevel;
            int hasteLevel;
            int swingTotalDuration;
            boolean shouldShowFog;
            this.pistonCache.tick();
            if (this.spawned && System.currentTimeMillis() - this.lastMovementTimestamp > 3000L) {
                Vector3d position = this.collisionManager.adjustBedrockPosition(this.playerEntity.getPosition(), this.playerEntity.isOnGround(), false);
                if (position != null) {
                    ServerboundMovePlayerPosPacket packet = new ServerboundMovePlayerPosPacket(this.playerEntity.isOnGround(), position.getX(), position.getY(), position.getZ());
                    this.sendDownstreamPacket(packet);
                }
                this.lastMovementTimestamp = System.currentTimeMillis();
            }
            if (this.worldBorder.isResizing()) {
                this.worldBorder.resize();
            }
            boolean bl = shouldShowFog = !this.worldBorder.isWithinWarningBoundaries();
            if (shouldShowFog || this.worldBorder.isCloseToBorderBoundaries()) {
                this.worldBorder.drawWall();
                if (shouldShowFog && !this.isInWorldBorderWarningArea) {
                    this.isInWorldBorderWarningArea = true;
                    this.sendFog("minecraft:fog_crimson_forest");
                }
            }
            if (!shouldShowFog && this.isInWorldBorderWarningArea) {
                this.removeFog("minecraft:fog_crimson_forest");
                this.isInWorldBorderWarningArea = false;
            }
            for (Tickable entity : this.entityCache.getTickableEntities()) {
                entity.tick();
            }
            if (this.armAnimationTicks != -1 && ++this.armAnimationTicks >= (swingTotalDuration = (hasteLevel = Math.max(this.effectCache.getHaste(), this.effectCache.getConduitPower())) > 0 ? 6 - hasteLevel : ((miningFatigueLevel = this.effectCache.getMiningFatigue()) > 0 ? 6 + miningFatigueLevel * 2 : 6))) {
                if (this.sneaking && this.attemptToBlock()) {
                    this.playerEntity.updateBedrockMetadata();
                }
                this.armAnimationTicks = -1;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setAuthenticationData(AuthData authData) {
        this.authData = authData;
    }

    public void startSneaking() {
        if (this.armAnimationTicks == -1) {
            this.attemptToBlock();
        }
        this.setSneaking(true);
    }

    public void stopSneaking() {
        this.disableBlocking();
        this.setSneaking(false);
    }

    private void setSneaking(boolean sneaking) {
        AttributeData speedAttribute;
        this.sneaking = sneaking;
        if (!sneaking && (speedAttribute = this.adjustSpeed()) != null) {
            UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
            attributesPacket.setRuntimeEntityId(this.playerEntity.getGeyserId());
            attributesPacket.setAttributes(Collections.singletonList(speedAttribute));
            this.sendUpstreamPacket(attributesPacket);
        } else {
            if (!this.flying) {
                this.setSneakingPose(sneaking);
            }
            this.collisionManager.updateScaffoldingFlags(false);
        }
        this.playerEntity.updateBedrockMetadata();
        if (this.mouseoverEntity != null) {
            this.mouseoverEntity.updateInteractiveTag();
        }
    }

    private void setSneakingPose(boolean sneaking) {
        if (this.pose == Pose.SNEAKING && !sneaking) {
            this.pose = Pose.STANDING;
            this.playerEntity.setBoundingBoxHeight(this.playerEntity.getDefinition().height());
        } else if (sneaking) {
            this.pose = Pose.SNEAKING;
            this.playerEntity.setBoundingBoxHeight(1.5f);
        }
        this.playerEntity.setFlag(EntityFlag.SNEAKING, sneaking);
    }

    public void setSwimming(boolean swimming) {
        if (swimming) {
            this.pose = Pose.SWIMMING;
            this.playerEntity.setBoundingBoxHeight(0.6f);
        } else {
            this.pose = Pose.STANDING;
            this.playerEntity.setBoundingBoxHeight(this.playerEntity.getDefinition().height());
        }
        this.playerEntity.setFlag(EntityFlag.SWIMMING, swimming);
        this.playerEntity.updateBedrockMetadata();
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
        if (this.sneaking) {
            this.setSneakingPose(!flying);
            this.playerEntity.updateBedrockMetadata();
        }
    }

    public AttributeData adjustSpeed() {
        AttributeData currentPlayerSpeed = this.playerEntity.getAttributes().get((Object)GeyserAttributeType.MOVEMENT_SPEED);
        if (currentPlayerSpeed != null) {
            if (this.pose.equals((Object)Pose.SNEAKING) && !this.sneaking && this.collisionManager.mustPlayerSneakHere() || !this.swimmingInWater && this.playerEntity.getFlag(EntityFlag.SWIMMING) && !this.collisionManager.isPlayerInWater()) {
                AttributeData speedAttribute = GeyserAttributeType.MOVEMENT_SPEED.getAttribute(this.originalSpeedAttribute / 3.32f);
                this.playerEntity.getAttributes().put(GeyserAttributeType.MOVEMENT_SPEED, speedAttribute);
                return speedAttribute;
            }
            if (this.originalSpeedAttribute != currentPlayerSpeed.getValue()) {
                AttributeData speedAttribute = GeyserAttributeType.MOVEMENT_SPEED.getAttribute(this.originalSpeedAttribute);
                this.playerEntity.getAttributes().put(GeyserAttributeType.MOVEMENT_SPEED, speedAttribute);
                return speedAttribute;
            }
        }
        return null;
    }

    private boolean attemptToBlock() {
        ServerboundUseItemPacket useItemPacket;
        ItemMapping shield = this.itemMappings.getStoredItems().shield();
        if (this.playerInventory.getItemInHand().getJavaId() == shield.getJavaId()) {
            useItemPacket = new ServerboundUseItemPacket(Hand.MAIN_HAND, this.worldCache.nextPredictionSequence());
        } else if (this.playerInventory.getOffhand().getJavaId() == shield.getJavaId()) {
            useItemPacket = new ServerboundUseItemPacket(Hand.OFF_HAND, this.worldCache.nextPredictionSequence());
        } else {
            return false;
        }
        this.sendDownstreamPacket(useItemPacket);
        this.playerEntity.setFlag(EntityFlag.BLOCKING, true);
        return true;
    }

    public void activateArmAnimationTicking() {
        this.armAnimationTicks = 0;
        if (this.disableBlocking()) {
            this.playerEntity.updateBedrockMetadata();
        }
    }

    private boolean disableBlocking() {
        if (this.playerEntity.getFlag(EntityFlag.BLOCKING)) {
            ServerboundPlayerActionPacket releaseItemPacket = new ServerboundPlayerActionPacket(PlayerAction.RELEASE_USE_ITEM, Vector3i.ZERO, Direction.DOWN, this.worldCache.nextPredictionSequence());
            this.sendDownstreamPacket(releaseItemPacket);
            this.playerEntity.setFlag(EntityFlag.BLOCKING, false);
            return true;
        }
        return false;
    }

    protected void disableSrvResolving() {
        this.downstream.setFlag("attempt-srv-resolve", false);
    }

    @Override
    public String name() {
        return this.authData.name();
    }

    @Override
    public UUID uuid() {
        return this.authData.uuid();
    }

    @Override
    public String xuid() {
        return this.authData.xuid();
    }

    @Override
    public boolean transfer(@NonNull String address, @IntRange(from=0L, to=65535L) int port) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (address == null || address.isBlank()) {
            throw new IllegalArgumentException("Server address cannot be null or blank");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Server port must be between 0 and 65535, was " + port);
        }
        TransferPacket transferPacket = new TransferPacket();
        transferPacket.setAddress(address);
        transferPacket.setPort(port);
        this.sendUpstreamPacket(transferPacket);
        return true;
    }

    @Override
    public void sendMessage(String message) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid("");
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        textPacket.setMessage(message);
        this.upstream.sendPacket(textPacket);
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public String getLocale() {
        return this.clientData.getLanguageCode();
    }

    public void sendChat(String message) {
        this.sendDownstreamPacket(new ServerboundChatPacket(message, Instant.now().toEpochMilli(), 0L, ByteArrays.EMPTY_ARRAY, false, Collections.emptyList(), null));
    }

    public void sendCommand(String command) {
        this.sendDownstreamPacket(new ServerboundChatCommandPacket(command, Instant.now().toEpochMilli(), 0L, Collections.emptyList(), false, Collections.emptyList(), null));
    }

    public void setServerRenderDistance(int renderDistance) {
        ++renderDistance;
        this.serverRenderDistance = renderDistance = GenericMath.ceil((double)renderDistance * MathUtils.SQRT_OF_TWO);
        ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
        chunkRadiusUpdatedPacket.setRadius(renderDistance);
        this.upstream.sendPacket(chunkRadiusUpdatedPacket);
    }

    public InetSocketAddress getSocketAddress() {
        return this.upstream.getAddress();
    }

    public void sendForm(Form form) {
        this.formCache.showForm(form);
    }

    public void sendForm(org.geysermc.cumulus.form.util.FormBuilder<?, ?, ?> formBuilder) {
        this.formCache.showForm((Form)formBuilder.build());
    }

    @Deprecated
    public void sendForm(org.geysermc.cumulus.Form<?> form) {
        this.sendForm((Form)form.newForm());
    }

    @Deprecated
    public void sendForm(FormBuilder<?, ?> formBuilder) {
        this.sendForm((org.geysermc.cumulus.Form<?>)formBuilder.build());
    }

    private void startGame() {
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.setUniqueEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setRuntimeEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setPlayerGameType(switch (this.gameMode) {
            case GameMode.CREATIVE -> GameType.CREATIVE;
            case GameMode.ADVENTURE -> GameType.ADVENTURE;
            default -> GameType.SURVIVAL;
        });
        startGamePacket.setPlayerPosition(Vector3f.from(0.0f, 69.0f, 0.0f));
        startGamePacket.setRotation(Vector2f.from(1.0f, 1.0f));
        startGamePacket.setSeed(-1L);
        startGamePacket.setDimensionId(DimensionUtils.javaToBedrock(this.dimension));
        startGamePacket.setGeneratorId(1);
        startGamePacket.setLevelGameType(GameType.SURVIVAL);
        startGamePacket.setDifficulty(1);
        startGamePacket.setDefaultSpawn(Vector3i.ZERO);
        startGamePacket.setAchievementsDisabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setCurrentTick(-1L);
        startGamePacket.setEduEditionOffers(0);
        startGamePacket.setEduFeaturesEnabled(false);
        startGamePacket.setRainLevel(0.0f);
        startGamePacket.setLightningLevel(0.0f);
        startGamePacket.setMultiplayerGame(true);
        startGamePacket.setBroadcastingToLan(true);
        startGamePacket.setPlatformBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setXblBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setCommandsEnabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setTexturePacksRequired(false);
        startGamePacket.setBonusChestEnabled(false);
        startGamePacket.setStartingWithMap(false);
        startGamePacket.setTrustingPlayers(true);
        startGamePacket.setDefaultPlayerPermission(PlayerPermission.MEMBER);
        startGamePacket.setServerChunkTickRange(4);
        startGamePacket.setBehaviorPackLocked(false);
        startGamePacket.setResourcePackLocked(false);
        startGamePacket.setFromLockedWorldTemplate(false);
        startGamePacket.setUsingMsaGamertagsOnly(false);
        startGamePacket.setFromWorldTemplate(false);
        startGamePacket.setWorldTemplateOptionLocked(false);
        String serverName = this.geyser.getConfig().getBedrock().getServerName();
        startGamePacket.setLevelId(serverName);
        startGamePacket.setLevelName(serverName);
        startGamePacket.setPremiumWorldTemplateId("00000000-0000-0000-0000-000000000000");
        startGamePacket.setEnchantmentSeed(0);
        startGamePacket.setMultiplayerCorrelationId("");
        startGamePacket.setItemEntries(this.itemMappings.getItemEntries());
        startGamePacket.setVanillaVersion("*");
        startGamePacket.setInventoriesServerAuthoritative(true);
        startGamePacket.setServerEngine("");
        startGamePacket.setPlayerPropertyData(NbtMap.EMPTY);
        startGamePacket.setWorldTemplateId(UUID.randomUUID());
        startGamePacket.setChatRestrictionLevel(ChatRestrictionLevel.NONE);
        SyncedPlayerMovementSettings settings = new SyncedPlayerMovementSettings();
        settings.setMovementMode(AuthoritativeMovementMode.CLIENT);
        settings.setRewindHistorySize(0);
        settings.setServerAuthoritativeBlockBreaking(false);
        startGamePacket.setPlayerMovementSettings(settings);
        this.upstream.sendPacket(startGamePacket);
    }

    public int getNextItemNetId() {
        return this.itemNetId.getAndIncrement();
    }

    public void confirmTeleport(Vector3d position) {
        if (this.unconfirmedTeleport == null) {
            return;
        }
        if (this.unconfirmedTeleport.canConfirm(position)) {
            this.unconfirmedTeleport = null;
            return;
        }
        this.unconfirmedTeleport.incrementUnconfirmedFor();
        if (this.unconfirmedTeleport.shouldResend()) {
            this.unconfirmedTeleport.resetUnconfirmedFor();
            this.geyser.getLogger().debug("Resending teleport " + this.unconfirmedTeleport.getTeleportConfirmId());
            this.getPlayerEntity().moveAbsolute(Vector3f.from(this.unconfirmedTeleport.getX(), this.unconfirmedTeleport.getY(), this.unconfirmedTeleport.getZ()), this.unconfirmedTeleport.getYaw(), this.unconfirmedTeleport.getPitch(), this.playerEntity.isOnGround(), true);
        }
    }

    public void sendUpstreamPacket(BedrockPacket packet) {
        this.upstream.sendPacket(packet);
    }

    public void sendUpstreamPacketImmediately(BedrockPacket packet) {
        this.upstream.sendPacketImmediately(packet);
    }

    public void sendDownstreamPacket(Packet packet) {
        if (!this.closed && this.downstream != null) {
            Channel channel = this.downstream.getChannel();
            if (channel == null) {
                this.geyser.getLogger().warning("Tried to send a packet to the Java server too early!");
                if (this.geyser.getConfig().isDebugMode()) {
                    Thread.dumpStack();
                }
                return;
            }
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.sendDownstreamPacket0(packet);
            } else {
                eventLoop.execute(() -> this.sendDownstreamPacket0(packet));
            }
        }
    }

    private void sendDownstreamPacket0(Packet packet) {
        if (this.protocol.getState().equals((Object)ProtocolState.GAME) || packet.getClass() == ServerboundCustomQueryPacket.class) {
            this.downstream.send(packet);
        } else {
            this.geyser.getLogger().debug("Tried to send downstream packet " + packet.getClass().getSimpleName() + " before connected to the server");
        }
    }

    public void setReducedDebugInfo(boolean value) {
        this.reducedDebugInfo = value;
        this.preferencesCache.updateShowCoordinates();
    }

    public void setDaylightCycle(boolean doCycle) {
        this.sendGameRule("dodaylightcycle", doCycle);
        this.daylightCycle = doCycle;
    }

    public void sendGameRule(String gameRule, Object value) {
        GameRulesChangedPacket gameRulesChangedPacket = new GameRulesChangedPacket();
        gameRulesChangedPacket.getGameRules().add(new GameRuleData<Object>(gameRule, value));
        this.upstream.sendPacket(gameRulesChangedPacket);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.geyser.getWorldManager().hasPermission(this, permission);
    }

    public void sendAdventureSettings() {
        boolean worldImmutable;
        long bedrockId = this.playerEntity.getGeyserId();
        CommandPermission commandPermission = this.opPermissionLevel >= 2 ? CommandPermission.OPERATOR : CommandPermission.NORMAL;
        PlayerPermission playerPermission = this.opPermissionLevel >= 2 ? PlayerPermission.OPERATOR : PlayerPermission.MEMBER;
        boolean spectator = this.gameMode == GameMode.SPECTATOR;
        boolean bl = worldImmutable = this.gameMode == GameMode.ADVENTURE || spectator;
        if (MinecraftProtocol.supports1_19_10(this)) {
            UpdateAdventureSettingsPacket adventureSettingsPacket = new UpdateAdventureSettingsPacket();
            adventureSettingsPacket.setNoMvP(false);
            adventureSettingsPacket.setNoPvM(false);
            adventureSettingsPacket.setImmutableWorld(worldImmutable);
            adventureSettingsPacket.setShowNameTags(false);
            adventureSettingsPacket.setAutoJump(true);
            this.sendUpstreamPacket(adventureSettingsPacket);
            UpdateAbilitiesPacket updateAbilitiesPacket = new UpdateAbilitiesPacket();
            updateAbilitiesPacket.setUniqueEntityId(bedrockId);
            updateAbilitiesPacket.setCommandPermission(commandPermission);
            updateAbilitiesPacket.setPlayerPermission(playerPermission);
            AbilityLayer abilityLayer = new AbilityLayer();
            Set<Ability> abilities = abilityLayer.getAbilityValues();
            if (this.canFly || spectator) {
                abilities.add(Ability.MAY_FLY);
            }
            abilities.add(Ability.BUILD);
            abilities.add(Ability.MINE);
            abilities.add(Ability.DOORS_AND_SWITCHES);
            if (this.gameMode == GameMode.CREATIVE) {
                abilities.add(Ability.INSTABUILD);
            }
            if (commandPermission == CommandPermission.OPERATOR) {
                abilities.add(Ability.OPERATOR_COMMANDS);
            }
            if (this.flying || spectator) {
                if (spectator && !this.flying) {
                    this.flying = true;
                    ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(true);
                    this.sendDownstreamPacket(abilitiesPacket);
                }
                abilities.add(Ability.FLYING);
            }
            if (spectator) {
                abilities.add(Ability.NO_CLIP);
            }
            abilityLayer.setLayerType(AbilityLayer.Type.BASE);
            abilityLayer.setFlySpeed(this.flySpeed);
            abilityLayer.setWalkSpeed(this.walkSpeed == 0.0f ? 0.01f : this.walkSpeed);
            Collections.addAll(abilityLayer.getAbilitiesSet(), USED_ABILITIES);
            updateAbilitiesPacket.getAbilityLayers().add(abilityLayer);
            this.sendUpstreamPacket(updateAbilitiesPacket);
            return;
        }
        AdventureSettingsPacket adventureSettingsPacket = new AdventureSettingsPacket();
        adventureSettingsPacket.setUniqueEntityId(bedrockId);
        adventureSettingsPacket.setCommandPermission(commandPermission);
        adventureSettingsPacket.setPlayerPermission(playerPermission);
        Set<AdventureSetting> flags = adventureSettingsPacket.getSettings();
        if (this.canFly || spectator) {
            flags.add(AdventureSetting.MAY_FLY);
        }
        if (this.flying || spectator) {
            if (spectator && !this.flying) {
                this.flying = true;
                ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(true);
                this.sendDownstreamPacket(abilitiesPacket);
            }
            flags.add(AdventureSetting.FLYING);
        }
        if (worldImmutable) {
            flags.add(AdventureSetting.WORLD_IMMUTABLE);
        }
        if (spectator) {
            flags.add(AdventureSetting.NO_CLIP);
        }
        flags.add(AdventureSetting.AUTO_JUMP);
        this.sendUpstreamPacket(adventureSettingsPacket);
    }

    private int getRenderDistance() {
        if (this.clientRenderDistance != -1) {
            return this.clientRenderDistance;
        }
        return this.serverRenderDistance;
    }

    public void sendJavaClientSettings() {
        ServerboundClientInformationPacket clientSettingsPacket = new ServerboundClientInformationPacket(this.getLocale(), this.getRenderDistance(), ChatVisibility.FULL, true, SKIN_PARTS, HandPreference.RIGHT_HAND, false, true);
        this.sendDownstreamPacket(clientSettingsPacket);
    }

    public void updateStatistics(@Nonnull Object2IntMap<Statistic> statistics) {
        if (this.statistics.isEmpty()) {
            for (CustomStatistic customStatistic : CustomStatistic.values()) {
                this.statistics.put((Object)customStatistic, 0);
            }
        }
        this.statistics.putAll(statistics);
    }

    public void refreshEmotes(List<UUID> emotes) {
        this.emotes.addAll(emotes);
        for (GeyserSession player : this.geyser.getSessionManager().getSessions().values()) {
            ArrayList<UUID> pieces = new ArrayList<UUID>();
            for (UUID piece : emotes) {
                if (!player.getEmotes().contains(piece)) {
                    pieces.add(piece);
                }
                player.getEmotes().add(piece);
            }
            EmoteListPacket emoteList = new EmoteListPacket();
            emoteList.setRuntimeEntityId(player.getPlayerEntity().getGeyserId());
            emoteList.getPieceIds().addAll(pieces);
            player.sendUpstreamPacket(emoteList);
        }
    }

    public void sendFog(String ... fogNameSpaces) {
        this.fogNameSpaces.addAll(Arrays.asList(fogNameSpaces));
        PlayerFogPacket packet = new PlayerFogPacket();
        packet.getFogStack().addAll(this.fogNameSpaces);
        this.sendUpstreamPacket(packet);
    }

    public void removeFog(String ... fogNameSpaces) {
        if (fogNameSpaces.length == 0) {
            this.fogNameSpaces.clear();
        } else {
            this.fogNameSpaces.removeAll(Arrays.asList(fogNameSpaces));
        }
        PlayerFogPacket packet = new PlayerFogPacket();
        packet.getFogStack().addAll(this.fogNameSpaces);
        this.sendUpstreamPacket(packet);
    }

    public boolean canUseCommandBlocks() {
        return this.instabuild && this.opPermissionLevel >= 2;
    }

    public void playSoundEvent(SoundEvent sound, Vector3f position) {
        LevelSoundEvent2Packet packet = new LevelSoundEvent2Packet();
        packet.setPosition(position);
        packet.setSound(sound);
        packet.setIdentifier(":");
        packet.setExtraData(-1);
        this.sendUpstreamPacket(packet);
    }

    public float getEyeHeight() {
        return switch (this.pose) {
            case Pose.SNEAKING -> 1.27f;
            case Pose.SWIMMING, Pose.FALL_FLYING, Pose.SPIN_ATTACK -> 0.4f;
            case Pose.SLEEPING -> 0.2f;
            default -> EntityDefinitions.PLAYER.offset();
        };
    }

    public MinecraftCodecHelper getCodecHelper() {
        return (MinecraftCodecHelper)this.downstream.getCodecHelper();
    }

    @Nonnull
    public GeyserImpl getGeyser() {
        return this.geyser;
    }

    @Nonnull
    public UpstreamSession getUpstream() {
        return this.upstream;
    }

    @Nonnull
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public TcpSession getDownstream() {
        return this.downstream;
    }

    public AuthData getAuthData() {
        return this.authData;
    }

    public BedrockClientData getClientData() {
        return this.clientData;
    }

    public JsonNode getCertChainData() {
        return this.certChainData;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public AuthType getRemoteAuthType() {
        return this.remoteAuthType;
    }

    @Deprecated
    public boolean isMicrosoftAccount() {
        return this.microsoftAccount;
    }

    public SessionPlayerEntity getPlayerEntity() {
        return this.playerEntity;
    }

    public AdvancementsCache getAdvancementsCache() {
        return this.advancementsCache;
    }

    public BookEditCache getBookEditCache() {
        return this.bookEditCache;
    }

    public ChunkCache getChunkCache() {
        return this.chunkCache;
    }

    public EntityCache getEntityCache() {
        return this.entityCache;
    }

    public EntityEffectCache getEffectCache() {
        return this.effectCache;
    }

    public FormCache getFormCache() {
        return this.formCache;
    }

    public LodestoneCache getLodestoneCache() {
        return this.lodestoneCache;
    }

    public PistonCache getPistonCache() {
        return this.pistonCache;
    }

    public PreferencesCache getPreferencesCache() {
        return this.preferencesCache;
    }

    public SkullCache getSkullCache() {
        return this.skullCache;
    }

    public TagCache getTagCache() {
        return this.tagCache;
    }

    public WorldCache getWorldCache() {
        return this.worldCache;
    }

    public TeleportCache getUnconfirmedTeleport() {
        return this.unconfirmedTeleport;
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public boolean isInWorldBorderWarningArea() {
        return this.isInWorldBorderWarningArea;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public Inventory getOpenInventory() {
        return this.openInventory;
    }

    public boolean isClosingInventory() {
        return this.closingInventory;
    }

    public InventoryTranslator getInventoryTranslator() {
        return this.inventoryTranslator;
    }

    public ScheduledFuture<?> getCraftingGridFuture() {
        return this.craftingGridFuture;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public BlockMappings getBlockMappings() {
        return this.blockMappings;
    }

    public ItemMappings getItemMappings() {
        return this.itemMappings;
    }

    public Long2ObjectMap<ClientboundMapItemDataPacket> getStoredMaps() {
        return this.storedMaps;
    }

    public int getBiomeGlobalPalette() {
        return this.biomeGlobalPalette;
    }

    public Int2IntMap getBiomeTranslations() {
        return this.biomeTranslations;
    }

    public Map<Vector3i, ItemFrameEntity> getItemFrameCache() {
        return this.itemFrameCache;
    }

    public Set<Vector3i> getLecternCache() {
        return this.lecternCache;
    }

    public Set<UUID> getPlayerWithCustomHeads() {
        return this.playerWithCustomHeads;
    }

    public boolean isDroppingLecternBook() {
        return this.droppingLecternBook;
    }

    public Vector2i getLastChunkPosition() {
        return this.lastChunkPosition;
    }

    public int getClientRenderDistance() {
        return this.clientRenderDistance;
    }

    public int getServerRenderDistance() {
        return this.serverRenderDistance;
    }

    public boolean isSentSpawnPacket() {
        return this.sentSpawnPacket;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isLoggingIn() {
        return this.loggingIn;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public Pose getPose() {
        return this.pose;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public boolean isSwimmingInWater() {
        return this.swimmingInWater;
    }

    public float getOriginalSpeedAttribute() {
        return this.originalSpeedAttribute;
    }

    public String getDimension() {
        return this.dimension;
    }

    public @MonotonicNonNull JavaDimension getDimensionType() {
        return this.dimensionType;
    }

    public Map<String, JavaDimension> getDimensions() {
        return this.dimensions;
    }

    public Int2ObjectMap<TextDecoration> getChatTypes() {
        return this.chatTypes;
    }

    public int getBreakingBlock() {
        return this.breakingBlock;
    }

    public Vector3i getLastBlockPlacePosition() {
        return this.lastBlockPlacePosition;
    }

    public String getLastBlockPlacedId() {
        return this.lastBlockPlacedId;
    }

    public boolean isInteracting() {
        return this.interacting;
    }

    public Vector3i getLastInteractionBlockPosition() {
        return this.lastInteractionBlockPosition;
    }

    public Vector3f getLastInteractionPlayerPosition() {
        return this.lastInteractionPlayerPosition;
    }

    public Entity getMouseoverEntity() {
        return this.mouseoverEntity;
    }

    public Int2ObjectMap<GeyserRecipe> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public AtomicInteger getLastRecipeNetId() {
        return this.lastRecipeNetId;
    }

    public Int2ObjectMap<GeyserStonecutterData> getStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public boolean isEmulatePost1_13Logic() {
        return this.emulatePost1_13Logic;
    }

    public boolean isEmulatePost1_16Logic() {
        return this.emulatePost1_16Logic;
    }

    public boolean isEmulatePost1_18Logic() {
        return this.emulatePost1_18Logic;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public boolean isSteeringLeft() {
        return this.steeringLeft;
    }

    public boolean isSteeringRight() {
        return this.steeringRight;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }

    public boolean isPlacedBucket() {
        return this.placedBucket;
    }

    public long getLastMovementTimestamp() {
        return this.lastMovementTimestamp;
    }

    public long getLastVehicleMoveTimestamp() {
        return this.lastVehicleMoveTimestamp;
    }

    public boolean isDaylightCycle() {
        return this.daylightCycle;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public int getOpPermissionLevel() {
        return this.opPermissionLevel;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean isInstabuild() {
        return this.instabuild;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean isThunder() {
        return this.thunder;
    }

    public Object2IntMap<Statistic> getStatistics() {
        return this.statistics;
    }

    public boolean isWaitingForStatistics() {
        return this.waitingForStatistics;
    }

    public Set<String> getFogNameSpaces() {
        return this.fogNameSpaces;
    }

    public Set<UUID> getEmotes() {
        return this.emotes;
    }

    public boolean isAdvancedTooltips() {
        return this.advancedTooltips;
    }

    public ScheduledFuture<?> getTickThread() {
        return this.tickThread;
    }

    public ScheduledFuture<?> getLookBackScheduledFuture() {
        return this.lookBackScheduledFuture;
    }

    public com.github.steveice10.mc.protocol.MinecraftProtocol getProtocol() {
        return this.protocol;
    }

    public void setAuthData(AuthData authData) {
        this.authData = authData;
    }

    public void setClientData(BedrockClientData clientData) {
        this.clientData = clientData;
    }

    public void setCertChainData(JsonNode certChainData) {
        this.certChainData = certChainData;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setRemoteAuthType(AuthType remoteAuthType) {
        this.remoteAuthType = remoteAuthType;
    }

    @Deprecated
    public void setMicrosoftAccount(boolean microsoftAccount) {
        this.microsoftAccount = microsoftAccount;
    }

    public void setUnconfirmedTeleport(TeleportCache unconfirmedTeleport) {
        this.unconfirmedTeleport = unconfirmedTeleport;
    }

    public void setOpenInventory(Inventory openInventory) {
        this.openInventory = openInventory;
    }

    public void setClosingInventory(boolean closingInventory) {
        this.closingInventory = closingInventory;
    }

    public void setInventoryTranslator(InventoryTranslator inventoryTranslator) {
        this.inventoryTranslator = inventoryTranslator;
    }

    public void setCraftingGridFuture(ScheduledFuture<?> craftingGridFuture) {
        this.craftingGridFuture = craftingGridFuture;
    }

    public void setBlockMappings(BlockMappings blockMappings) {
        this.blockMappings = blockMappings;
    }

    public void setItemMappings(ItemMappings itemMappings) {
        this.itemMappings = itemMappings;
    }

    public void setBiomeGlobalPalette(int biomeGlobalPalette) {
        this.biomeGlobalPalette = biomeGlobalPalette;
    }

    public void setDroppingLecternBook(boolean droppingLecternBook) {
        this.droppingLecternBook = droppingLecternBook;
    }

    public void setLastChunkPosition(Vector2i lastChunkPosition) {
        this.lastChunkPosition = lastChunkPosition;
    }

    public void setClientRenderDistance(int clientRenderDistance) {
        this.clientRenderDistance = clientRenderDistance;
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setPose(Pose pose) {
        this.pose = pose;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    public void setSwimmingInWater(boolean swimmingInWater) {
        this.swimmingInWater = swimmingInWater;
    }

    public void setOriginalSpeedAttribute(float originalSpeedAttribute) {
        this.originalSpeedAttribute = originalSpeedAttribute;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setDimensionType(@MonotonicNonNull JavaDimension dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setBreakingBlock(int breakingBlock) {
        this.breakingBlock = breakingBlock;
    }

    public void setLastBlockPlacePosition(Vector3i lastBlockPlacePosition) {
        this.lastBlockPlacePosition = lastBlockPlacePosition;
    }

    public void setLastBlockPlacedId(String lastBlockPlacedId) {
        this.lastBlockPlacedId = lastBlockPlacedId;
    }

    public void setInteracting(boolean interacting) {
        this.interacting = interacting;
    }

    public void setLastInteractionBlockPosition(Vector3i lastInteractionBlockPosition) {
        this.lastInteractionBlockPosition = lastInteractionBlockPosition;
    }

    public void setLastInteractionPlayerPosition(Vector3f lastInteractionPlayerPosition) {
        this.lastInteractionPlayerPosition = lastInteractionPlayerPosition;
    }

    public void setMouseoverEntity(Entity mouseoverEntity) {
        this.mouseoverEntity = mouseoverEntity;
    }

    public void setCraftingRecipes(Int2ObjectMap<GeyserRecipe> craftingRecipes) {
        this.craftingRecipes = craftingRecipes;
    }

    public void setStonecutterRecipes(Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes) {
        this.stonecutterRecipes = stonecutterRecipes;
    }

    public void setEmulatePost1_13Logic(boolean emulatePost1_13Logic) {
        this.emulatePost1_13Logic = emulatePost1_13Logic;
    }

    public void setEmulatePost1_16Logic(boolean emulatePost1_16Logic) {
        this.emulatePost1_16Logic = emulatePost1_16Logic;
    }

    public void setEmulatePost1_18Logic(boolean emulatePost1_18Logic) {
        this.emulatePost1_18Logic = emulatePost1_18Logic;
    }

    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public void setSteeringLeft(boolean steeringLeft) {
        this.steeringLeft = steeringLeft;
    }

    public void setSteeringRight(boolean steeringRight) {
        this.steeringRight = steeringRight;
    }

    public void setLastInteractionTime(long lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
    }

    public void setPlacedBucket(boolean placedBucket) {
        this.placedBucket = placedBucket;
    }

    public void setLastMovementTimestamp(long lastMovementTimestamp) {
        this.lastMovementTimestamp = lastMovementTimestamp;
    }

    public void setLastVehicleMoveTimestamp(long lastVehicleMoveTimestamp) {
        this.lastVehicleMoveTimestamp = lastVehicleMoveTimestamp;
    }

    public void setOpPermissionLevel(int opPermissionLevel) {
        this.opPermissionLevel = opPermissionLevel;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public void setInstabuild(boolean instabuild) {
        this.instabuild = instabuild;
    }

    public void setFlySpeed(float flySpeed) {
        this.flySpeed = flySpeed;
    }

    public void setWalkSpeed(float walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public void setRaining(boolean raining) {
        this.raining = raining;
    }

    public void setThunder(boolean thunder) {
        this.thunder = thunder;
    }

    public void setWaitingForStatistics(boolean waitingForStatistics) {
        this.waitingForStatistics = waitingForStatistics;
    }

    public void setAdvancedTooltips(boolean advancedTooltips) {
        this.advancedTooltips = advancedTooltips;
    }

    public void setLookBackScheduledFuture(ScheduledFuture<?> lookBackScheduledFuture) {
        this.lookBackScheduledFuture = lookBackScheduledFuture;
    }
}

