/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.text.GeyserLocale;

public final class ScoreboardUpdater
extends Thread {
    public static final int FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD;
    public static final int SECOND_SCORE_PACKETS_PER_SECOND_THRESHOLD = 250;
    private static final int FIRST_MILLIS_BETWEEN_UPDATES = 250;
    private static final int SECOND_MILLIS_BETWEEN_UPDATES = 1000;
    private static final boolean DEBUG_ENABLED;
    private final GeyserImpl geyser = GeyserImpl.getInstance();
    private long lastUpdate = System.currentTimeMillis();
    private long lastPacketsPerSecondUpdate = System.currentTimeMillis();

    public static void init() {
        new ScoreboardUpdater().start();
    }

    @Override
    public void run() {
        while (!this.geyser.isShuttingDown()) {
            try {
                long timeSpent;
                long timeTillAction = this.getTimeTillNextAction();
                if (timeTillAction > 0L) {
                    this.sleepFor(timeTillAction);
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                Collection<GeyserSession> sessions = this.geyser.getSessionManager().getSessions().values();
                if (currentTime - this.lastPacketsPerSecondUpdate >= 1000L) {
                    this.lastPacketsPerSecondUpdate = currentTime;
                    for (GeyserSession session : sessions) {
                        int newPps;
                        ScoreboardSession scoreboardSession = session.getWorldCache().getScoreboardSession();
                        int oldPps = scoreboardSession.getPacketsPerSecond();
                        scoreboardSession.packetsPerSecond = newPps = scoreboardSession.getPendingPacketsPerSecond().get();
                        scoreboardSession.pendingPacketsPerSecond.set(0);
                        if (oldPps < FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD || newPps >= FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) continue;
                        session.getWorldCache().getScoreboard().onUpdate();
                    }
                }
                if (currentTime - this.lastUpdate >= 250L) {
                    this.lastUpdate = currentTime;
                    for (GeyserSession session : sessions) {
                        boolean reachedSecondThreshold;
                        int millisBetweenUpdates;
                        WorldCache worldCache = session.getWorldCache();
                        ScoreboardSession scoreboardSession = worldCache.getScoreboardSession();
                        int pps = scoreboardSession.getPacketsPerSecond();
                        if (pps < FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD || currentTime - scoreboardSession.lastUpdate < (long)(millisBetweenUpdates = (reachedSecondThreshold = pps >= 250) ? 1000 : 250)) continue;
                        worldCache.getScoreboard().onUpdate();
                        scoreboardSession.lastUpdate = currentTime;
                        if (!DEBUG_ENABLED || currentTime - scoreboardSession.lastLog < 60000L) continue;
                        int threshold = reachedSecondThreshold ? 250 : FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD;
                        this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.scoreboard.updater.threshold_reached.log", session.name(), threshold, pps) + GeyserLocale.getLocaleStringLog("geyser.scoreboard.updater.threshold_reached", (double)millisBetweenUpdates / 1000.0));
                        scoreboardSession.lastLog = currentTime;
                    }
                }
                if (DEBUG_ENABLED && (timeSpent = System.currentTimeMillis() - currentTime) > 0L) {
                    this.geyser.getLogger().info(String.format("Scoreboard updater: took %s ms. Updated %s players", timeSpent, sessions.size()));
                }
                long timeTillNextAction = this.getTimeTillNextAction();
                this.sleepFor(timeTillNextAction);
            }
            catch (Throwable e) {
                this.geyser.getLogger().error("Error while translating scoreboard information!", e);
                this.sleepFor(250L);
            }
        }
    }

    private long getTimeTillNextAction() {
        long currentTime = System.currentTimeMillis();
        long timeUntilNextUpdate = 250L - (currentTime - this.lastUpdate);
        long timeUntilPacketReset = 1000L - (currentTime - this.lastPacketsPerSecondUpdate);
        return Math.min(timeUntilNextUpdate, timeUntilPacketReset);
    }

    private void sleepFor(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        GeyserConfiguration config = GeyserImpl.getInstance().getConfig();
        FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD = Math.min(config.getScoreboardPacketThreshold(), 250);
        DEBUG_ENABLED = config.isDebugMode();
    }

    public static final class ScoreboardSession {
        private final GeyserSession session;
        private final AtomicInteger pendingPacketsPerSecond = new AtomicInteger(0);
        private int packetsPerSecond;
        private long lastUpdate;
        private long lastLog;

        public ScoreboardSession(GeyserSession session) {
            this.session = session;
        }

        public GeyserSession getSession() {
            return this.session;
        }

        public AtomicInteger getPendingPacketsPerSecond() {
            return this.pendingPacketsPerSecond;
        }

        public int getPacketsPerSecond() {
            return this.packetsPerSecond;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public long getLastLog() {
            return this.lastLog;
        }
    }
}

