/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreboardPosition;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geysermc.geyser.scoreboard.Score;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.UpdateType;

public final class Objective {
    private final Scoreboard scoreboard;
    private final long id;
    private boolean active = true;
    private UpdateType updateType = UpdateType.ADD;
    private String objectiveName;
    private ScoreboardPosition displaySlot;
    private String displaySlotName;
    private String displayName = "unknown";
    private int type = 0;
    private Map<String, Score> scores = new ConcurrentHashMap<String, Score>();

    private Objective(Scoreboard scoreboard) {
        this.id = scoreboard.getNextId().getAndIncrement();
        this.scoreboard = scoreboard;
    }

    public Objective(Scoreboard scoreboard, String objectiveName) {
        this(scoreboard);
        this.objectiveName = objectiveName;
        this.active = false;
    }

    public Objective(Scoreboard scoreboard, String objectiveName, ScoreboardPosition displaySlot, String displayName, int type) {
        this(scoreboard);
        this.objectiveName = objectiveName;
        this.displaySlot = displaySlot;
        this.displaySlotName = Objective.translateDisplaySlot(displaySlot);
        this.displayName = displayName;
        this.type = type;
    }

    private static String translateDisplaySlot(ScoreboardPosition displaySlot) {
        return switch (displaySlot) {
            case ScoreboardPosition.BELOW_NAME -> "belowname";
            case ScoreboardPosition.PLAYER_LIST -> "list";
            default -> "sidebar";
        };
    }

    public void registerScore(String id, int score) {
        if (!this.scores.containsKey(id)) {
            long scoreId = this.scoreboard.getNextId().getAndIncrement();
            Score scoreObject = new Score(scoreId, id).setScore(score).setTeam(this.scoreboard.getTeamFor(id)).setUpdateType(UpdateType.ADD);
            this.scores.put(id, scoreObject);
        }
    }

    public void setScore(String id, int score) {
        Score stored = this.scores.get(id);
        if (stored != null) {
            stored.setScore(score).setUpdateType(UpdateType.UPDATE);
            return;
        }
        this.registerScore(id, score);
    }

    public void removeScore(String id) {
        Score stored = this.scores.get(id);
        if (stored != null) {
            stored.setUpdateType(UpdateType.REMOVE);
        }
    }

    public void removeScore0(String id) {
        this.scores.remove(id);
    }

    public Objective setDisplayName(String displayName) {
        this.displayName = displayName;
        if (this.updateType == UpdateType.NOTHING) {
            this.updateType = UpdateType.UPDATE;
        }
        return this;
    }

    public Objective setType(int type) {
        this.type = type;
        if (this.updateType == UpdateType.NOTHING) {
            this.updateType = UpdateType.UPDATE;
        }
        return this;
    }

    public void setActive(ScoreboardPosition displaySlot) {
        if (!this.active) {
            this.active = true;
            this.displaySlot = displaySlot;
            this.displaySlotName = Objective.translateDisplaySlot(displaySlot);
        }
    }

    public void pendingRemove() {
        this.updateType = UpdateType.REMOVE;
    }

    public TeamColor getTeamColor() {
        return switch (this.displaySlot) {
            case ScoreboardPosition.SIDEBAR_TEAM_RED -> TeamColor.RED;
            case ScoreboardPosition.SIDEBAR_TEAM_AQUA -> TeamColor.AQUA;
            case ScoreboardPosition.SIDEBAR_TEAM_BLUE -> TeamColor.BLUE;
            case ScoreboardPosition.SIDEBAR_TEAM_GOLD -> TeamColor.GOLD;
            case ScoreboardPosition.SIDEBAR_TEAM_GRAY -> TeamColor.GRAY;
            case ScoreboardPosition.SIDEBAR_TEAM_BLACK -> TeamColor.BLACK;
            case ScoreboardPosition.SIDEBAR_TEAM_GREEN -> TeamColor.GREEN;
            case ScoreboardPosition.SIDEBAR_TEAM_WHITE -> TeamColor.WHITE;
            case ScoreboardPosition.SIDEBAR_TEAM_YELLOW -> TeamColor.YELLOW;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_RED -> TeamColor.DARK_RED;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_AQUA -> TeamColor.DARK_AQUA;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_BLUE -> TeamColor.DARK_BLUE;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_GRAY -> TeamColor.DARK_GRAY;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_GREEN -> TeamColor.DARK_GREEN;
            case ScoreboardPosition.SIDEBAR_TEAM_DARK_PURPLE -> TeamColor.DARK_PURPLE;
            case ScoreboardPosition.SIDEBAR_TEAM_LIGHT_PURPLE -> TeamColor.LIGHT_PURPLE;
            default -> null;
        };
    }

    public void removed() {
        this.active = false;
        this.updateType = UpdateType.REMOVE;
        this.scores = null;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public ScoreboardPosition getDisplaySlot() {
        return this.displaySlot;
    }

    public String getDisplaySlotName() {
        return this.displaySlotName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getType() {
        return this.type;
    }

    public Map<String, Score> getScores() {
        return this.scores;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }
}

