/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import java.util.Set;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.registry.BlockRegistries;

public final class ItemMapping {
    public static final ItemMapping AIR = new ItemMapping("minecraft:air", "minecraft:air", 0, 0, 0, BlockRegistries.BLOCKS.forVersion(MinecraftProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).getBedrockAirId(), 64, null, null, null, 0, null, false);
    private final String javaIdentifier;
    private final String bedrockIdentifier;
    private final int javaId;
    private final int bedrockId;
    private final int bedrockData;
    private final int bedrockBlockId;
    private final int stackSize;
    private final String toolType;
    private final String toolTier;
    private final String translationString;
    private final int maxDamage;
    private final Set<String> repairMaterials;
    private final boolean hasSuspiciousStewEffect;

    public boolean isBlock() {
        return this.bedrockBlockId != -1;
    }

    public boolean hasTranslation() {
        return this.translationString != null;
    }

    public boolean isTool() {
        return this.toolType != null;
    }

    ItemMapping(String javaIdentifier, String bedrockIdentifier, int javaId, int bedrockId, int bedrockData, int bedrockBlockId, int stackSize, String toolType, String toolTier, String translationString, int maxDamage, Set<String> repairMaterials, boolean hasSuspiciousStewEffect) {
        this.javaIdentifier = javaIdentifier;
        this.bedrockIdentifier = bedrockIdentifier;
        this.javaId = javaId;
        this.bedrockId = bedrockId;
        this.bedrockData = bedrockData;
        this.bedrockBlockId = bedrockBlockId;
        this.stackSize = stackSize;
        this.toolType = toolType;
        this.toolTier = toolTier;
        this.translationString = translationString;
        this.maxDamage = maxDamage;
        this.repairMaterials = repairMaterials;
        this.hasSuspiciousStewEffect = hasSuspiciousStewEffect;
    }

    public static ItemMappingBuilder builder() {
        return new ItemMappingBuilder();
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public String getBedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    public int getJavaId() {
        return this.javaId;
    }

    public int getBedrockId() {
        return this.bedrockId;
    }

    public int getBedrockData() {
        return this.bedrockData;
    }

    public int getBedrockBlockId() {
        return this.bedrockBlockId;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public String getToolType() {
        return this.toolType;
    }

    public String getToolTier() {
        return this.toolTier;
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public Set<String> getRepairMaterials() {
        return this.repairMaterials;
    }

    public boolean isHasSuspiciousStewEffect() {
        return this.hasSuspiciousStewEffect;
    }

    public String toString() {
        return "ItemMapping(javaIdentifier=" + this.getJavaIdentifier() + ", bedrockIdentifier=" + this.getBedrockIdentifier() + ", javaId=" + this.getJavaId() + ", bedrockId=" + this.getBedrockId() + ", bedrockData=" + this.getBedrockData() + ", bedrockBlockId=" + this.getBedrockBlockId() + ", stackSize=" + this.getStackSize() + ", toolType=" + this.getToolType() + ", toolTier=" + this.getToolTier() + ", translationString=" + this.getTranslationString() + ", maxDamage=" + this.getMaxDamage() + ", repairMaterials=" + this.getRepairMaterials() + ", hasSuspiciousStewEffect=" + this.isHasSuspiciousStewEffect() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemMapping)) {
            return false;
        }
        ItemMapping other = (ItemMapping)o;
        if (this.getJavaId() != other.getJavaId()) {
            return false;
        }
        if (this.getBedrockId() != other.getBedrockId()) {
            return false;
        }
        if (this.getBedrockData() != other.getBedrockData()) {
            return false;
        }
        if (this.getBedrockBlockId() != other.getBedrockBlockId()) {
            return false;
        }
        if (this.getStackSize() != other.getStackSize()) {
            return false;
        }
        if (this.getMaxDamage() != other.getMaxDamage()) {
            return false;
        }
        if (this.isHasSuspiciousStewEffect() != other.isHasSuspiciousStewEffect()) {
            return false;
        }
        String this$javaIdentifier = this.getJavaIdentifier();
        String other$javaIdentifier = other.getJavaIdentifier();
        if (this$javaIdentifier == null ? other$javaIdentifier != null : !this$javaIdentifier.equals(other$javaIdentifier)) {
            return false;
        }
        String this$bedrockIdentifier = this.getBedrockIdentifier();
        String other$bedrockIdentifier = other.getBedrockIdentifier();
        if (this$bedrockIdentifier == null ? other$bedrockIdentifier != null : !this$bedrockIdentifier.equals(other$bedrockIdentifier)) {
            return false;
        }
        String this$toolType = this.getToolType();
        String other$toolType = other.getToolType();
        if (this$toolType == null ? other$toolType != null : !this$toolType.equals(other$toolType)) {
            return false;
        }
        String this$toolTier = this.getToolTier();
        String other$toolTier = other.getToolTier();
        if (this$toolTier == null ? other$toolTier != null : !this$toolTier.equals(other$toolTier)) {
            return false;
        }
        String this$translationString = this.getTranslationString();
        String other$translationString = other.getTranslationString();
        if (this$translationString == null ? other$translationString != null : !this$translationString.equals(other$translationString)) {
            return false;
        }
        Set<String> this$repairMaterials = this.getRepairMaterials();
        Set<String> other$repairMaterials = other.getRepairMaterials();
        return !(this$repairMaterials == null ? other$repairMaterials != null : !((Object)this$repairMaterials).equals(other$repairMaterials));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJavaId();
        result = result * 59 + this.getBedrockId();
        result = result * 59 + this.getBedrockData();
        result = result * 59 + this.getBedrockBlockId();
        result = result * 59 + this.getStackSize();
        result = result * 59 + this.getMaxDamage();
        result = result * 59 + (this.isHasSuspiciousStewEffect() ? 79 : 97);
        String $javaIdentifier = this.getJavaIdentifier();
        result = result * 59 + ($javaIdentifier == null ? 43 : $javaIdentifier.hashCode());
        String $bedrockIdentifier = this.getBedrockIdentifier();
        result = result * 59 + ($bedrockIdentifier == null ? 43 : $bedrockIdentifier.hashCode());
        String $toolType = this.getToolType();
        result = result * 59 + ($toolType == null ? 43 : $toolType.hashCode());
        String $toolTier = this.getToolTier();
        result = result * 59 + ($toolTier == null ? 43 : $toolTier.hashCode());
        String $translationString = this.getTranslationString();
        result = result * 59 + ($translationString == null ? 43 : $translationString.hashCode());
        Set<String> $repairMaterials = this.getRepairMaterials();
        result = result * 59 + ($repairMaterials == null ? 43 : ((Object)$repairMaterials).hashCode());
        return result;
    }

    public static class ItemMappingBuilder {
        private String javaIdentifier;
        private String bedrockIdentifier;
        private int javaId;
        private int bedrockId;
        private int bedrockData;
        private int bedrockBlockId;
        private int stackSize;
        private String toolType;
        private String toolTier;
        private String translationString;
        private int maxDamage;
        private Set<String> repairMaterials;
        private boolean hasSuspiciousStewEffect;

        ItemMappingBuilder() {
        }

        public ItemMappingBuilder javaIdentifier(String javaIdentifier) {
            this.javaIdentifier = javaIdentifier;
            return this;
        }

        public ItemMappingBuilder bedrockIdentifier(String bedrockIdentifier) {
            this.bedrockIdentifier = bedrockIdentifier;
            return this;
        }

        public ItemMappingBuilder javaId(int javaId) {
            this.javaId = javaId;
            return this;
        }

        public ItemMappingBuilder bedrockId(int bedrockId) {
            this.bedrockId = bedrockId;
            return this;
        }

        public ItemMappingBuilder bedrockData(int bedrockData) {
            this.bedrockData = bedrockData;
            return this;
        }

        public ItemMappingBuilder bedrockBlockId(int bedrockBlockId) {
            this.bedrockBlockId = bedrockBlockId;
            return this;
        }

        public ItemMappingBuilder stackSize(int stackSize) {
            this.stackSize = stackSize;
            return this;
        }

        public ItemMappingBuilder toolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        public ItemMappingBuilder toolTier(String toolTier) {
            this.toolTier = toolTier;
            return this;
        }

        public ItemMappingBuilder translationString(String translationString) {
            this.translationString = translationString;
            return this;
        }

        public ItemMappingBuilder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        public ItemMappingBuilder repairMaterials(Set<String> repairMaterials) {
            this.repairMaterials = repairMaterials;
            return this;
        }

        public ItemMappingBuilder hasSuspiciousStewEffect(boolean hasSuspiciousStewEffect) {
            this.hasSuspiciousStewEffect = hasSuspiciousStewEffect;
            return this;
        }

        public ItemMapping build() {
            return new ItemMapping(this.javaIdentifier, this.bedrockIdentifier, this.javaId, this.bedrockId, this.bedrockData, this.bedrockBlockId, this.stackSize, this.toolType, this.toolTier, this.translationString, this.maxDamage, this.repairMaterials, this.hasSuspiciousStewEffect);
        }

        public String toString() {
            return "ItemMapping.ItemMappingBuilder(javaIdentifier=" + this.javaIdentifier + ", bedrockIdentifier=" + this.bedrockIdentifier + ", javaId=" + this.javaId + ", bedrockId=" + this.bedrockId + ", bedrockData=" + this.bedrockData + ", bedrockBlockId=" + this.bedrockBlockId + ", stackSize=" + this.stackSize + ", toolType=" + this.toolType + ", toolTier=" + this.toolTier + ", translationString=" + this.translationString + ", maxDamage=" + this.maxDamage + ", repairMaterials=" + this.repairMaterials + ", hasSuspiciousStewEffect=" + this.hasSuspiciousStewEffect + ")";
        }
    }
}

