/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.github.steveice10.packetlib.packet.Packet;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.FileUtils;

public class PacketRegistryPopulator {
    public static void populate() {
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(Translator.class)) {
            Class<?> packet = clazz.getAnnotation(Translator.class).packet();
            GeyserImpl.getInstance().getLogger().debug("Found annotated translator: " + clazz.getCanonicalName() + " : " + packet.getSimpleName());
            try {
                PacketTranslator translator;
                Class<?> targetPacket;
                if (Packet.class.isAssignableFrom(packet)) {
                    targetPacket = packet;
                    translator = (PacketTranslator)clazz.newInstance();
                    Registries.JAVA_PACKET_TRANSLATORS.register(targetPacket, translator);
                    continue;
                }
                if (BedrockPacket.class.isAssignableFrom(packet)) {
                    targetPacket = packet;
                    translator = (PacketTranslator)clazz.newInstance();
                    Registries.BEDROCK_PACKET_TRANSLATORS.register(targetPacket, translator);
                    continue;
                }
                GeyserImpl.getInstance().getLogger().error("Class " + clazz.getCanonicalName() + " is annotated as a translator but has an invalid target packet.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                GeyserImpl.getInstance().getLogger().error("Could not instantiate annotated translator " + clazz.getCanonicalName());
            }
        }
    }
}

