/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.inventory.ComponentItemData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v527.Bedrock_v527;
import com.nukkitx.protocol.bedrock.v534.Bedrock_v534;
import com.nukkitx.protocol.bedrock.v544.Bedrock_v544;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.StoredItemMappings;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.registry.type.PaletteItem;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.geyser.util.collection.FixedInt2IntMap;
import org.geysermc.relocate.jackson.core.type.TypeReference;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class ItemRegistryPopulator {
    public static void populate() {
        Map<String, GeyserMappingItem> items;
        Object2ObjectOpenHashMap paletteVersions = new Object2ObjectOpenHashMap();
        paletteVersions.put("1_19_0", new PaletteVersion(Bedrock_v527.V527_CODEC.getProtocolVersion(), Collections.singletonMap("minecraft:trader_llama_spawn_egg", "minecraft:llama_spawn_egg")));
        paletteVersions.put("1_19_10", new PaletteVersion(Bedrock_v534.V534_CODEC.getProtocolVersion(), Collections.emptyMap()));
        paletteVersions.put("1_19_20", new PaletteVersion(Bedrock_v544.V544_CODEC.getProtocolVersion(), Collections.emptyMap()));
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        TypeReference<Map<String, GeyserMappingItem>> mappingItemsType = new TypeReference<Map<String, GeyserMappingItem>>(){};
        try (InputStream stream = bootstrap.getResource("mappings/items.json");){
            items = GeyserImpl.JSON_MAPPER.readValue(stream, mappingItemsType);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java runtime item IDs", e);
        }
        boolean firstMappingsPass = true;
        FixedInt2IntMap dyeColors = new FixedInt2IntMap();
        for (Map.Entry palette : paletteVersions.entrySet()) {
            JsonNode creativeItemEntries;
            List<PaletteItem> itemEntries;
            TypeReference<List<PaletteItem>> paletteEntriesType = new TypeReference<List<PaletteItem>>(){};
            Object2IntOpenHashMap bedrockIdentifierToId = new Object2IntOpenHashMap();
            bedrockIdentifierToId.defaultReturnValue(Short.MIN_VALUE);
            ArrayList<String> itemNames = new ArrayList<String>();
            try (InputStream stream = bootstrap.getResource(String.format("bedrock/runtime_item_states.%s.json", palette.getKey()));){
                itemEntries = GeyserImpl.JSON_MAPPER.readValue(stream, paletteEntriesType);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load Bedrock runtime item IDs", e);
            }
            Object2ObjectOpenHashMap entries = new Object2ObjectOpenHashMap();
            for (PaletteItem entry : itemEntries) {
                entries.put(entry.getName(), new StartGamePacket.ItemEntry(entry.getName(), (short)entry.getId()));
                bedrockIdentifierToId.put((Object)entry.getName(), entry.getId());
            }
            Object2IntOpenHashMap bedrockBlockIdOverrides = new Object2IntOpenHashMap();
            Object2IntOpenHashMap blacklistedIdentifiers = new Object2IntOpenHashMap();
            try (InputStream stream = bootstrap.getResource(String.format("bedrock/creative_items.%s.json", palette.getKey()));){
                creativeItemEntries = GeyserImpl.JSON_MAPPER.readTree(stream).get("items");
            }
            catch (Exception e) {
                throw new AssertionError("Unable to load creative items", e);
            }
            IntArrayList boats = new IntArrayList();
            IntArrayList buckets = new IntArrayList();
            IntArrayList spawnEggs = new IntArrayList();
            ObjectArrayList carpets = new ObjectArrayList();
            ObjectArrayList mappings = new ObjectArrayList();
            Object2ObjectOpenHashMap identifierToMapping = new Object2ObjectOpenHashMap();
            int netId = 1;
            ArrayList<ItemData> creativeItems = new ArrayList<ItemData>();
            for (JsonNode itemNode : creativeItemEntries) {
                String identifier;
                JsonNode nbtNode;
                JsonNode blockRuntimeIdNode;
                JsonNode countNode;
                int count = 1;
                int damage = 0;
                int blockRuntimeId = 0;
                Object tag = null;
                JsonNode jsonNode = itemNode.get("damage");
                if (jsonNode != null) {
                    damage = jsonNode.asInt();
                }
                if ((countNode = itemNode.get("count")) != null) {
                    count = countNode.asInt();
                }
                if ((blockRuntimeIdNode = itemNode.get("blockRuntimeId")) != null) {
                    blockRuntimeId = blockRuntimeIdNode.asInt();
                }
                if ((nbtNode = itemNode.get("nbt_b64")) != null) {
                    byte[] bytes = Base64.getDecoder().decode(nbtNode.asText());
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    try {
                        tag = (NbtMap)NbtUtils.createReaderLE(bais).readTag();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((identifier = itemNode.get("id").textValue()).equals("minecraft:debug_stick") || identifier.equals("minecraft:empty_map") && damage == 2 || identifier.equals("minecraft:bordure_indented_banner_pattern") || identifier.equals("minecraft:field_masoned_banner_pattern")) continue;
                StartGamePacket.ItemEntry entry = (StartGamePacket.ItemEntry)entries.get(identifier);
                int id = -1;
                if (entry != null) {
                    id = entry.getId();
                }
                if (id == -1) {
                    throw new RuntimeException("Unable to find matching Bedrock item for " + identifier);
                }
                creativeItems.add(ItemData.builder().id(id).damage(damage).count(count).blockRuntimeId(blockRuntimeId).tag((NbtMap)tag).netId(netId++).build());
                if (blockRuntimeId == 0 || blacklistedIdentifiers.containsKey((Object)identifier)) continue;
                if (bedrockBlockIdOverrides.containsKey((Object)identifier)) {
                    bedrockBlockIdOverrides.removeInt((Object)identifier);
                    blacklistedIdentifiers.put((Object)identifier, blockRuntimeId);
                    continue;
                }
                bedrockBlockIdOverrides.put((Object)identifier, blockRuntimeId);
            }
            BlockMappings blockMappings = BlockRegistries.BLOCKS.forVersion(((PaletteVersion)palette.getValue()).protocolVersion());
            int itemIndex = 0;
            int javaFurnaceMinecartId = 0;
            boolean usingFurnaceMinecart = GeyserImpl.getInstance().getConfig().isAddNonBedrockItems();
            ObjectOpenHashSet javaOnlyItems = new ObjectOpenHashSet();
            Collections.addAll(javaOnlyItems, new String[]{"minecraft:spectral_arrow", "minecraft:debug_stick", "minecraft:knowledge_book", "minecraft:tipped_arrow", "minecraft:bundle"});
            if (!usingFurnaceMinecart) {
                javaOnlyItems.add("minecraft:furnace_minecart");
            }
            javaOnlyItems.addAll(((PaletteVersion)palette.getValue()).additionalTranslatedItems().keySet());
            for (Map.Entry entry : items.entrySet()) {
                String javaIdentifier = ((String)entry.getKey()).intern();
                String replacementItem = ((PaletteVersion)palette.getValue()).additionalTranslatedItems().get(javaIdentifier);
                GeyserMappingItem mappingItem = replacementItem != null ? items.get(replacementItem) : (GeyserMappingItem)entry.getValue();
                if (usingFurnaceMinecart && javaIdentifier.equals("minecraft:furnace_minecart")) {
                    javaFurnaceMinecartId = itemIndex++;
                    mappings.add(null);
                    continue;
                }
                String bedrockIdentifier = mappingItem.getBedrockIdentifier();
                int bedrockId = bedrockIdentifierToId.getInt((Object)bedrockIdentifier);
                if (bedrockId == Short.MIN_VALUE) {
                    throw new RuntimeException("Missing Bedrock ID in mappings: " + bedrockIdentifier);
                }
                int stackSize = mappingItem.getStackSize();
                int bedrockBlockId = -1;
                Integer firstBlockRuntimeId = ((GeyserMappingItem)entry.getValue()).getFirstBlockRuntimeId();
                if (firstBlockRuntimeId != null) {
                    int blockIdOverride = bedrockBlockIdOverrides.getOrDefault((Object)bedrockIdentifier, -1);
                    if (blockIdOverride != -1) {
                        bedrockBlockId = blockIdOverride;
                    } else {
                        int aValidBedrockBlockId = blacklistedIdentifiers.getOrDefault((Object)bedrockIdentifier, -1);
                        if (aValidBedrockBlockId == -1) {
                            bedrockBlockId = blockMappings.getBedrockBlockId(firstBlockRuntimeId);
                        } else {
                            NbtMap states;
                            NbtMapBuilder requiredBlockStatesBuilder = NbtMap.builder();
                            String correctBedrockIdentifier = blockMappings.getBedrockBlockStates().get(aValidBedrockBlockId).getString("name");
                            boolean firstPass = true;
                            Integer lastBlockRuntimeId = ((GeyserMappingItem)entry.getValue()).getLastBlockRuntimeId() == null ? firstBlockRuntimeId : ((GeyserMappingItem)entry.getValue()).getLastBlockRuntimeId();
                            for (int i = firstBlockRuntimeId.intValue(); i <= lastBlockRuntimeId; ++i) {
                                int bedrockBlockRuntimeId = blockMappings.getBedrockBlockId(i);
                                NbtMap blockTag = blockMappings.getBedrockBlockStates().get(bedrockBlockRuntimeId);
                                String bedrockName = blockTag.getString("name");
                                if (!bedrockName.equals(correctBedrockIdentifier)) continue;
                                states = blockTag.getCompound("states");
                                if (firstPass) {
                                    firstPass = false;
                                    if (states.size() == 0) {
                                        bedrockBlockId = bedrockBlockRuntimeId;
                                        break;
                                    }
                                    requiredBlockStatesBuilder.putAll(states);
                                    continue;
                                }
                                for (Map.Entry<String, Object> nbtEntry : states.entrySet()) {
                                    Object value = requiredBlockStatesBuilder.get(nbtEntry.getKey());
                                    if (value == null || nbtEntry.getValue().equals(value)) continue;
                                    requiredBlockStatesBuilder.remove(nbtEntry.getKey());
                                }
                                if (requiredBlockStatesBuilder.size() == 0) break;
                            }
                            NbtMap requiredBlockStates = requiredBlockStatesBuilder.build();
                            if (bedrockBlockId == -1) {
                                int i = -1;
                                for (NbtMap blockTag : blockMappings.getBedrockBlockStates()) {
                                    Map.Entry<String, Object> nbtEntry;
                                    ++i;
                                    if (!blockTag.getString("name").equals(correctBedrockIdentifier)) continue;
                                    states = blockTag.getCompound("states");
                                    boolean valid = true;
                                    nbtEntry = requiredBlockStates.entrySet().iterator();
                                    while (nbtEntry.hasNext()) {
                                        Map.Entry nbtEntry2 = (Map.Entry)nbtEntry.next();
                                        if (states.get(nbtEntry2.getKey()).equals(nbtEntry2.getValue())) continue;
                                        valid = false;
                                        break;
                                    }
                                    if (!valid) continue;
                                    bedrockBlockId = i;
                                    break;
                                }
                                if (bedrockBlockId == -1) {
                                    throw new RuntimeException("Could not find a block match for " + (String)entry.getKey());
                                }
                            }
                            for (int j = 0; j < creativeItems.size(); ++j) {
                                ItemData itemData = (ItemData)creativeItems.get(j);
                                if (itemData.getId() != bedrockId) continue;
                                if (itemData.getDamage() != 0) break;
                                NbtMap states2 = blockMappings.getBedrockBlockStates().get(itemData.getBlockRuntimeId()).getCompound("states");
                                boolean valid = true;
                                for (Map.Entry<String, Object> nbtEntry : requiredBlockStates.entrySet()) {
                                    if (states2.get(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                                    valid = false;
                                    break;
                                }
                                if (!valid) continue;
                                creativeItems.set(j, itemData.toBuilder().blockRuntimeId(bedrockBlockId).build());
                                break;
                            }
                        }
                    }
                }
                ItemMapping.ItemMappingBuilder mappingBuilder = ItemMapping.builder().javaIdentifier(javaIdentifier).javaId(itemIndex).bedrockIdentifier(bedrockIdentifier.intern()).bedrockId(bedrockId).bedrockData(mappingItem.getBedrockData()).bedrockBlockId(bedrockBlockId).stackSize(stackSize).maxDamage(mappingItem.getMaxDamage()).hasSuspiciousStewEffect(mappingItem.isHasSuspiciousStewEffect());
                if (mappingItem.getRepairMaterials() != null) {
                    mappingBuilder = mappingBuilder.repairMaterials((Set<String>)new ObjectOpenHashSet(mappingItem.getRepairMaterials()));
                }
                if (mappingItem.getToolType() != null) {
                    mappingBuilder = mappingItem.getToolTier() != null ? mappingBuilder.toolType(mappingItem.getToolType().intern()).toolTier(mappingItem.getToolTier().intern()) : mappingBuilder.toolType(mappingItem.getToolType().intern()).toolTier("");
                }
                if (javaOnlyItems.contains(javaIdentifier)) {
                    mappingBuilder = mappingBuilder.translationString((bedrockBlockId != -1 ? "block." : "item.") + ((String)entry.getKey()).replace(":", "."));
                    GeyserImpl.getInstance().getLogger().debug("Adding " + (String)entry.getKey() + " as an item that needs to be translated.");
                }
                ItemMapping mapping = mappingBuilder.build();
                if (javaIdentifier.contains("boat")) {
                    boats.add(bedrockId);
                } else if (javaIdentifier.contains("bucket") && !javaIdentifier.contains("milk")) {
                    buckets.add(bedrockId);
                } else if (javaIdentifier.contains("_carpet") && !javaIdentifier.contains("moss")) {
                    carpets.add(ItemData.builder().id(mapping.getBedrockId()).damage(mapping.getBedrockData()).count(1).blockRuntimeId(mapping.getBedrockBlockId()).build());
                } else if (javaIdentifier.startsWith("minecraft:music_disc_")) {
                    Registries.RECORDS.register(itemIndex, SoundEvent.valueOf("RECORD_" + javaIdentifier.replace("minecraft:music_disc_", "").toUpperCase(Locale.ENGLISH)));
                } else if (javaIdentifier.endsWith("_spawn_egg")) {
                    spawnEggs.add(mapping.getBedrockId());
                }
                mappings.add(mapping);
                identifierToMapping.put(javaIdentifier, mapping);
                itemNames.add(javaIdentifier);
                if (firstMappingsPass && mappingItem.getDyeColor() != -1) {
                    dyeColors.put(itemIndex, mappingItem.getDyeColor());
                }
                ++itemIndex;
            }
            itemNames.add("minecraft:furnace_minecart");
            short lodestoneCompassId = ((StartGamePacket.ItemEntry)entries.get("minecraft:lodestone_compass")).getId();
            if (lodestoneCompassId == 0) {
                throw new RuntimeException("Lodestone compass not found in item palette!");
            }
            ItemMapping itemMapping = ItemMapping.builder().javaIdentifier("").bedrockIdentifier("minecraft:lodestone_compass").javaId(-1).bedrockId(lodestoneCompassId).bedrockData(0).bedrockBlockId(-1).stackSize(1).build();
            ComponentItemData furnaceMinecartData = null;
            if (usingFurnaceMinecart) {
                int furnaceMinecartId = mappings.size() + 1;
                entries.put("geysermc:furnace_minecart", new StartGamePacket.ItemEntry("geysermc:furnace_minecart", (short)furnaceMinecartId, true));
                mappings.set(javaFurnaceMinecartId, ItemMapping.builder().javaIdentifier("minecraft:furnace_minecart").bedrockIdentifier("geysermc:furnace_minecart").javaId(javaFurnaceMinecartId).bedrockId(furnaceMinecartId).bedrockData(0).bedrockBlockId(-1).stackSize(1).build());
                creativeItems.add(ItemData.builder().netId(netId).id(furnaceMinecartId).count(1).build());
                NbtMapBuilder builder = NbtMap.builder();
                builder.putString("name", "geysermc:furnace_minecart").putInt("id", furnaceMinecartId);
                NbtMapBuilder itemProperties = NbtMap.builder();
                NbtMapBuilder componentBuilder = NbtMap.builder();
                itemProperties.putCompound("minecraft:icon", NbtMap.builder().putString("texture", "minecart_furnace").putString("frame", "0.000000").putInt("frame_version", 1).putString("legacy_id", "").build());
                componentBuilder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", "item.minecartFurnace.name").build());
                List<NbtMap> useOnTag = Collections.singletonList(NbtMap.builder().putString("tags", "q.any_tag('rail')").build());
                componentBuilder.putCompound("minecraft:entity_placer", NbtMap.builder().putList("dispense_on", NbtType.COMPOUND, useOnTag).putString("entity", "minecraft:minecart").putList("use_on", NbtType.COMPOUND, useOnTag).build());
                itemProperties.putBoolean("allow_off_hand", true);
                itemProperties.putBoolean("hand_equipped", false);
                itemProperties.putInt("max_stack_size", 1);
                itemProperties.putString("creative_group", "itemGroup.name.minecart");
                itemProperties.putInt("creative_category", 4);
                componentBuilder.putCompound("item_properties", itemProperties.build());
                builder.putCompound("components", componentBuilder.build());
                furnaceMinecartData = new ComponentItemData("geysermc:furnace_minecart", builder.build());
            }
            ItemMappings itemMappings = ItemMappings.builder().items(mappings.toArray(new ItemMapping[0])).creativeItems(creativeItems.toArray(new ItemData[0])).itemEntries(List.copyOf(entries.values())).itemNames(itemNames.toArray(new String[0])).storedItems(new StoredItemMappings((Map<String, ItemMapping>)identifierToMapping)).javaOnlyItems((Set<String>)javaOnlyItems).bucketIds((IntList)buckets).boatIds((IntList)boats).spawnEggIds((IntList)spawnEggs).carpets((List<ItemData>)carpets).furnaceMinecartData(furnaceMinecartData).lodestoneCompass(itemMapping).build();
            Registries.ITEMS.register(((PaletteVersion)palette.getValue()).protocolVersion(), itemMappings);
            firstMappingsPass = false;
        }
        ItemUtils.setDyeColors((Int2IntMap)dyeColors);
    }

    private record PaletteVersion(int protocolVersion, Map<String, String> additionalTranslatedItems) {
    }
}

