/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ImmutableMap;
import com.nukkitx.nbt.NBTInputStream;
import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.protocol.bedrock.v527.Bedrock_v527;
import com.nukkitx.protocol.bedrock.v544.Bedrock_v544;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.zip.GZIPInputStream;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.collection.Object2IntBiMap;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.geysermc.relocate.jackson.databind.node.ArrayNode;

public final class BlockRegistryPopulator {
    private static JsonNode BLOCKS_JSON;

    public static void populate() {
        BlockRegistryPopulator.registerJavaBlocks();
        BlockRegistryPopulator.registerBedrockBlocks();
        BLOCKS_JSON = null;
    }

    private static void registerBedrockBlocks() {
        BiFunction<String, NbtMapBuilder, String> emptyMapper = (bedrockIdentifier, statesBuilder) -> null;
        ImmutableMap blockMappers = ImmutableMap.builder().put((Object)ObjectIntPair.of((Object)"1_19_0", (int)Bedrock_v527.V527_CODEC.getProtocolVersion()), (bedrockIdentifier, statesBuilder) -> {
            if (bedrockIdentifier.equals("minecraft:muddy_mangrove_roots")) {
                statesBuilder.remove("pillar_axis");
            }
            return null;
        }).put((Object)ObjectIntPair.of((Object)"1_19_20", (int)Bedrock_v544.V544_CODEC.getProtocolVersion()), emptyMapper).build();
        for (Map.Entry palette : blockMappers.entrySet()) {
            NbtList blocksTag;
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource(String.format("bedrock/block_palette.%s.nbt", ((ObjectIntPair)palette.getKey()).key()));
                 NBTInputStream nbtInputStream = new NBTInputStream(new DataInputStream(new GZIPInputStream(stream)), true, true);){
                NbtMap blockPalette = (NbtMap)nbtInputStream.readTag();
                blocksTag = (NbtList)blockPalette.getList("blocks", NbtType.COMPOUND);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to get blocks from runtime block states", e);
            }
            Object2IntOpenHashMap blockStateOrderedMap = new Object2IntOpenHashMap(blocksTag.size());
            int stateVersion = -1;
            for (int i = 0; i < blocksTag.size(); ++i) {
                NbtMapBuilder builder = ((NbtMap)blocksTag.get(i)).toBuilder();
                builder.remove("name_hash");
                NbtMap tag = builder.build();
                if (blockStateOrderedMap.containsKey((Object)tag)) {
                    throw new AssertionError((Object)("Duplicate block states in Bedrock palette: " + tag));
                }
                blockStateOrderedMap.put((Object)tag, i);
                if (stateVersion != -1) continue;
                stateVersion = tag.getInt("version");
            }
            int airRuntimeId = -1;
            int commandBlockRuntimeId = -1;
            int javaRuntimeId = -1;
            int waterRuntimeId = -1;
            int movingBlockRuntimeId = -1;
            Iterator<Map.Entry<String, JsonNode>> blocksIterator = BLOCKS_JSON.fields();
            BiFunction stateMapper = (BiFunction)blockMappers.getOrDefault(palette.getKey(), emptyMapper);
            int[] javaToBedrockBlocks = new int[BLOCKS_JSON.size()];
            Object2ObjectOpenHashMap flowerPotBlocks = new Object2ObjectOpenHashMap();
            Object2IntOpenHashMap itemFrames = new Object2IntOpenHashMap();
            IntOpenHashSet jigsawStateIds = new IntOpenHashSet();
            BlockMappings.BlockMappingsBuilder builder = BlockMappings.builder();
            while (blocksIterator.hasNext()) {
                boolean waterlogged;
                ++javaRuntimeId;
                Map.Entry<String, JsonNode> entry = blocksIterator.next();
                String javaId = entry.getKey();
                int bedrockRuntimeId = blockStateOrderedMap.getOrDefault((Object)BlockRegistryPopulator.buildBedrockState(entry.getValue(), stateVersion, stateMapper), -1);
                if (bedrockRuntimeId == -1) {
                    throw new RuntimeException("Unable to find " + javaId + " Bedrock runtime ID! Built NBT tag: \n" + BlockRegistryPopulator.buildBedrockState(entry.getValue(), stateVersion, stateMapper));
                }
                switch (javaId) {
                    case "minecraft:air": {
                        airRuntimeId = bedrockRuntimeId;
                        break;
                    }
                    case "minecraft:water[level=0]": {
                        waterRuntimeId = bedrockRuntimeId;
                        break;
                    }
                    case "minecraft:command_block[conditional=false,facing=north]": {
                        commandBlockRuntimeId = bedrockRuntimeId;
                        break;
                    }
                    case "minecraft:moving_piston[facing=north,type=normal]": {
                        movingBlockRuntimeId = bedrockRuntimeId;
                    }
                }
                if (javaId.contains("jigsaw")) {
                    jigsawStateIds.add(bedrockRuntimeId);
                }
                boolean bl = waterlogged = entry.getKey().contains("waterlogged=true") || javaId.contains("minecraft:bubble_column") || javaId.contains("minecraft:kelp") || javaId.contains("seagrass");
                if (waterlogged) {
                    int finalJavaRuntimeId = javaRuntimeId;
                    BlockRegistries.WATERLOGGED.register(set -> set.add(finalJavaRuntimeId));
                }
                String cleanJavaIdentifier = BlockUtils.getCleanIdentifier(entry.getKey());
                if (entry.getValue().get("pottable") != null) {
                    flowerPotBlocks.put(cleanJavaIdentifier.intern(), (NbtMap)blocksTag.get(bedrockRuntimeId));
                }
                javaToBedrockBlocks[javaRuntimeId] = bedrockRuntimeId;
            }
            if (commandBlockRuntimeId == -1) {
                throw new AssertionError((Object)"Unable to find command block in palette");
            }
            builder.commandBlockRuntimeId(commandBlockRuntimeId);
            if (waterRuntimeId == -1) {
                throw new AssertionError((Object)"Unable to find water in palette");
            }
            builder.bedrockWaterId(waterRuntimeId);
            if (airRuntimeId == -1) {
                throw new AssertionError((Object)"Unable to find air in palette");
            }
            builder.bedrockAirId(airRuntimeId);
            if (movingBlockRuntimeId == -1) {
                throw new AssertionError((Object)"Unable to find moving block in palette");
            }
            builder.bedrockMovingBlockId(movingBlockRuntimeId);
            for (Object2IntMap.Entry entry : blockStateOrderedMap.object2IntEntrySet()) {
                String name = ((NbtMap)entry.getKey()).getString("name");
                if (!name.equals("minecraft:frame") && !name.equals("minecraft:glow_frame")) continue;
                itemFrames.put((Object)((NbtMap)entry.getKey()), entry.getIntValue());
            }
            builder.bedrockBlockStates(blocksTag);
            BlockRegistries.BLOCKS.register(((ObjectIntPair)palette.getKey()).valueInt(), builder.blockStateVersion(stateVersion).javaToBedrockBlocks(javaToBedrockBlocks).itemFrames((Object2IntMap<NbtMap>)itemFrames).flowerPotBlocks((Map<String, NbtMap>)flowerPotBlocks).jigsawStateIds((IntSet)jigsawStateIds).build());
        }
    }

    private static void registerJavaBlocks() {
        JsonNode blockInteractionsJson;
        JsonNode blocksJson;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource("mappings/blocks.json");){
            blocksJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block mappings", e);
        }
        BlockRegistries.JAVA_BLOCKS.set((BlockMapping)new BlockMapping[blocksJson.size()]);
        ArrayDeque<String> cleanIdentifiers = new ArrayDeque<String>();
        int javaRuntimeId = -1;
        int bellBlockId = -1;
        int cobwebBlockId = -1;
        int furnaceRuntimeId = -1;
        int furnaceLitRuntimeId = -1;
        int honeyBlockRuntimeId = -1;
        int slimeBlockRuntimeId = -1;
        int spawnerRuntimeId = -1;
        int uniqueJavaId = -1;
        int waterRuntimeId = -1;
        Iterator<Map.Entry<String, JsonNode>> blocksIterator = blocksJson.fields();
        while (blocksIterator.hasNext()) {
            JsonNode pickItemNode;
            JsonNode canBreakWithHandNode;
            ++javaRuntimeId;
            Map.Entry<String, JsonNode> entry = blocksIterator.next();
            String javaId = entry.getKey();
            BlockMapping.BlockMappingBuilder builder = BlockMapping.builder();
            JsonNode hardnessNode = entry.getValue().get("block_hardness");
            if (hardnessNode != null) {
                builder.hardness(hardnessNode.doubleValue());
            }
            if ((canBreakWithHandNode = entry.getValue().get("can_break_with_hand")) != null) {
                builder.canBreakWithHand(canBreakWithHandNode.booleanValue());
            } else {
                builder.canBreakWithHand(false);
            }
            JsonNode collisionIndexNode = entry.getValue().get("collision_index");
            if (hardnessNode != null) {
                builder.collisionIndex(collisionIndexNode.intValue());
            }
            if ((pickItemNode = entry.getValue().get("pick_item")) != null) {
                builder.pickItem(pickItemNode.textValue().intern());
            }
            if (javaId.equals("minecraft:obsidian") || javaId.equals("minecraft:crying_obsidian") || javaId.startsWith("minecraft:respawn_anchor") || javaId.startsWith("minecraft:reinforced_deepslate")) {
                builder.pistonBehavior(PistonBehavior.BLOCK);
            } else {
                JsonNode pistonBehaviorNode = entry.getValue().get("piston_behavior");
                if (pistonBehaviorNode != null) {
                    builder.pistonBehavior(PistonBehavior.getByName(pistonBehaviorNode.textValue()));
                } else {
                    builder.pistonBehavior(PistonBehavior.NORMAL);
                }
            }
            JsonNode hasBlockEntityNode = entry.getValue().get("has_block_entity");
            if (hasBlockEntityNode != null) {
                builder.isBlockEntity(hasBlockEntityNode.booleanValue());
            } else {
                builder.isBlockEntity(false);
            }
            BlockStateValues.storeBlockStateValues(entry.getKey(), javaRuntimeId, entry.getValue());
            String cleanJavaIdentifier = BlockUtils.getCleanIdentifier(entry.getKey());
            String bedrockIdentifier = entry.getValue().get("bedrock_identifier").asText();
            if (!cleanJavaIdentifier.equals(cleanIdentifiers.peekLast())) {
                ++uniqueJavaId;
                cleanIdentifiers.add(cleanJavaIdentifier.intern());
            }
            builder.javaIdentifier(javaId);
            builder.javaBlockId(uniqueJavaId);
            BlockRegistries.JAVA_IDENTIFIERS.register(javaId, javaRuntimeId);
            BlockRegistries.JAVA_BLOCKS.register(javaRuntimeId, builder.build());
            BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.register(cleanJavaIdentifier.intern(), bedrockIdentifier.intern());
            if (javaId.startsWith("minecraft:bell[")) {
                bellBlockId = uniqueJavaId;
                continue;
            }
            if (javaId.contains("cobweb")) {
                cobwebBlockId = uniqueJavaId;
                continue;
            }
            if (javaId.startsWith("minecraft:furnace[facing=north")) {
                if (javaId.contains("lit=true")) {
                    furnaceLitRuntimeId = javaRuntimeId;
                    continue;
                }
                furnaceRuntimeId = javaRuntimeId;
                continue;
            }
            if (javaId.startsWith("minecraft:spawner")) {
                spawnerRuntimeId = javaRuntimeId;
                continue;
            }
            if ("minecraft:water[level=0]".equals(javaId)) {
                waterRuntimeId = javaRuntimeId;
                continue;
            }
            if (javaId.equals("minecraft:honey_block")) {
                honeyBlockRuntimeId = javaRuntimeId;
                continue;
            }
            if (!javaId.equals("minecraft:slime_block")) continue;
            slimeBlockRuntimeId = javaRuntimeId;
        }
        if (bellBlockId == -1) {
            throw new AssertionError((Object)"Unable to find bell in palette");
        }
        BlockStateValues.JAVA_BELL_ID = bellBlockId;
        if (cobwebBlockId == -1) {
            throw new AssertionError((Object)"Unable to find cobwebs in palette");
        }
        BlockStateValues.JAVA_COBWEB_ID = cobwebBlockId;
        if (furnaceRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find furnace in palette");
        }
        BlockStateValues.JAVA_FURNACE_ID = furnaceRuntimeId;
        if (furnaceLitRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find lit furnace in palette");
        }
        BlockStateValues.JAVA_FURNACE_LIT_ID = furnaceLitRuntimeId;
        if (honeyBlockRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find honey block in palette");
        }
        BlockStateValues.JAVA_HONEY_BLOCK_ID = honeyBlockRuntimeId;
        if (slimeBlockRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find slime block in palette");
        }
        BlockStateValues.JAVA_SLIME_BLOCK_ID = slimeBlockRuntimeId;
        if (spawnerRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find spawner in palette");
        }
        BlockStateValues.JAVA_SPAWNER_ID = spawnerRuntimeId;
        if (waterRuntimeId == -1) {
            throw new AssertionError((Object)"Unable to find Java water in palette");
        }
        BlockStateValues.JAVA_WATER_ID = waterRuntimeId;
        BlockRegistries.CLEAN_JAVA_IDENTIFIERS.set((String)cleanIdentifiers.toArray(new String[0]));
        BLOCKS_JSON = blocksJson;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource("mappings/interactions.json");){
            blockInteractionsJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block interaction mappings", e);
        }
        BlockRegistries.INTERACTIVE.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("always_consumes")));
        BlockRegistries.INTERACTIVE_MAY_BUILD.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("requires_may_build")));
    }

    private static IntSet toBlockStateSet(ArrayNode node) {
        IntOpenHashSet blockStateSet = new IntOpenHashSet(node.size());
        for (JsonNode javaIdentifier : node) {
            blockStateSet.add(((Object2IntBiMap)BlockRegistries.JAVA_IDENTIFIERS.get()).getInt(javaIdentifier.textValue()));
        }
        return blockStateSet;
    }

    private static NbtMap buildBedrockState(JsonNode node, int blockStateVersion, BiFunction<String, NbtMapBuilder, String> statesMapper) {
        String newIdentifier;
        NbtMapBuilder tagBuilder = NbtMap.builder();
        String bedrockIdentifier = node.get("bedrock_identifier").textValue();
        tagBuilder.putString("name", bedrockIdentifier).putInt("version", blockStateVersion);
        NbtMapBuilder statesBuilder = NbtMap.builder();
        if (node.has("bedrock_states")) {
            Iterator<Map.Entry<String, JsonNode>> statesIterator = node.get("bedrock_states").fields();
            while (statesIterator.hasNext()) {
                Map.Entry<String, JsonNode> stateEntry = statesIterator.next();
                JsonNode stateValue = stateEntry.getValue();
                switch (stateValue.getNodeType()) {
                    case BOOLEAN: {
                        statesBuilder.putBoolean(stateEntry.getKey(), stateValue.booleanValue());
                        break;
                    }
                    case STRING: {
                        statesBuilder.putString(stateEntry.getKey(), stateValue.textValue());
                        break;
                    }
                    case NUMBER: {
                        statesBuilder.putInt(stateEntry.getKey(), stateValue.intValue());
                    }
                }
            }
        }
        if ((newIdentifier = statesMapper.apply(bedrockIdentifier, statesBuilder)) != null) {
            tagBuilder.putString("name", newIdentifier);
        }
        tagBuilder.put("states", (Object)statesBuilder.build());
        return tagBuilder.build();
    }
}

