/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.github.steveice10.mc.protocol.data.game.level.event.LevelEvent;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.translator.level.event.LevelEventTranslator;
import org.geysermc.geyser.translator.level.event.PlaySoundEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundEventEventTranslator;
import org.geysermc.geyser.translator.level.event.SoundLevelEventTranslator;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class SoundEventsRegistryLoader
extends EffectRegistryLoader<Map<LevelEvent, LevelEventTranslator>> {
    @Override
    public Map<LevelEvent, LevelEventTranslator> load(String input) {
        this.loadFile(input);
        Iterator<Map.Entry<String, JsonNode>> effectsIterator = this.get(input).fields();
        Object2ObjectOpenHashMap soundEffects = new Object2ObjectOpenHashMap();
        while (effectsIterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = effectsIterator.next();
            JsonNode node = entry.getValue();
            try {
                String type = node.get("type").asText();
                LevelEvent javaEffect = null;
                Record transformer = null;
                switch (type) {
                    case "soundLevel": {
                        javaEffect = LevelEvent.valueOf(entry.getKey());
                        LevelEventType levelEventType = LevelEventType.valueOf(node.get("name").asText());
                        int data = node.has("data") ? node.get("data").intValue() : 0;
                        transformer = new SoundLevelEventTranslator(levelEventType, data);
                        break;
                    }
                    case "soundEvent": {
                        javaEffect = LevelEvent.valueOf(entry.getKey());
                        SoundEvent soundEvent = SoundEvent.valueOf(node.get("name").asText());
                        String identifier = node.has("identifier") ? node.get("identifier").asText() : "";
                        int extraData = node.has("extraData") ? node.get("extraData").intValue() : -1;
                        transformer = new SoundEventEventTranslator(soundEvent, identifier, extraData);
                        break;
                    }
                    case "playSound": {
                        javaEffect = LevelEvent.valueOf(entry.getKey());
                        String name = node.get("name").asText();
                        float volume = node.has("volume") ? node.get("volume").floatValue() : 1.0f;
                        boolean pitchSub = node.has("pitch_sub") && node.get("pitch_sub").booleanValue();
                        float pitchMul = node.has("pitch_mul") ? node.get("pitch_mul").floatValue() : 1.0f;
                        float pitchAdd = node.has("pitch_add") ? node.get("pitch_add").floatValue() : 0.0f;
                        boolean relative = !node.has("relative") || node.get("relative").booleanValue();
                        transformer = new PlaySoundEventTranslator(name, volume, pitchSub, pitchMul, pitchAdd, relative);
                    }
                }
                if (javaEffect == null) continue;
                soundEffects.put(javaEffect, transformer);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().warning("Failed to map sound effect " + entry.getKey() + " : " + e);
            }
        }
        return soundEffects;
    }
}

