/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.github.steveice10.mc.protocol.data.game.level.particle.ParticleType;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.registry.type.ParticleMapping;
import org.geysermc.relocate.jackson.databind.JsonNode;

public class ParticleTypesRegistryLoader
extends EffectRegistryLoader<Map<ParticleType, ParticleMapping>> {
    @Override
    public Map<ParticleType, ParticleMapping> load(String input) {
        this.loadFile(input);
        Iterator<Map.Entry<String, JsonNode>> particlesIterator = this.get(input).fields();
        Object2ObjectOpenHashMap particles = new Object2ObjectOpenHashMap();
        try {
            while (particlesIterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = particlesIterator.next();
                String key = entry.getKey().toUpperCase(Locale.ROOT);
                JsonNode bedrockId = entry.getValue().get("bedrockId");
                JsonNode eventType = entry.getValue().get("eventType");
                if (eventType == null && bedrockId == null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping particle mapping " + key + " because no Bedrock equivalent exists.");
                    continue;
                }
                particles.put(ParticleType.valueOf(key), new ParticleMapping(eventType == null ? null : LevelEventType.valueOf(eventType.asText().toUpperCase(Locale.ROOT)), bedrockId == null ? null : bedrockId.asText()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return particles;
    }
}

