/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.loader.MultiResourceRegistryLoader;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;
import org.geysermc.geyser.translator.collision.OtherCollision;
import org.geysermc.geyser.translator.collision.SolidCollision;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.relocate.jackson.databind.node.ArrayNode;

public class CollisionRegistryLoader
extends MultiResourceRegistryLoader<String, Int2ObjectMap<BlockCollision>> {
    @Override
    public Int2ObjectMap<BlockCollision> load(Pair<String, String> input) {
        List<BoundingBox[]> collisionList;
        Int2ObjectOpenHashMap collisions = new Int2ObjectOpenHashMap();
        IdentityHashMap annotationMap = new IdentityHashMap();
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(CollisionRemapper.class.getName())) {
            GeyserImpl.getInstance().getLogger().debug("Found annotated collision translator: " + clazz.getCanonicalName());
            CollisionRemapper collisionRemapper = clazz.getAnnotation(CollisionRemapper.class);
            annotationMap.put(clazz, new CollisionInfo(collisionRemapper, Pattern.compile(collisionRemapper.regex()), Pattern.compile(collisionRemapper.paramRegex())));
        }
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResource((String)input.value());){
            ArrayNode collisionNode = (ArrayNode)GeyserImpl.JSON_MAPPER.readTree(stream);
            collisionList = this.loadBoundingBoxes(collisionNode);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load collision data", e);
        }
        BlockMapping[] blockMappings = (BlockMapping[])BlockRegistries.JAVA_BLOCKS.get();
        Object2ObjectOpenHashMap collisionInstances = new Object2ObjectOpenHashMap();
        for (int i = 0; i < blockMappings.length; ++i) {
            BlockMapping blockMapping = blockMappings[i];
            BlockCollision newCollision = this.instantiateCollision(blockMapping, annotationMap, collisionList);
            if (newCollision != null) {
                BlockCollision existingInstance = (BlockCollision)collisionInstances.get(newCollision);
                if (existingInstance != null) {
                    newCollision = existingInstance;
                } else {
                    collisionInstances.put(newCollision, newCollision);
                }
            }
            collisions.put(i, (Object)newCollision);
        }
        return collisions;
    }

    private BlockCollision instantiateCollision(BlockMapping mapping, Map<Class<?>, CollisionInfo> annotationMap, List<BoundingBox[]> collisionList) {
        String[] blockIdParts = mapping.getJavaIdentifier().split("\\[");
        String blockName = blockIdParts[0].replace("minecraft:", "");
        Object params = "";
        if (blockIdParts.length == 2) {
            params = "[" + blockIdParts[1];
        }
        int collisionIndex = mapping.getCollisionIndex();
        for (Map.Entry<Class<?>, CollisionInfo> collisionRemappers : annotationMap.entrySet()) {
            Class<?> type = collisionRemappers.getKey();
            CollisionInfo collisionInfo = collisionRemappers.getValue();
            CollisionRemapper annotation = collisionInfo.collisionRemapper;
            if (!collisionInfo.pattern.matcher(blockName).find() || !collisionInfo.paramsPattern.matcher((CharSequence)params).find()) continue;
            try {
                if (annotation.passDefaultBoxes()) {
                    BoundingBox[] defaultBoxes = collisionList.get(collisionIndex);
                    return (BlockCollision)type.getDeclaredConstructor(String.class, BoundingBox[].class).newInstance(params, defaultBoxes);
                }
                return (BlockCollision)type.getDeclaredConstructor(String.class).newInstance(params);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (collisionIndex == 0) {
            return null;
        }
        if (collisionIndex == 1) {
            return new SolidCollision((String)params);
        }
        return new OtherCollision(collisionList.get(collisionIndex));
    }

    private List<BoundingBox[]> loadBoundingBoxes(ArrayNode collisionNode) {
        ObjectArrayList collisions = new ObjectArrayList();
        for (int collisionIndex = 0; collisionIndex < collisionNode.size(); ++collisionIndex) {
            ArrayNode boundingBoxArray = (ArrayNode)collisionNode.get(collisionIndex);
            BoundingBox[] boundingBoxes = new BoundingBox[boundingBoxArray.size()];
            for (int i = 0; i < boundingBoxArray.size(); ++i) {
                ArrayNode boxProperties = (ArrayNode)boundingBoxArray.get(i);
                boundingBoxes[i] = new BoundingBox(boxProperties.get(0).asDouble(), boxProperties.get(1).asDouble(), boxProperties.get(2).asDouble(), boxProperties.get(3).asDouble(), boxProperties.get(4).asDouble(), boxProperties.get(5).asDouble());
            }
            Arrays.sort(boundingBoxes, Comparator.comparingDouble(BoundingBox::getMiddleY));
            collisions.add(boundingBoxes);
        }
        return collisions;
    }

    public static class CollisionInfo {
        private final CollisionRemapper collisionRemapper;
        private final Pattern pattern;
        private final Pattern paramsPattern;

        public CollisionInfo(CollisionRemapper collisionRemapper, Pattern pattern, Pattern paramsPattern) {
            this.collisionRemapper = collisionRemapper;
            this.pattern = pattern;
            this.paramsPattern = paramsPattern;
        }
    }
}

