/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundTabListPacket;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundLightUpdatePacket;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import io.netty.channel.EventLoop;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.AbstractMappedRegistry;
import org.geysermc.geyser.registry.loader.RegistryLoaders;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;

public class PacketTranslatorRegistry<T>
extends AbstractMappedRegistry<Class<? extends T>, PacketTranslator<? extends T>, IdentityHashMap<Class<? extends T>, PacketTranslator<? extends T>>> {
    private static final Set<Class<?>> IGNORED_PACKETS = Collections.newSetFromMap(new IdentityHashMap());

    protected PacketTranslatorRegistry() {
        super(null, RegistryLoaders.empty(IdentityHashMap::new));
    }

    public <P extends T> boolean translate(Class<? extends P> clazz, P packet, GeyserSession session) {
        if (session.getUpstream().isClosed() || session.isClosed()) {
            return false;
        }
        PacketTranslator translator = (PacketTranslator)((IdentityHashMap)this.mappings).get(clazz);
        if (translator != null) {
            EventLoop eventLoop = session.getEventLoop();
            if (!translator.shouldExecuteInEventLoop() || eventLoop.inEventLoop()) {
                this.translate0(session, translator, packet);
            } else {
                eventLoop.execute(() -> this.translate0(session, translator, packet));
            }
            return true;
        }
        if (!(GeyserImpl.getInstance().getPlatformType() == PlatformType.STANDALONE && packet instanceof BedrockPacket || IGNORED_PACKETS.contains(clazz))) {
            GeyserImpl.getInstance().getLogger().debug("Could not find packet for " + (packet.toString().length() > 25 ? packet.getClass().getSimpleName() : packet));
        }
        return false;
    }

    private <P extends T> void translate0(GeyserSession session, PacketTranslator<P> translator, P packet) {
        if (session.isClosed()) {
            return;
        }
        try {
            translator.translate(session, packet);
        }
        catch (Throwable ex) {
            GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.network.translator.packet.failed", packet.getClass().getSimpleName()), ex);
            ex.printStackTrace();
        }
    }

    public static <T> PacketTranslatorRegistry<T> create() {
        return new PacketTranslatorRegistry<T>();
    }

    static {
        IGNORED_PACKETS.add(ClientboundLightUpdatePacket.class);
        IGNORED_PACKETS.add(ClientboundTabListPacket.class);
    }
}

