/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.channel.ChannelFuture;
import java.net.SocketAddress;
import org.geysermc.geyser.GeyserBootstrap;

public abstract class GeyserInjector {
    protected ChannelFuture localChannel;
    protected SocketAddress serverSocketAddress;

    public void initializeLocalChannel(GeyserBootstrap bootstrap) {
        if (!bootstrap.getGeyserConfig().isUseDirectConnection()) {
            bootstrap.getGeyserLogger().debug("Disabling direct injection!");
            return;
        }
        if (this.localChannel != null) {
            bootstrap.getGeyserLogger().warning("Geyser attempted to inject into the server connection handler twice! Please ensure you aren't using /reload or any plugin that (re)loads Geyser after the server has started.");
            return;
        }
        try {
            this.initializeLocalChannel0(bootstrap);
            bootstrap.getGeyserLogger().debug("Local injection succeeded!");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.shutdown();
        }
    }

    protected abstract void initializeLocalChannel0(GeyserBootstrap var1) throws Exception;

    public void shutdown() {
        if (this.localChannel != null && this.localChannel.channel().isOpen()) {
            try {
                this.localChannel.channel().close().sync();
                this.localChannel = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.localChannel != null) {
            this.localChannel = null;
        }
    }

    public SocketAddress getServerSocketAddress() {
        return this.serverSocketAddress;
    }
}

