/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import com.github.steveice10.mc.protocol.codec.MinecraftCodec;
import com.github.steveice10.mc.protocol.codec.PacketCodec;
import com.nukkitx.protocol.bedrock.BedrockPacketCodec;
import com.nukkitx.protocol.bedrock.v527.Bedrock_v527;
import com.nukkitx.protocol.bedrock.v534.Bedrock_v534;
import com.nukkitx.protocol.bedrock.v544.Bedrock_v544;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.geysermc.geyser.session.GeyserSession;

public final class MinecraftProtocol {
    public static final BedrockPacketCodec DEFAULT_BEDROCK_CODEC = Bedrock_v534.V534_CODEC;
    public static final List<BedrockPacketCodec> SUPPORTED_BEDROCK_CODECS = new ArrayList<BedrockPacketCodec>();
    private static final PacketCodec DEFAULT_JAVA_CODEC = MinecraftCodec.CODEC;

    public static BedrockPacketCodec getBedrockCodec(int protocolVersion) {
        for (BedrockPacketCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            if (packetCodec.getProtocolVersion() != protocolVersion) continue;
            return packetCodec;
        }
        return null;
    }

    public static boolean supports1_19_10(GeyserSession session) {
        return session.getUpstream().getProtocolVersion() >= Bedrock_v534.V534_CODEC.getProtocolVersion();
    }

    public static PacketCodec getJavaCodec() {
        return DEFAULT_JAVA_CODEC;
    }

    public static List<String> getJavaVersions() {
        return List.of(DEFAULT_JAVA_CODEC.getMinecraftVersion(), "1.19.2");
    }

    public static int getJavaProtocolVersion() {
        return DEFAULT_JAVA_CODEC.getProtocolVersion();
    }

    public static String getAllSupportedBedrockVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (BedrockPacketCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            joiner.add(packetCodec.getMinecraftVersion());
        }
        return joiner.toString();
    }

    public static String getAllSupportedJavaVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (String version : MinecraftProtocol.getJavaVersions()) {
            joiner.add(version);
        }
        return joiner.toString();
    }

    private MinecraftProtocol() {
    }

    static {
        SUPPORTED_BEDROCK_CODECS.add(Bedrock_v527.V527_CODEC.toBuilder().minecraftVersion("1.19.0/1.19.2").build());
        SUPPORTED_BEDROCK_CODECS.add(DEFAULT_BEDROCK_CODEC.toBuilder().minecraftVersion("1.19.10/1.19.11").build());
        SUPPORTED_BEDROCK_CODECS.add(Bedrock_v544.V544_CODEC);
    }
}

